/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

Timer *PrimoTimer=NULL;
Timer *UltimoTimer=NULL;

void GetCurrentTime( struct timeval *tv)
{
	(void) gettimeofday(tv,NULL);
}

int timeval_subtract (result, x, y)
          struct timeval *result, *x, *y;
{
	/* Perform the carry for the later subtraction by updating y. */
	if (x->tv_usec < y->tv_usec) 
	{
		int nsec = (y->tv_usec - x->tv_usec) / 1000000 + 1;
		y->tv_usec -= 1000000 * nsec;
		y->tv_sec += nsec;
       }
	if (x->tv_usec - y->tv_usec > 1000000) 
	{
		int nsec = (x->tv_usec - y->tv_usec) / 1000000;
		y->tv_usec += 1000000 * nsec;
		y->tv_sec -= nsec;
	}

	/* Compute the time remaining to wait.
	tv_usec is certainly positive. */
	result->tv_sec = x->tv_sec - y->tv_sec;
	result->tv_usec = x->tv_usec - y->tv_usec;

       /* Return 1 if result is negative. */
	return x->tv_sec < y->tv_sec;
}

Timer *NewTimer ()
{
	Timer *t;
	t=(Timer *) malloc (sizeof(Timer));
	if (t==NULL)
	{
		printf ("Non posso allocare Timer\n");
		exit (1);
	}
	return(t);
}

void FreeTimer (Timer *t)
{
	if (t==UltimoTimer) UltimoTimer=t->Prev;
	if (t==PrimoTimer) PrimoTimer=t->Next;
	if (t->Prev) (t->Prev)->Next=t->Next;
	if (t->Next)(t->Next)->Prev=t->Prev;
	
	free (t);
	t=NULL;
}

void FreeAllTimer ()
{
	Timer *c,*t;
	c=PrimoTimer;
	
	while (c)
	{
		t=c->Next;
		FreeTimer(c);
		c=t;
	}
}

Timer *SetTimerCallBack (int (*Funz)(),void *data,long int interval)
{
	// 
	Timer *t;
	//
	t=NewTimer();

	t->CallBack=Funz;
	t->data=data;
	//
	t->STOP=1;
	t->INTERVAL=interval;
	t->Next=NULL;

	t->Prev=UltimoTimer;
	t->Next=NULL;
	if (PrimoTimer==NULL) PrimoTimer=t;
	if (UltimoTimer) UltimoTimer->Next=t;
	UltimoTimer=t;

	return (t);
}

void TimerStart (Timer *t)
{
	struct timeval tv;

	GetCurrentTime(&tv);
	//printf ("%lu\n",tv.tv_usec);
	//t->BEGIN=tv;
	t->START=tv;
	//(t->START).tv_sec=0; (t->START).tv_usec=0;
	//t->TMP=tv;
        // 10/05/2008
	(t->TMP).tv_sec=0; (t->TMP).tv_usec=0;
        //(t->TMP).tv_sec=(t->START).tv_sec; 
        //(t->TMP).tv_usec=(t->START).tv_usec; 
	//
	t->STOP=0;
}

struct timeval TimerWatch (Timer *t)
{
	struct timeval tv,tv_now;
	if (!t->STOP)
	{
		GetCurrentTime(&tv);
		timeval_subtract (&tv_now, &tv, &t->START);
	}
	else
		tv_now=t->TMP;

	return (tv_now);
}

struct timeval TimerStop (Timer *t)
{
	struct timeval tv;

	if (!t->STOP)
	{
		GetCurrentTime(&tv);
		timeval_subtract (&t->TMP, &tv, &t->START);
	}
	t->STOP=1;
	return (t->TMP);
}

int TimerLook (int *exitcode)
{
	//struct timeval tv;
	Timer *t=PrimoTimer;
        int found=0;
	//int retcode=0;
        //static int z=0;

	struct timeval tv,itv;//,rtv;
	long int ts, tus;
	//
	//TimerDebug();
	while (t && *exitcode==0)
	{
		if (!t->STOP && t->INTERVAL)
		{
			GetCurrentTime(&tv);
			ts = (t->TMP).tv_sec; tus = (t->TMP).tv_usec;
			tus=tus+t->INTERVAL;
			if (tus > 1000000)
			{
				ts++;
				tus=1000000-tus;
			}
			itv.tv_sec=ts; itv.tv_usec=tus;
			//printf ("%lu %lu - %lu %lu - %lu\n",tv.tv_sec	,tv.tv_usec, itv.tv_sec,itv.tv_usec,tus);
			//if (timeval_subtract (&rtv, &itv,&tv)==1)
                        if ( (tv.tv_sec > itv.tv_sec) ||
                            (tv.tv_sec == itv.tv_sec && tv.tv_usec >= itv.tv_usec))
			{
				t->TMP=tv;
                                //printf ("callback %lu\n",(t->TMP).tv_usec);
				*exitcode=(t->CallBack)(t->data);
                                found=1;
			}
		}
		t=t->Next;
	}
	return (found);
}


void TimerDebug ()
{
	Timer *t=PrimoTimer;
	while (t)
	{
		printf ("Timer ptr=%p\n",t);
		printf ("callback=%p\n",t->CallBack);
		printf ("data=%p\n",t->data);
		printf ("STOP=%d\n",t->STOP);
		printf ("INTERVAL=%lu\n",t->INTERVAL);
		t=t->Next;
	}

}

