/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

#define MAXSIGNALS 15

/* Event names.  Used in "type" field in XEvent structures.  Not to be
confused with event masks above.  They start from 2 because 0 and 1
are reserved in the protocol for errors and replies. 

#define KeyPress		2
#define KeyRelease		3
#define ButtonPress		4
#define ButtonRelease		5
#define MotionNotify		6
#define EnterNotify		7
#define LeaveNotify		8
#define FocusIn			9
#define FocusOut		10
#define KeymapNotify		11
#define Expose			12
#define GraphicsExpose		13
#define NoExpose		14
#define VisibilityNotify	15
#define CreateNotify		16
#define DestroyNotify		17
#define UnmapNotify		18
#define MapNotify		19
#define MapRequest		20
#define ReparentNotify		21
#define ConfigureNotify		22
#define ConfigureRequest	23
#define GravityNotify		24
#define ResizeRequest		25
#define CirculateNotify		26
#define CirculateRequest	27
#define PropertyNotify		28
#define SelectionClear		29
#define SelectionRequest	30
#define SelectionNotify		31
#define ColormapNotify		32
#define ClientMessage		33
#define MappingNotify		34
#define LASTEvent		35	// must be bigger than any event # 

*/

SignalHeaderInfo *PrimoSignal=NULL;
SignalHeaderInfo *UltimoSignal=NULL;

void WX11_SignalFree (CmdInfo *Cmd)
{
	int x;
	SignalHeaderInfo *Head=UltimoSignal;
	SignalHeaderInfo *prev, *next;
	while (Head)
	{
		prev=Head->Prev;
		next=Head->Next;
		if (Cmd==NULL || Head->Cmd==Cmd)
		{
			if (Head==PrimoSignal) PrimoSignal=next;
			if (Head==UltimoSignal) UltimoSignal=prev;
			if (prev) prev->Next=next;
			if (next) next->Prev=prev;

			for (x=0;x<Head->num_signals;x++)
				free(Head->signals[x]);
			free (Head->signals);
			free (Head);

			if (Cmd) break;

		}
		Head=prev;
	}
}

void WX11_SignalFreeAll ()
{
	WX11_SignalFree (NULL);
}

SignalInfo *WX11_SignalSearch (SignalHeaderInfo *SignalHead,int Tipo)
{
	int x=0;
	SignalInfo *signal=NULL;

	for (x=0;SignalHead && x<SignalHead->num_signals;x++)
	{
		if (SignalHead->signals[x]->Tipo==Tipo)
		{
			signal=SignalHead->signals[x];
			break;
		}
	}	

	return (signal);
}

SignalHeaderInfo *WX11_SignalHeadSearch (CmdInfo *Cmd)
{
	SignalHeaderInfo *Head=PrimoSignal;
	while (Head && (Head->Cmd != Cmd))
		Head=Head->Next;
	return (Head);
}


void WX11_SetSignalCallBack (void *Cmd,int Tipo,int (*CallBack)(),void *data)
{
	SignalHeaderInfo *Head;
	SignalInfo *signal;
	SignalInfo ** signals;
	int num_signals=0;
	Head=WX11_SignalHeadSearch (Cmd);
	if (Head==NULL)
	{
		Head = (SignalHeaderInfo *) malloc (sizeof(SignalHeaderInfo));
		if (Head==NULL)
		{
			printf ("Non posso allocare SetSignalHeaderInfo\n");
			exit (1);
		}
		signals=calloc(MAXSIGNALS,sizeof(*signals));
		if (signals==NULL)
		{
			printf ("Non posso allocare signals\n");
			exit (1);
		}

		
		if (!PrimoSignal) PrimoSignal=Head;
		if (UltimoSignal) UltimoSignal->Next=Head;
		Head->Prev=UltimoSignal;
		Head->Next=NULL;
		UltimoSignal=Head;

		Head->Cmd=Cmd;
		Head->num_signals=0;
		Head->signals=signals;

		if (IsComando((CmdInfo *)Cmd))
			((CmdInfo *)Cmd)->signal=Head;
		else if (IsListCmd((ListCmdInfo *)Cmd))
			((ListCmdInfo *)Cmd)->signal=Head;

	}
	
	num_signals=Head->num_signals;
	signals=Head->signals;
	signal=WX11_SignalSearch (Head,Tipo);
	
	if (signal==NULL)
	{
		
		signals[num_signals] = (SignalInfo *) malloc (sizeof(SignalInfo));
		signal=signals[num_signals];
		if (signal==NULL)
		{
			printf ("Non posso allocare SetSignalInfo\n");
			exit (1);
		}
		
		(Head->num_signals)++;

	}

	signal->Tipo=Tipo;
	signal->CallBack=CallBack;
	signal->data=data;

}

int WX11_SignalExecCallBack(CmdInfo *Cmd,int Tipo)
{
	SignalHeaderInfo *Head=NULL;
	SignalInfo *signal;
	int retcode=0;

	if (Cmd) Head=(SignalHeaderInfo *)Cmd->signal;
	//Head=WX11_SignalHeadSearch (Cmd);
	if (Head==NULL) return 0; 	// No signals founds
	signal=WX11_SignalSearch (Head,Tipo);
	if (signal==NULL) return 0;	// No signal Tipo 
	
	if (signal->CallBack)
	{

		retcode=(signal->CallBack) (Cmd,Tipo,signal->data);//(signal->data);
		return (retcode);
		
	}
	else
		printf ("no callback\n");
	return 0;
}

void debugsignal()
{
	int x;
	SignalHeaderInfo *Head=PrimoSignal;
	printf ("---Start\n");
	while (Head)
	{
		printf ("Head = %p\n",Head);
		for (x=0;x<Head->num_signals;x++)
			printf ("\tsignal %d\n",Head->signals[x]->Tipo);
		Head=Head->Next;
	}
	printf ("---End\n");
}
