/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

int WX11_INTERLINE_SPACE;

int WX11_ListBoxSelectedItem (CmdInfo *cmd)
{
    //
    // Viene chiamata in automatico alla
    // pressione di un comando di Tipo 
    // LIST_BOX
    //
    CmdInfo * tmp;
    ListCmdInfo * ListCmd;
    ListCmdItemInfo * ListCmdItem;
    //
    tmp=CercaComando (cmd->parent);
    ListCmd=CercaListCmdInfo (tmp);
    if (ListCmd)
    {
        if (ListCmd->CorrenteItem)
        {
            tmp=(ListCmd->CorrenteItem)->Cmd;
            tmp->Focus=0;
            tmp->Stato=0;
            WX11_PrintFlush(tmp);
        }
        ListCmdItem=CercaListCmdItemInfo (ListCmd, cmd->win);
        if (!ListCmdItem)
        {
            printf ("error in ListBoxSelectedItem\n");
            exit(1);
        }
        ListCmd->CorrenteItem=ListCmdItem;
    }
    cmd->Focus=1;
    cmd->Stato=1;
    WX11_PrintFlush(cmd);

    return (0);

}

void WX11_ListBox (CmdInfo *cmd,ListCmdInfo *ListCmd, int width, int height, char *say)
{

    ListCmdItemInfo *listboxitem;
    CmdInfo *area,*item;

    int BordoMenu=2;
    //int AltezzaComando=WX11_FontHeight()+4;
    int LarghezzaComando=0;
    int AltezzaComando=0,AltezzaTotale=0;

    int x=0;
    int y=0;
    //int LarghezzaComando=0;
    int AltezzaFinestraComandi=0;
    unsigned int colorbg=WX11_ColorGet(LISTBOXBG);
    unsigned int colorfg=WX11_ColorGet(LISTBOXFG);

    int giro;
    int TipoScroll=0;

    if (!ListCmd)
        return;

    //LarghezzaComando=(ListCmd->MaxLenItem)*WX11_FontWidth ();
    //if (LarghezzaComando<width) 
    //    LarghezzaComando=width;
	
    AltezzaFinestraComandi=height;

    WX11_Say (cmd, say);
    WX11_Locate (cmd,0,&x,&y);

    area=ApreArea (cmd,
        x,y+BordoMenu+1,width ,AltezzaFinestraComandi+1,
        colorbg,colorfg,BordoMenu);

    // Forza il Rilievo Down
    area->BUpDn=0;
	
    // Prova colore tridimensionale
    //WX11_ColorBackgroundSet (area, WX11_ColorDarkSmall(colorbg),  WX11_ColorLightSmall(colorbg));

    ListCmd->CmdPar=area;
    ListCmd->CmdOpen=NULL;
    ListCmd->CmdInput=NULL; // x ComboBox

    listboxitem=ListCmd->PrimoItem;

    for (giro=0;giro<ListCmd->NumeroItem;giro++)
    {

        WX11_PrintDimensions (listboxitem->Buff,&LarghezzaComando,&AltezzaComando);
    	if (LarghezzaComando<width) 
            LarghezzaComando=width;

        item=WX11_CmdOpen (listboxitem->Tipo,
            area, 
            0, 
            AltezzaTotale,//0+(AltezzaComando * giro),
            LarghezzaComando,
            AltezzaComando,
            colorbg, colorfg,
            0,
            listboxitem->Buff);

	AltezzaTotale+=AltezzaComando;

        if (listboxitem->Tipo!=LABEL)
            ListCmdMakeSignals (item, ListCmd->signal);

        listboxitem->Cmd=item;

        listboxitem=listboxitem->Next;

    }
	
    if ((area->scroll_max_y) > (area->Height)+1)
        TipoScroll+=1;
    if ((area->scroll_max_x) > (area->Width)+1)
        TipoScroll+=2;

    if (TipoScroll)
        WX11_ScrollBar (area,TipoScroll);

    x=0;y+=height+(BordoMenu*2)+WX11_INTERLINE_SPACE;
    WX11_Locate (cmd,1,&x,&y);

}

int xClearAllListBoxItem (ListCmdInfo *ViewComment)
{
    //
    // Cancella TUTTO nella ListBoxItem
    // (compreso il comando) 
    // mantiene la struttura ListBox
    //
    ListCmdItemInfo *Next=NULL;
    ListCmdItemInfo *Item=NULL;
    int NumeroItem=0;
    int z=0;

    NumeroItem=ViewComment->NumeroItem;
    Item=ViewComment->UltimoItem;
    for (z=NumeroItem;z;z--)
    {
        Next=Item->Prev;
        ChiudeComando (Item->Cmd);
        WX11_ListCmdFreeItem (ViewComment,Item);
        Item=Next;
    }

    ViewComment->CorrenteItem=NULL;
    ViewComment->NumeroItem=0;
    ViewComment->MaxLenItem=0;

    //qui cancella eventuali scroll
    xFreeSubCmd (ViewComment->CmdPar);

    return(0);
}

void WX11_ListBoxRefresh (ListCmdInfo *ListCmd)
{
    CmdInfo *area,*item;
    ListCmdItemInfo *listboxitem;
    int larghezza=(ListCmd->CmdPar)->Width;
    int LarghezzaComando=0;
    int AltezzaComando=0,AltezzaTotale=0;
    unsigned int colorbg=WX11_ColorGet(LISTBOXBG);
    unsigned int colorfg=WX11_ColorGet(LISTBOXFG);
    int giro;
    int TipoScroll=0;

    area=ListCmd->CmdPar;

    // Reset Scrolling values
    area->scrollv=NULL;
    area->scrollh=NULL;
    area->scroll_max_y=0;
    area->scroll_max_x=0;
    area->scroll_y=0;
    area->scroll_x=0;

    listboxitem=ListCmd->PrimoItem;
    for (giro=0;giro<ListCmd->NumeroItem;giro++)
    {

        WX11_PrintDimensions (listboxitem->Buff,&LarghezzaComando,&AltezzaComando);
    	if (LarghezzaComando<larghezza) 
            LarghezzaComando=larghezza;

        item=WX11_CmdOpen (listboxitem->Tipo,
            area, 
            0,
            AltezzaTotale,
            LarghezzaComando,
            AltezzaComando,
            colorbg, colorfg,
            0,
            listboxitem->Buff);

	AltezzaTotale+=AltezzaComando;

        if (listboxitem->Tipo!=LABEL)
            ListCmdMakeSignals (item, ListCmd->signal);

        listboxitem->Cmd=item;
        listboxitem=listboxitem->Next;
    }

    if ((area->scroll_max_y) > (area->Height)+1)
        TipoScroll+=1;
    if ((area->scroll_max_x) > (area->Width)+1)
        TipoScroll+=2;

    if (TipoScroll)
        WX11_ScrollBar (area,TipoScroll);
}

