/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

Display * WX11_Dspy(Display *dspy)
{
	static Display *display;

	if (dspy) display=dspy;

	return (display);
}

Display * WX11_GetDisplay()
{
	return (WX11_Dspy(NULL));
}

Display *WX11_OpenDisplay ()
{
	Display *display;

	display=XOpenDisplay("");
	if (display==NULL) WX11_FatalError ("Non posso aprire il display");

	WX11_Dspy(display);

	return (display);
}
void WX11_CloseDisplay ()
{
	EndFinestre ();
	XCloseDisplay(WX11_GetDisplay());
}

int WX11_GetNumScreen ()
{
	return(DefaultScreen(WX11_GetDisplay()));
}

int WX11_GetDisplayWidth ()
{
	return (DisplayWidth(WX11_GetDisplay(), WX11_GetNumScreen()));
}

int WX11_GetDisplayHeight ()
{
	return (DisplayHeight(WX11_GetDisplay(), WX11_GetNumScreen()));
}

int WX11_GetDepth ()
{
	return (DefaultDepth(WX11_GetDisplay(),WX11_GetNumScreen ()));
}

int InitFinestre (int argc, char **argv)
{
	PathEsecuzione (argv[0]);

	WX11_OpenDisplay ();
        WX11_GCInit();

	WX11_FontOpen("9x15");
/*
//	WX11_ColorSet (WINFG,GIALLO); WX11_ColorSet(WINBG,WX11_ColorDark(AZZURRO));
//	WX11_ColorSet (BUTTONFG,GIALLO); WX11_ColorSet (BUTTONBG,WX11_ColorDark(AZZURRO));
	WX11_ColorSet (WINFG,BIANCO); WX11_ColorSet(WINBG,WX11_ColorDark(AZZURRO));
	WX11_ColorSet (BUTTONFG,BIANCO); WX11_ColorSet (BUTTONBG,WX11_ColorDark(AZZURRO));


	WX11_ColorSet (INPUTFG,GIALLO); WX11_ColorSet (INPUTBG,WX11_ColorDark(AZZURRO));	
	WX11_ColorSet (MENUFG,GIALLO); WX11_ColorSet (MENUBG,WX11_ColorDark(AZZURRO));
	WX11_ColorSet (LISTBOXFG,GIALLO); WX11_ColorSet (LISTBOXBG,WX11_ColorDark(AZZURRO));
*/




	WX11_ColorSet (WINFG,GRIGIO20); WX11_ColorSet(WINBG,GRIGIO80);
	WX11_ColorSet (BUTTONFG,GRIGIO20); WX11_ColorSet (BUTTONBG,GRIGIO80);
	WX11_ColorSet (INPUTFG,GRIGIO10); WX11_ColorSet (INPUTBG,GRIGIO80);
	WX11_ColorSet (MENUFG,GRIGIO20); WX11_ColorSet (MENUBG,GRIGIO80);
	WX11_ColorSet (LISTBOXFG,GRIGIO20); WX11_ColorSet (LISTBOXBG,GRIGIO80);

	return (0);
}

int EndFinestre ()
{
	WX11_FontFreeAll ();	
	WX11_SignalFreeAll();
	FreeAllTimer();
	xFreeCmd (PrimoComando(0, NULL));
	
	WX11_ListCmdFreeUnused ();
	WX11_Menu_free ();
	xphonya_free_all_exit ();
	return (0);
}

