/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include "finestre.h"

FontInfo *PrimoFont (int Mode, FontInfo *font)
{
	static FontInfo *Primo=NULL;
	if (Mode)
		Primo=font;

	return (Primo);
}

FontInfo *UltimoFont (int Mode, FontInfo *font)
{
	static FontInfo *Ultimo=NULL;
	if (Mode)
		Ultimo=font;

	return (Ultimo);
}

void WX11_FontFree (FontInfo *font)
{
	if (font==UltimoFont(0,NULL)) UltimoFont(1,font->Prev);
	if (font==PrimoFont(0,NULL)) PrimoFont(1,font->Next);
	if (font->Prev) (font->Prev)->Next=font->Next;
	if (font->Next)(font->Next)->Prev=font->Prev;
	
	//printf ("Freeing Font %p\n",font);
	XFreeFont(WX11_GetDisplay(), font->Font);
	
	free (font);
	font=NULL;
}

void WX11_FontFreeAll ()
{
	FontInfo *c,*t;
	c=PrimoFont(0,NULL);
	
	while (c)
	{
		t=c->Next;
		WX11_FontFree(c);
		c=t;
	}
}


FontInfo *WX11_AddFont (char *FontName,XFontStruct *Font)
{
	//
	// Aggiunge Font
	//
	FontInfo *NewFontStruct;
	FontInfo *Ultimo;

	NewFontStruct=(FontInfo *) malloc (sizeof(FontInfo));
	if (!NewFontStruct)	WX11_FatalError ("Non posso allocare WX11_AddFont");

	Ultimo=UltimoFont (0,NULL);
	if (!Ultimo)
		PrimoFont(1,NewFontStruct);
	else
		Ultimo->Next=NewFontStruct;

	//
	NewFontStruct->FontName=FontName;
	NewFontStruct->Font=Font;
	//
	NewFontStruct->Prev=Ultimo;
	NewFontStruct->Next=NULL;

	UltimoFont(1,NewFontStruct);

	return (NewFontStruct);	
}

XFontStruct *CercaFontName (char *FontName)
{
	FontInfo *cFont=PrimoFont(0,NULL);	
	XFontStruct *rFont=NULL;
	int f=0;

	while (cFont && !f)
	{
		if (strcmp(cFont->FontName,FontName)==0)
		{
			rFont=cFont->Font;
			f=1;
		}
		else
			cFont=cFont->Next;
	}
	
	return (rFont);
}

XFontStruct *WX11_FontOpen(char *Fontname)
{
	static XFontStruct *font=NULL;
	GC gc;
	if (Fontname)
	{
		gc=WX11_GCGet();

		font=CercaFontName (Fontname);
		if (!font)
		{
			font=XLoadQueryFont(WX11_GetDisplay(), Fontname);
			if (!font) return (NULL);
			WX11_AddFont (Fontname,font);
		}
		XSetFont(WX11_GetDisplay(), gc, font->fid);
	}

	return (font);
}

void WX11_FontSetCmd (CmdInfo *cmd,char *Fontname)
{
	XFontStruct *font=NULL;
	GC gc;
	if (Fontname)
	{
		gc=WX11_GCGet();
		font=CercaFontName (Fontname);
		if (!font)
		{
			font=XLoadQueryFont(WX11_GetDisplay(), Fontname);
			if (!font) return ;
			WX11_AddFont (Fontname,font);
		}
	}
	cmd->Font=font;
}

XFontStruct *WX11_FontCurrent ()
{
	return (WX11_FontOpen(NULL));
}

int WX11_FontWidth ()
{
	if (WX11_FontCurrent()==NULL)
		return (9);

	return (XTextWidth(WX11_FontCurrent(),"X",1));
}

int WX11_FontHeight ()
{
	if (WX11_FontCurrent()==NULL)
		return (15);

	return(WX11_FontCurrent()->ascent);
}

