# vim:noexpandtab:autoindent:tabstop=8:shiftwidth=8:filetype=make:
#-----------------------------------------------------------------------------
#push
sp 				:= $(sp).x
dirstack_$(sp)	:= $(d)
d				:= $(dir)
#-----------------------------------------------------------------------------


testPlatform_LIBS := $(d)/../main.o
testPlatform_LIBS += $(d)/testPlatform.o 
testPlatform_LDFLAGS += $(call get_ldflags,smbios) 
testPlatform_LDFLAGS += $(call get_ldflags,smbiosxml) 
testPlatform_LDFLAGS += $(XMLLIBFLAG)

-include $(patsubst %.o, %.d, $(testPlatform_LIBS))

testPlatform_LDFLAGS += -Lcppunit/ -lcppunit  -ldl
cppunit/testPlatform: $(testPlatform_LIBS) $(BASE_LIBS) $(EXT_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING UNIT TEST"
	$(SIL)$(CXX) $($(shell basename $(@:%=%_LIBS))) $($(shell basename $(@:%=%_LIBS_NOD))) $(LDFLAGS) $($(shell basename $(@:%=%_LDFLAGS))) -o $@

cppunit/testPlatform-debug: $(testPlatform_LIBS:%.o=%.do) $(BASE_STATIC_DEBUG_LIBS) $(EXT_STATIC_DEBUG_LIBS)
	@[ "$(SIL)" == "" ] || echo "COMPILING DEBUG UNIT TEST"
	$(SIL)$(CXX) $(debug_flags) $(testPlatform_LIBS:%.o=%.do) $(LDFLAGS) -Lcppunit/ -lcppunit -ldl $(BASE_STATIC_DEBUG_LIBS) $(XMLLIBFLAG) $(EXT_STATIC_DEBUG_LIBS) $(XMLLIBFLAG) -o $@

CLEAN_LIST += cppunit/testPlatform cppunit/testPlatform-debug

# Pop dir stack back to what it was
d		:= $(dirstack_$(sp))
sp		:= $(basename $(sp))
