/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbmlcs {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html Base node for AST classes.
 * @internal
 */

public class ASTBase : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal ASTBase(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(ASTBase obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (ASTBase obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~ASTBase() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_ASTBase(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  
/**
   * Creates a copy (clone).
   */ /* libsbml-internal */ public
 ASTBase deepCopy() {
	ASTBase ret = (ASTBase) libsbml.DowncastASTBase(libsbmlPINVOKE.ASTBase_deepCopy(swigCPtr), false);
	return ret;
}

  
/** */ /* libsbml-internal */ public
 void loadASTPlugins(SBMLNamespaces sbmlns) {
    libsbmlPINVOKE.ASTBase_loadASTPlugins(swigCPtr, SBMLNamespaces.getCPtr(sbmlns));
  }

  
/**
   * Get the type of this ASTNode.  The value returned is one of the
   * enumeration values such as @link libsbmlcs.libsbml.AST_LAMBDA
   * AST_LAMBDA@endlink, @link libsbmlcs.libsbml.AST_PLUS AST_PLUS@endlink,
   * etc.
   * 
   * @return the type of this ASTNode.
   */ /* libsbml-internal */ public
 int getType() {
    int ret = libsbmlPINVOKE.ASTBase_getType(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int getExtendedType() {
    int ret = libsbmlPINVOKE.ASTBase_getExtendedType(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isSetType() {
    bool ret = libsbmlPINVOKE.ASTBase_isSetType(swigCPtr);
    return ret;
  }

  
/**
   * Sets the type of this ASTNode to the given type code.  A side-effect
   * of doing this is that any numerical values previously stored in this
   * node are reset to zero.
   *
   * @param type the type to which this node should be set
   *
   * @return integer value indicating success/failure of the
   * function.  The possible values returned by this function are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE @endlink
   */ /* libsbml-internal */ public
 int setType(int type) {
    int ret = libsbmlPINVOKE.ASTBase_setType__SWIG_0(swigCPtr, type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isAvogadro() {
    bool ret = libsbmlPINVOKE.ASTBase_isAvogadro(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isBoolean() {
    bool ret = libsbmlPINVOKE.ASTBase_isBoolean(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isBinaryFunction() {
    bool ret = libsbmlPINVOKE.ASTBase_isBinaryFunction(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isConstant() {
    bool ret = libsbmlPINVOKE.ASTBase_isConstant(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isExponential() {
    bool ret = libsbmlPINVOKE.ASTBase_isExponential(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isCiNumber() {
    bool ret = libsbmlPINVOKE.ASTBase_isCiNumber(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isConstantNumber() {
    bool ret = libsbmlPINVOKE.ASTBase_isConstantNumber(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isCSymbolFunction() {
    bool ret = libsbmlPINVOKE.ASTBase_isCSymbolFunction(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isCSymbolNumber() {
    bool ret = libsbmlPINVOKE.ASTBase_isCSymbolNumber(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isFunction() {
    bool ret = libsbmlPINVOKE.ASTBase_isFunction(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isInteger() {
    bool ret = libsbmlPINVOKE.ASTBase_isInteger(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isLambda() {
    bool ret = libsbmlPINVOKE.ASTBase_isLambda(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isLogical() {
    bool ret = libsbmlPINVOKE.ASTBase_isLogical(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isName() {
    bool ret = libsbmlPINVOKE.ASTBase_isName(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isNaryFunction() {
    bool ret = libsbmlPINVOKE.ASTBase_isNaryFunction(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isNumber() {
    bool ret = libsbmlPINVOKE.ASTBase_isNumber(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isOperator() {
    bool ret = libsbmlPINVOKE.ASTBase_isOperator(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isPiecewise() {
    bool ret = libsbmlPINVOKE.ASTBase_isPiecewise(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isQualifier() {
    bool ret = libsbmlPINVOKE.ASTBase_isQualifier(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isRational() {
    bool ret = libsbmlPINVOKE.ASTBase_isRational(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isReal() {
    bool ret = libsbmlPINVOKE.ASTBase_isReal(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isRelational() {
    bool ret = libsbmlPINVOKE.ASTBase_isRelational(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isSemantics() {
    bool ret = libsbmlPINVOKE.ASTBase_isSemantics(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isUnaryFunction() {
    bool ret = libsbmlPINVOKE.ASTBase_isUnaryFunction(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isUnknown() {
    bool ret = libsbmlPINVOKE.ASTBase_isUnknown(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isUserFunction() {
    bool ret = libsbmlPINVOKE.ASTBase_isUserFunction(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isNumberNode() {
    bool ret = libsbmlPINVOKE.ASTBase_isNumberNode(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isFunctionNode() {
    bool ret = libsbmlPINVOKE.ASTBase_isFunctionNode(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isTopLevelMathMLFunctionNodeTag(string name) {
    bool ret = libsbmlPINVOKE.ASTBase_isTopLevelMathMLFunctionNodeTag(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isTopLevelMathMLNumberNodeTag(string name) {
    bool ret = libsbmlPINVOKE.ASTBase_isTopLevelMathMLNumberNodeTag(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void write(XMLOutputStream stream) {
    libsbmlPINVOKE.ASTBase_write(swigCPtr, XMLOutputStream.getCPtr(stream));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 bool read(XMLInputStream stream, string reqd_prefix) {
    bool ret = libsbmlPINVOKE.ASTBase_read__SWIG_0(swigCPtr, XMLInputStream.getCPtr(stream), reqd_prefix);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool read(XMLInputStream stream) {
    bool ret = libsbmlPINVOKE.ASTBase_read__SWIG_1(swigCPtr, XMLInputStream.getCPtr(stream));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void addExpectedAttributes(SWIGTYPE_p_ExpectedAttributes attributes, XMLInputStream stream) {
    libsbmlPINVOKE.ASTBase_addExpectedAttributes(swigCPtr, SWIGTYPE_p_ExpectedAttributes.getCPtr(attributes), XMLInputStream.getCPtr(stream));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 bool readAttributes(XMLAttributes attributes, SWIGTYPE_p_ExpectedAttributes expectedAttributes, XMLInputStream stream, XMLToken element) {
    bool ret = libsbmlPINVOKE.ASTBase_readAttributes(swigCPtr, XMLAttributes.getCPtr(attributes), SWIGTYPE_p_ExpectedAttributes.getCPtr(expectedAttributes), XMLInputStream.getCPtr(stream), XMLToken.getCPtr(element));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void logError(XMLInputStream stream, XMLToken element, int code, string msg) {
    libsbmlPINVOKE.ASTBase_logError__SWIG_0(swigCPtr, XMLInputStream.getCPtr(stream), XMLToken.getCPtr(element), code, msg);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 void logError(XMLInputStream stream, XMLToken element, int code) {
    libsbmlPINVOKE.ASTBase_logError__SWIG_1(swigCPtr, XMLInputStream.getCPtr(stream), XMLToken.getCPtr(element), code);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 bool isChild() {
    bool ret = libsbmlPINVOKE.ASTBase_isChild(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void setIsChildFlag(bool flag) {
    libsbmlPINVOKE.ASTBase_setIsChildFlag(swigCPtr, flag);
  }

  
/** */ /* libsbml-internal */ public
 string getClass() {
    string ret = libsbmlPINVOKE.ASTBase_getClass(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 string getId() {
    string ret = libsbmlPINVOKE.ASTBase_getId(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 string getStyle() {
    string ret = libsbmlPINVOKE.ASTBase_getStyle(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 SBase getParentSBMLObject() {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.ASTBase_getParentSBMLObject(swigCPtr), false);
	return ret;
}

  
/** */ /* libsbml-internal */ public
 bool isSetClass() {
    bool ret = libsbmlPINVOKE.ASTBase_isSetClass(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isSetId() {
    bool ret = libsbmlPINVOKE.ASTBase_isSetId(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isSetStyle() {
    bool ret = libsbmlPINVOKE.ASTBase_isSetStyle(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isSetParentSBMLObject() {
    bool ret = libsbmlPINVOKE.ASTBase_isSetParentSBMLObject(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int setClass(string className) {
    int ret = libsbmlPINVOKE.ASTBase_setClass(swigCPtr, className);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int setId(string id) {
    int ret = libsbmlPINVOKE.ASTBase_setId(swigCPtr, id);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int setStyle(string style) {
    int ret = libsbmlPINVOKE.ASTBase_setStyle(swigCPtr, style);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int unsetClass() {
    int ret = libsbmlPINVOKE.ASTBase_unsetClass(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int unsetId() {
    int ret = libsbmlPINVOKE.ASTBase_unsetId(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int unsetStyle() {
    int ret = libsbmlPINVOKE.ASTBase_unsetStyle(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int unsetParentSBMLObject() {
    int ret = libsbmlPINVOKE.ASTBase_unsetParentSBMLObject(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 ASTBase getFunction() {
	ASTBase ret = (ASTBase) libsbml.DowncastASTBase(libsbmlPINVOKE.ASTBase_getFunction(swigCPtr), false);
	return ret;
}

  
/** */ /* libsbml-internal */ public
 void addPlugin(ASTBasePlugin plugin) {
    libsbmlPINVOKE.ASTBase_addPlugin(swigCPtr, ASTBasePlugin.getCPtr(plugin));
  }

  
/**
   * Returns a plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension with the given package name or URI.
   *
   * @param package the name or URI of the package
   *
   * @return the plug-in object (the libSBML extension interface) of
   * a package extension with the given package name or URI.
   */ /* libsbml-internal */ public
 ASTBasePlugin getPlugin(string package) {
    IntPtr cPtr = libsbmlPINVOKE.ASTBase_getPlugin__SWIG_0(swigCPtr, package);
    ASTBasePlugin ret = (cPtr == IntPtr.Zero) ? null : new ASTBasePlugin(cPtr, false);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Returns the nth plug-in object (extension interface) for an SBML Level&nbsp;3
   * package extension.
   *
   * @param n the index of the plug-in to return
   *
   * @return the plug-in object (the libSBML extension interface) of
   * a package extension with the given package name or URI.
   */ /* libsbml-internal */ public
 ASTBasePlugin getPlugin(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTBase_getPlugin__SWIG_2(swigCPtr, n);
    ASTBasePlugin ret = (cPtr == IntPtr.Zero) ? null : new ASTBasePlugin(cPtr, false);
    return ret;
  }

  
/**
   * Returns the number of plug-in objects (extenstion interfaces) for SBML
   * Level&nbsp;3 package extensions known.
   *
   * @return the number of plug-in objects (extension interfaces) of
   * package extensions known by this instance of libSBML.
   */ /* libsbml-internal */ public
 long getNumPlugins() { return (long)libsbmlPINVOKE.ASTBase_getNumPlugins(swigCPtr); }

  
/** */ /* libsbml-internal */ public
 int getTypeFromName(string name) {
    int ret = libsbmlPINVOKE.ASTBase_getTypeFromName(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 string getNameFromType(int type) {
    string ret = libsbmlPINVOKE.ASTBase_getNameFromType(swigCPtr, type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int setUserData(SWIGTYPE_p_void userData) {
    int ret = libsbmlPINVOKE.ASTBase_setUserData(swigCPtr, SWIGTYPE_p_void.getCPtr(userData));
    return ret;
  }

  
/**
  * Returns the user data that has been previously set via setUserData().
  *
  * @return the user data of this node, or @c null if no user data has been
  * set.
  *
  * @if clike
  * @see ASTNode::isSetUserData()
  * @see ASTNode::setUserData()
  * @see ASTNode::unsetUserData()
  * @endif
  */ public
 SWIGTYPE_p_void getUserData() {
    IntPtr cPtr = libsbmlPINVOKE.ASTBase_getUserData(swigCPtr);
    SWIGTYPE_p_void ret = (cPtr == IntPtr.Zero) ? null : new SWIGTYPE_p_void(cPtr, false);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool isSetUserData() {
    bool ret = libsbmlPINVOKE.ASTBase_isSetUserData(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int unsetUserData() {
    int ret = libsbmlPINVOKE.ASTBase_unsetUserData(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 void writeNodeOfType(XMLOutputStream stream, int type, bool inChildNode) {
    libsbmlPINVOKE.ASTBase_writeNodeOfType__SWIG_0(swigCPtr, XMLOutputStream.getCPtr(stream), type, inChildNode);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 void writeNodeOfType(XMLOutputStream stream, int type) {
    libsbmlPINVOKE.ASTBase_writeNodeOfType__SWIG_1(swigCPtr, XMLOutputStream.getCPtr(stream), type);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/** */ /* libsbml-internal */ public
 bool isWellFormedNode() {
    bool ret = libsbmlPINVOKE.ASTBase_isWellFormedNode(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool hasCorrectNumberArguments() {
    bool ret = libsbmlPINVOKE.ASTBase_hasCorrectNumberArguments(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int getTypeCode() {
    int ret = libsbmlPINVOKE.ASTBase_getTypeCode(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 string getPackageName() {
    string ret = libsbmlPINVOKE.ASTBase_getPackageName(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 int setPackageName(string name) {
    int ret = libsbmlPINVOKE.ASTBase_setPackageName(swigCPtr, name);
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 bool hasCnUnits() {
    bool ret = libsbmlPINVOKE.ASTBase_hasCnUnits(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 string getUnitsPrefix() {
    string ret = libsbmlPINVOKE.ASTBase_getUnitsPrefix(swigCPtr);
    return ret;
  }

}

}
