/*****
*
* Copyright (C) 2001, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef _LIBPRELUDE_IDMEF_TREE_FUNC_H
#define _LIBPRELUDE_IDMEF_TREE_FUNC_H

typedef struct {
        int msglen;
        int msgcount;
} idmef_msg_send_t;


idmef_node_t *idmef_source_node_new(idmef_source_t *source);
idmef_user_t *idmef_source_user_new(idmef_source_t *source);
idmef_process_t *idmef_source_process_new(idmef_source_t *source);
idmef_service_t *idmef_source_service_new(idmef_source_t *source);

#define idmef_target_node_new(target) idmef_source_node_new((idmef_source_t *) (target))
#define idmef_target_user_new(target) idmef_source_user_new((idmef_source_t *) (target))
#define idmef_target_process_new(target) idmef_source_process_new((idmef_source_t *) (target))
#define idmef_target_service_new(target) idmef_source_service_new((idmef_source_t *) (target))


void idmef_analyzer_node_new(idmef_analyzer_t *analyzer);
void idmef_analyzer_process_new(idmef_analyzer_t *analyzer);

/*
 * Inode.
 */
idmef_time_t *idmef_inode_change_time_new(idmef_inode_t *inode);

/*
 * Access.
 */
idmef_file_access_permission_t *idmef_file_access_permission_new(idmef_file_access_t *access);

/*
 * Linkage.
 */
idmef_file_t *idmef_linkage_file_new(idmef_linkage_t *linkage);

/*
 * File
 */
idmef_time_t *idmef_file_create_time_new(idmef_file_t *file);
idmef_time_t *idmef_file_modify_time_new(idmef_file_t *file);
idmef_time_t *idmef_file_access_time_new(idmef_file_t *file);

idmef_inode_t *idmef_file_inode_new(idmef_file_t *file);
idmef_linkage_t *idmef_file_linkage_new(idmef_file_t *file);
idmef_file_access_t *idmef_file_access_new(idmef_file_t *file);


/*
 * Target
 */
idmef_file_t *idmef_target_file_new(idmef_target_t *target);


/*
 * Process 
 */
idmef_process_env_t *idmef_process_env_new(idmef_process_t *process);
idmef_process_arg_t *idmef_process_arg_new(idmef_process_t *process);

/*
 * User
 */ 
idmef_userid_t *idmef_user_userid_new(idmef_user_t *user);


/*
 * Node
 */
idmef_address_t *idmef_node_address_new(idmef_node_t *node);


/*
 * Sub Service
 */
idmef_webservice_arg_t *idmef_webservice_arg_new(idmef_webservice_t *w);
idmef_webservice_t *idmef_service_webservice_new(idmef_service_t *service);
idmef_snmpservice_t *idmef_service_snmpservice_new(idmef_service_t *service);


/*
 * Sub alert
 */
void idmef_tool_alert_new(idmef_alert_t *alert);
void idmef_overflow_alert_new(idmef_alert_t *alert);
void idmef_correlation_alert_new(idmef_alert_t *alert);
idmef_alertident_t *idmef_tool_alert_alertident_new(idmef_tool_alert_t *alert);
idmef_alertident_t *idmef_correlation_alert_alertident_new(idmef_correlation_alert_t *alert);


/*
 * Assessment function.
 */
void idmef_assessment_impact_new(idmef_assessment_t *assessment);
void idmef_assessment_confidence_new(idmef_assessment_t *assessment);
idmef_action_t *idmef_assessment_action_new(idmef_assessment_t *assessment);

/*
 * Alert function
 */
void idmef_alert_new(idmef_message_t *message);
void idmef_alert_assessment_new(idmef_alert_t *alert);
void idmef_alert_detect_time_new(idmef_alert_t *alert);
void idmef_alert_analyzer_time_new(idmef_alert_t *alert);
idmef_source_t *idmef_alert_source_new(idmef_alert_t *alert);
idmef_target_t *idmef_alert_target_new(idmef_alert_t *alert);
idmef_classification_t *idmef_alert_classification_new(idmef_alert_t *alert);
idmef_additional_data_t *idmef_alert_additional_data_new(idmef_alert_t *alert);



/*
 * Heartbeat function
 */
void idmef_heartbeat_new(idmef_message_t *message);
void idmef_heartbeat_analyzer_time_new(idmef_heartbeat_t *heartbeat);
idmef_additional_data_t *idmef_heartbeat_additional_data_new(idmef_heartbeat_t *heartbeat);



/*
 * Functions
 */
idmef_message_t *idmef_message_new(void);

void idmef_message_free(idmef_message_t *msg);

void idmef_additional_data_free(idmef_additional_data_t *data);


/*
 * IDMEF string func
 */
#define idmef_string(s) (s)->string
#define idmef_string_len(s) (s)->len

#define idmef_string_copy(dst, src) do {                   \
        (dst)->len = (src)->len;                           \
        (dst)->string = (src)->string;                     \
} while(0)
 

#define idmef_string_set_constant(s, str) do {             \
	(s)->string = (str); (s)->len = sizeof((str));     \
} while (0)


#define idmef_string_set(s, str) do {                      \
	(s)->string = (str); (s)->len = strlen((str)) + 1; \
} while (0)


/*
 * special case for additional data.
 */
inline static void
idmef_additional_data_set_data(idmef_additional_data_t *ad,
                               idmef_additional_data_type_t type, const void *data, uint32_t dlen) 
{
        ad->type = type;
        ad->dlen = dlen;
        ad->data = data;
}


#endif /* _LIBPRELUDE_IDMEF_TREE_FUNC_H */
