/* neighboring25Direct.cc
 */
#include "osl/effect_util/neighboring25Direct.h"

bool osl::effect_util::
Neighboring25Direct::hasEffectFromTo(const NumEffectState& state,
				     PtypeO ptypeo, Square from, 
				     Square target, Offset offset)
{
  target += offset; // 25 近傍全て試すなら手番による符合変換は不要
  return target.isOnBoard() && state.hasEffectIf(ptypeo, from, target);
}

bool osl::effect_util::
Neighboring25Direct::hasEffectNaive(const NumEffectState& state,
				    PtypeO ptypeo, Square from, 
				    Square target)
{
  const Ptype ptype = getPtype(ptypeo);
	
  if (! Ptype_Table.hasLongMove(ptype))
  {
    if (abs(from.y() - target.y()) > 4)	// knight だけ4
      return false;
    if (abs(from.x() - target.x()) > 3)
      return false;
  }
  else if (ptype == LANCE)
  {
    if (abs(from.x() - target.x()) > 2)
      return false;
  }
	
  // naive な実装
  return hasEffectFromTo(state, ptypeo, from, target,newOffset(-2,-2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-1,-2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-0,-2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 1,-2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 2,-2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-2,-1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-1,-1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 0,-1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 1,-1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 2,-1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-2, 0))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-1, 0))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 0, 0))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 1, 0))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 2, 0))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-2, 1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-1, 1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 0, 1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 1, 1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 2, 1))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-2, 2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset(-1, 2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 0, 2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 1, 2))
    || hasEffectFromTo(state, ptypeo, from, target,newOffset( 2, 2));
	
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
