#include "osl/threatmate/richPredictor.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::threatmate;

class RichPredictorTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(RichPredictorTest);

  CPPUNIT_TEST(testBeginning);
  CPPUNIT_TEST(testAddEffect);
  CPPUNIT_TEST(testNotAddEffect);
  CPPUNIT_TEST(testCheck);
  // CPPUNIT_TEST(testXXX);

  CPPUNIT_TEST_SUITE_END();
public:
  void testBeginning();
  void testAddEffect();
  void testNotAddEffect();
  void testCheck();
  // void testXXX() { CPPUNIT_ASSERT(1+1 == 2); }

};

CPPUNIT_TEST_SUITE_REGISTRATION(RichPredictorTest);

void RichPredictorTest::testBeginning()
{
  const NumEffectState state((SimpleState(HIRATE)));
  const Move move = Move(Position(3,3), PAWN, WHITE);
  RichPredictor Rich;
  CPPUNIT_ASSERT( Rich.predict(state, move) < 100.0); 
}

void RichPredictorTest::testAddEffect()
{
  const NumEffectState state(CsaString(
				       "P1-KY *  * +TO * +KA-OU-KE-KY\n"
				       "P2-KY *  *  * +HI-KI *  *  * \n"
				       "P3 *  * -KE *  * -FU-FU-FU * \n"
				       "P4 * -FU-FU *  *  *  * -KI-FU\n"
				       "P5-FU *  *  * +FU *  *  *  * \n"
				       "P6 *  * +FU-HI *  *  * +KI * \n"
				       "P7+FU+FU+KE * -TO-NK+FU *  * \n"
				       "P8+OU * +GI *  *  *  *  *  * \n"
				       "P9+KY * -TO *  *  *  *  *  * \n"
				       "P+00KI00FU\n"
				       "P-00KA00GI00GI00GI00FU00FU\n"
				       "-\n").getInitialState());
  const Move move = Move(Position(5,2), ROOK, BLACK);
  RichPredictor Rich;
  CPPUNIT_ASSERT( Rich.predict(state, move) > 0.0);
}

void RichPredictorTest::testNotAddEffect()
{
  const NumEffectState state(CsaString(
				       "P1+RY-KE-FU * +NK *  * -OU-FU\n"
				       "P2 *  * -GI *  * +KI *  *  * \n"
				       "P3 *  *  *  *  *  *  *  * +GI\n"
				       "P4+FU *  *  * -KY+GI-KY * +FU\n"
				       "P5 * -FU *  *  *  *  *  * -KE\n"
				       "P6 *  * +FU *  *  * +KA-UM * \n"
				       "P7 * +FU *  *  *  * -KY+KY-GI\n"
				       "P8 *  *  *  *  * -KI *  *  * \n"
				       "P9-RY+KE+KI *  *  *  * +KI+OU\n"
				       "P+00FU00FU00FU00FU00FU\n"
				       "P-00FU00FU00FU00FU00FU00FU\n"
				       "-\n").getInitialState());

  const Move move = Move(Position(3,6), BISHOP, BLACK);
  RichPredictor Rich;
  CPPUNIT_ASSERT( Rich.predict(state, move) > 0.0);
}

void RichPredictorTest::testCheck()
{
  const NumEffectState state(CsaString(
				       "P1+RY-KE-FU * +NK *  * -OU-FU\n"
				       "P2 *  * -GI *  * +KI *  *  * \n"
				       "P3 *  *  *  *  *  *  * +KY+GI\n"
				       "P4+FU *  *  * -UM+GI-KY * +FU\n"
				       "P5 * -FU *  *  *  *  *  * -KE\n"
				       "P6 *  * +FU *  *  *  *  *  * \n"
				       "P7 * +FU *  *  *  * -KY * -GI\n"
				       "P8 *  *  *  *  * -KI *  *  * \n"
				       "P9-RY+KE+KI *  *  *  * +KI+OU\n"
				       "P+00FU00FU00FU00FU00FU\n"
				       "P-00KA00KY00FU00FU00FU00FU00FU00FU\n"
				       "-\n").getInitialState());

  const Move move = Move(Position(2,3), LANCE, BLACK);
  RichPredictor Rich;
  CPPUNIT_ASSERT( Rich.predict(state, move) > 0.0);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
