#include "osl/record/csaString.h"
#include "osl/search/moveStackRejections.h"
#include "osl/apply_move/applyMove.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class MoveStackRejectionsTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(MoveStackRejectionsTest);
  CPPUNIT_TEST(testProbe);
  CPPUNIT_TEST_SUITE_END();
public:
  void testProbe();
};

CPPUNIT_TEST_SUITE_REGISTRATION(MoveStackRejectionsTest);

void MoveStackRejectionsTest::testProbe()
{
  {
    // 駒損ループの権利を相手に与えるように見えるが，実はその手が存在しない
    NumEffectState state(CsaString(
				   "P1-GI-KE *  * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU *  *  *  *  * -KY\n"
				   "P4 * -KY *  * +FU *  * -UM-FU\n"
				   "P5 *  *  * -KI * -HI-FU *  * \n"
				   "P6 *  * +KE+RY * +KY *  * +KE\n"
				   "P7+FU+FU+FU+FU * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI * +OU *  *  *  * \n"
				   "P9+KY * +GI *  * +KI+GI *  * \n"
				   "P-00FU\n"
				   "-\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(6,5),Position(7,5),GOLD,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,0,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,6),Position(5,5),PROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,1,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,4),PAWN,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,2,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,5),Position(6,4),PROOK,PAWN,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,3,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      // PROOKは6,6に戻れない
      Move m(Position(7,5),Position(6,5),GOLD,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,4,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
  }
  {
    // 駒損ループの権利を相手に与えるように見え，その時点ではできそうにないが，実はその手が存在する　
    NumEffectState state(CsaString(
				   "P1-GI-KE *  * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU *  *  *  *  * -KY\n"
				   "P4 * -KY *  * +FU *  * -UM-FU\n"
				   "P5 *  * -KI *  * -HI-FU *  * \n"
				   "P6 *  * +KE+RY * +KY *  * +KE\n"
				   "P7+FU+FU+FU+FU * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI * +OU *  *  *  * \n"
				   "P9+KY * +GI *  * +KI+GI *  * \n"
				   "P-00FU\n"
				   "-\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(7,5),Position(6,5),GOLD,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,0,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,6),Position(5,5),PROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,1,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,4),PAWN,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,2,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,5),Position(6,4),PROOK,PAWN,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,3,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      // PROOKは6,6に戻れる
      Move m(Position(6,5),Position(7,5),GOLD,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((MoveStackRejections::probe<WHITE>(state,history,4,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
  }
  {
    // 駒損をして，ループする権利を相手に与える
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU-FU *  *  *  * -KY\n"
				   "P4 * -KY *  * +FU *  * -UM-FU\n"
				   "P5 *  *  *  *  * -HI-FU *  * \n"
				   "P6 *  * +KE *  * +KY *  * +KE\n"
				   "P7+FU+FU+FU+FU * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI * +OU *  * +HI * \n"
				   "P9+KY * +GI *  * +KI+GI *  * \n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(5,4),Position(5,3),PPAWN,PTYPE_EMPTY,true,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,2),Position(5,3),SILVER,PPAWN,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,4),PAWN,BLACK);
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
    }
  }
  {
    // 相手のパス後に元からいける所に行く
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU-FU *  *  *  * -KY\n"
				   "P4 * -KY *  * +FU+GI * -UM-FU\n"
				   "P5 *  *  *  *  * -HI-FU *  * \n"
				   "P6 *  * +KE *  * +KY *  * +KE\n"
				   "P7+FU+FU+FU+FU * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI * +OU *  * +HI * \n"
				   "P9+KY *  *  *  * +KI+GI *  * \n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(4,4),Position(4,3),PSILVER,PTYPE_EMPTY,true,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,3,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m=Move::PASS(WHITE);
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(4,3),Position(5,3),PSILVER,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
    }
  }
  {
    // 敵味方往復中に，元からいけるところに一手はさむ
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU *  * -FU *  *  *  * -KY\n"
				   "P4 * -KY-FU * +FU+GI * -UM-FU\n"
				   "P5 *  *  *  *  * -HI-FU *  * \n"
				   "P6 *  * +KE *  * +KY *  * +KE\n"
				   "P7+FU+FU+FU+FU * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI * +OU *  * +HI * \n"
				   "P9+KY *  *  *  * +KI+GI *  * \n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(4,4),Position(3,3),SILVER,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,2),Position(7,3),SILVER,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,4),Position(5,3),PPAWN,PTYPE_EMPTY,true,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(7,3),Position(6,2),SILVER,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,3,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(3,3),Position(4,4),SILVER,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
    }
  }
  {
    // 歩を交換して元からいけるところにいく
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU-FU *  *  *  * -KY\n"
				   "P4 * -KY *  * +FU *  * -UM-FU\n"
				   "P5 *  *  *  *  * -HI-FU *  * \n"
				   "P6 *  * +KE *  * +KY *  * +KE\n"
				   "P7+FU+FU+FU *  * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI+HI+OU *  *  *  * \n"
				   "P9+KY * +GI *  * +KI+GI *  * \n"
				   "P+00FU\n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(6,4),PAWN,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,3),Position(6,4),PAWN,PAWN,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,8),Position(6,4),ROOK,PAWN,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,3),PAWN,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,3,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,4),Position(6,5),ROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
    }
  }
  {
    // 元々一手でいけないところに行くのは可
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU-FU *  *  *  * -KY\n"
				   "P4 * -KY *  *  *  *  * -UM-FU\n"
				   "P5 *  *  * +FU * -HI-FU *  * \n"
				   "P6 *  * +KE+HI * +KY *  * +KE\n"
				   "P7+FU+FU+FU * +FU+FU+FU+FU+FU\n"
				   "P8 * +KA+KI * +OU *  *  *  * \n"
				   "P9+KY * +GI *  * +KI+GI *  * \n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    history.push(Move());
    {
      Move m(Position(6,6),Position(5,6),ROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(2,4),Position(2,3),PBISHOP,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,6),Position(5,4),ROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(2,3),Position(2,4),PBISHOP,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((MoveStackRejections::probe<WHITE>(state,history,3,m,-1,0)));
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,3,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,4),Position(6,4),ROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
    }
  }
  {
    // 角交換で派手だが元々いけるところ
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU-FU *  *  *  * -KY\n"
				   "P4 * -KY *  *  *  *  *  * -FU\n"
				   "P5 *  *  * +FU * -HI-FU *  * \n"
				   "P6 *  * +FU *  * +KY *  * +KE\n"
				   "P7+FU+FU *  * +FU+FU+FU+FU+FU\n"
				   "P8 *  * +KI+HI+OU *  *  *  * \n"
				   "P9+KY+KE+GI *  * +KI+GI *  * \n"
				   "P+00KA\n"
				   "P-00KA\n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(8,8),BISHOP,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(3,3),BISHOP,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(8,8),Position(7,7),BISHOP,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(3,3),Position(7,7),PBISHOP,BISHOP,true,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,3,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(8,9),Position(7,7),KNIGHT,PBISHOP,false,BLACK);
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
    }
  }
  {
    // progress2/01.csa
    NumEffectState state(CsaString(
				   "P1-KY+HI * +KA *  *  * -KE-KY\n"
				   "P2 *  * -KI-FU *  *  *  *  * \n"
				   "P3-KE-KI-OU * +UM-GI-FU+FU-FU\n"
				   "P4 * -GI *  * -FU *  * -FU * \n"
				   "P5-FU *  *  *  * +GI *  *  * \n"
				   "P6 * +FU-FU *  *  *  *  *  * \n"
				   "P7+FU *  *  *  *  * +FU * +FU\n"
				   "P8+KY+KI+KI *  *  *  *  *  * \n"
				   "P9+OU+KE *  *  *  *  * +KE+KY\n"
				   "P+00FU\n"
				   "P-00HI00GI00FU00FU00FU00FU00FU\n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    {
      Move m(Position(7,4),PAWN,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(7,3),Position(7,4),KING,PAWN,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,1),Position(7,2),PBISHOP,GOLD,true,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,3),ROOK,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,3,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(5,3),Position(6,3),PBISHOP,ROOK,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,4,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(7,4),Position(7,5),KING,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,5,m,1,1)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,3),Position(5,3),PBISHOP,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,6,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(7,5),Position(7,4),KING,PTYPE_EMPTY,false,WHITE);
      CPPUNIT_ASSERT((MoveStackRejections::probe<WHITE>(state,history,7,m,1,2)));
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,2,m,1,2)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
  }
  {
    // 一手パスもrejectする? -> しない
    NumEffectState state(CsaString(
				   "P1-GI-KE-KI * -KE-TO-TO-TO-OU\n"
				   "P2 *  *  * -GI *  *  * -TO-KI\n"
				   "P3-FU * -FU-FU *  *  *  * -KY\n"
				   "P4 * -KY *  * +FU *  * -UM-FU\n"
				   "P5 *  *  *  *  * -HI-FU *  * \n"
				   "P6 *  * +KE *  * +KY *  * +KE\n"
				   "P7+FU+FU+FU *  * +FU+FU+FU+FU\n"
				   "P8 * +KA+KI+HI+OU *  *  *  * \n"
				   "P9+KY * +GI *  * +KI+GI *  * \n"
				   "P+00FU\n"
				   "+\n").getInitialState());
    MoveStack history;
    history.push(Move());
    history.push(Move());
    {
      Move m(Position(6,4),PAWN,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,0,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,3),Position(6,4),PAWN,PAWN,false,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,1,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,8),Position(6,4),ROOK,PAWN,false,BLACK);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,2,m,-1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,3),PAWN,WHITE);
      CPPUNIT_ASSERT((!MoveStackRejections::probe<WHITE>(state,history,3,m,1,0)));
      ApplyMoveOfTurn::doMove(state, m);    
      history.push(m);
    }
    {
      Move m(Position(6,4),Position(6,8),ROOK,PTYPE_EMPTY,false,BLACK);
      CPPUNIT_ASSERT((MoveStackRejections::probe<BLACK>(state,history,4,m,1,0)));
      CPPUNIT_ASSERT((!MoveStackRejections::probe<BLACK>(state,history,5,m,-1,0)));
    }
  }
}


// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
