#include "osl/search/hashRejections.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class HashRejectionsTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(HashRejectionsTest);
  CPPUNIT_TEST(testProbe);
  CPPUNIT_TEST(testCopy);
  CPPUNIT_TEST_SUITE_END();
public:
  void testProbe();
  void testCopy();
};

CPPUNIT_TEST_SUITE_REGISTRATION(HashRejectionsTest);

void HashRejectionsTest::testProbe()
{
  HashRejections table;
  NumEffectState state;
  HashKey key(state);
  Move good_move(Position(7,7), Position(7,6), PAWN, PTYPE_EMPTY, false, BLACK);
  Move another_move(Position(1,9), Position(1,8), LANCE, PTYPE_EMPTY, false, BLACK);

  table.addRejectionRoot(state, key, good_move);
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(good_move), key));
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(another_move), key));
  CPPUNIT_ASSERT(table.rejectionProbe(key.newHashWithMove(another_move), HashKey()));

  table.clearRejectionRoot(state, key, good_move);
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(good_move), key));
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(another_move), key));
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(another_move), HashKey()));

  table.addRejection(state, key, good_move);
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(good_move), key));
  CPPUNIT_ASSERT(table.rejectionProbe(key.newHashWithMove(another_move), key));
  CPPUNIT_ASSERT(table.rejectionProbe(key.newHashWithMove(another_move), HashKey()));

  table.clearRejection(state, key, good_move);
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(good_move), key));
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(another_move), key));
  CPPUNIT_ASSERT(! table.rejectionProbe(key.newHashWithMove(another_move), HashKey()));
}

void HashRejectionsTest::testCopy()
{
  HashRejections table;
  NumEffectState state;
  HashKey key(state);
  Move good_move(Position(7,7), Position(7,6), PAWN, PTYPE_EMPTY, false, BLACK);
  Move another_move(Position(1,9), Position(1,8), LANCE, PTYPE_EMPTY, false, BLACK);
  table.addRejectionRoot(state, key, good_move);

  HashRejections table2 = table;
  CPPUNIT_ASSERT(table2.rejectionProbe(key.newHashWithMove(another_move), HashKey()));

  table.addRejection(state, key, good_move);

  HashRejections table3;
  table3 = table;
  CPPUNIT_ASSERT(table3.rejectionProbe(key.newHashWithMove(another_move), key));
  CPPUNIT_ASSERT(table3.rejectionProbe(key.newHashWithMove(another_move), HashKey()));
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
