/* sendOffPosition.cc
 */
#include "osl/effect_util/sendOffPosition.h"
#include "osl/ptypeTable.h"
#include "osl/misc/bitOp.h"
#include <boost/foreach.hpp>

osl::effect_util::SendOffPosition::
Table::Table()
{
  normal[0] = Offset( 1, 1);
  normal[1] = Offset( 1, 0);
  normal[2] = Offset( 1,-1);
  normal[3] = Offset( 0, 1);
  normal[4] = Offset( 0,-1);
  normal[5] = Offset(-1, 1);
  normal[6] = Offset(-1, 0);
  normal[7] = Offset(-1,-1);

  const Position center(5,5);
  const PtypeO king = newPtypeO(BLACK, KING);
  for (int i=0; i<8; ++i)
  {
    const Offset king_position = normal[i];
    for (int j=0; j<8; ++j)
    {
      const Offset target = normal[j];
      if (i==j)
	continue;
      const int dx = king_position.dx() - target.dx();
      const int dy = king_position.dy() - target.dy();
      const EffectContent effect
	= Ptype_Table.getEffect(king, Offset32(dx, dy));
      if (! effect.hasEffect())
      {
	reverse[i].push_back(j);
      }
    }
  }

  for (int i=0; i<256; ++i)
  {
    unsigned int val = i;
    while (val)
    {
      const int j = misc::BitOp::takeOneBit(val);

      BOOST_FOREACH(int p, reverse[j])
      {
	if (! reverse_all[i].isMember(p))
	  reverse_all[i].push_back(p);
      }
    }
  }
}

template <osl::Player Attack>
osl::effect_util::SendOffPosition::SendOff8
#if (defined __GNUC__) && (! defined GPSONE) && (! defined GPSUSIONE)
__attribute__ ((used))
#endif
  osl::effect_util::
SendOffPosition::find(const NumEffectState& state, Position king_position,
		      Position8& out)
{
  assert(out.empty());
  int flags=0;
  for (int i=0; i<8; ++i)
  {
    testPosition<Attack>(state, king_position+table.normal[i], i, flags);
  }
  SendOff8 data = 0;
  BOOST_FOREACH(int i, table.reverse_all[flags])
  {
    const Position candidate = king_position + table.normal[i];
    if (! state.getPieceAt(candidate).isEdge()
	&& state.countEffect(alt(Attack), candidate) == 1) {
      out.push_back(candidate);
      data |= (1<<i);
    }
  }
  return data;
}

void osl::effect_util::
SendOffPosition::unpack(SendOff8 flags8, Position king_position,
			Position8& out)
{
  assert(out.empty());
  unsigned int flags = flags8;
  while (flags) {
    const int i = misc::BitOp::takeOneBit(flags);
    const Position candidate = king_position + table.normal[i];
    out.push_back(candidate);
  }
}

osl::effect_util::SendOffPosition::SendOff8 osl::effect_util::
SendOffPosition::find(Player attack, const NumEffectState& state, 
		      Position king_position,
		      Position8& out)
{
  if (attack == BLACK)
    return find<BLACK>(state, king_position, out);
  else
    return find<WHITE>(state, king_position, out);
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
