#ifndef _SIMPLE_BETTER_TO_PROMOTE_MOVE_ACTION_H
#define _SIMPLE_BETTER_TO_PROMOTE_MOVE_ACTION_H

#include "osl/move_action/concept.h"
namespace osl
{
  namespace effect_action
  {
    /**
     * promote可能な場合は promoteしない手は生成しない
     */
    template<class Action>
    class SimpleBetterToPromote
    {
      BOOST_CLASS_REQUIRE(Action,osl::move_action,Concept);
    private:
      Action & ac;
    public:
      SimpleBetterToPromote(Action & a) :ac(a){}
      template<Player P,Ptype Type>
      void doActionPtype(Piece p1,Position to){
	Position from=p1.position();
	Ptype ptype=p1.ptype();
	if(!isPromoted(ptype) && (to.canPromote<P>() || from.canPromote<P>()))
	  ac.simpleMove(from,to,promote(Type),true,P);
	else
	  ac.simpleMove(from,to,ptype,false,P);
      }
      template<Player P>
      void doAction(Piece p1,Position to){
	Position from=p1.position();
	Ptype ptype=p1.ptype();
	if(!isPromoted(ptype) && (to.canPromote<P>() || from.canPromote<P>()))
	  ac.simpleMove(from,to,promote(ptype),true,P);
	else
	  ac.simpleMove(from,to,ptype,false,P);
      }
      bool done() const{ return false;}
    };

  } // namespace effect_action
} // namespace osl
#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
