/* immediateCheckmate.tcc
 */
#ifndef _CHECKMATE_IMMEDIATE_CHECKMATE_TCC
#define _CHECKMATE_IMMEDIATE_CHECKMATE_TCC
#include "osl/checkmate/immediateCheckmate.h"
#include "osl/checkmate/immediateCheckmateTable.h"
#include "osl/move_classifier/kingOpenMove.h"
#include "osl/effect_util/effectUtil.h"
#include "osl/effect_util/additionalEffect.h"
#include "osl/directionTraits.h"
#include "osl/pieceTable.h"
#include "osl/misc/bitOp.h"
#include "osl/misc/mask.h"

namespace osl
{
  namespace checkmate
  {
    namespace detail {
      using osl::misc::BitOp;
      template<Player P>
      bool blockingVerticalAttack(NumEffectState const& state,Position pos)
      {
	PieceMask effect=state.getEffect(pos)&
	  state.getEffect(pos+DirectionPlayerTraits<U,P>::offset());
	mask_t mask=effect.getMask(1);  // longは常に1
	mask&=(state.getOnBoardMask(P).getMask(1)<<8);
	if((mask&mask_t::makeDirect(PtypeFuns<LANCE>::indexMask<<8)).none()){
	  mask&=mask_t::makeDirect(PtypeFuns<ROOK>::indexMask<<8);
	  while(mask.any()){
	    int num=mask.takeOneBit()+NumBitmapEffect::longToNumOffset;
	    Position from=state.getPieceOf(num).position();
	    assert(from.isOnBoard());
	    if(from.isU<P>(pos)) goto found;
	  }
	  return false;
	found:;
	}
	const Offset offset=DirectionPlayerTraits<U,P>::offset();
	pos+=offset;
	const Player altP=PlayerTraits<P>::opponent;
	for(int i=0;i<3;i++,pos+=offset){
	  Piece p=state.getPieceAt(pos);
	  if(p.canMoveOn<altP>()){ // 自分の駒か空白
	    if(state.countEffect(P,pos)==1) return true;
	    if(!p.isEmpty()) return false;
	  }
	  else return false;
	}
	return false;
      }
      template<Player P>
      bool blockingDiagonalAttack(NumEffectState const& state,Position pos,Position target,
				  King8Info canMoveMask)
      {
	const Player altP=PlayerTraits<P>::opponent;
	Position to=target-DirectionPlayerTraits<U,P>::offset();
	// Uに相手の駒がある
	if((canMoveMask.value&(0x10000<<U))==0) return false;
	PieceMask effect=state.getEffect(to)&state.getEffect(pos);
	mask_t mask=effect.getMask(1);  // longは常に1
	mask&=(state.getOnBoardMask(P).getMask(1)<<8);
	mask&=mask_t::makeDirect(PtypeFuns<BISHOP>::indexMask<<8);
	while(mask.any()){
	  int num=mask.takeOneBit()+NumBitmapEffect::longToNumOffset;
	  Position from=state.getPieceOf(num).position();
	  assert(from.isOnBoard());
	  Offset offset=Board_Table.getShort8OffsetUnsafe(to,from);
	  if(to+offset != pos) continue;
	  if(state.countEffect(P,to)==1) return true;
	  // Uがspaceだと絡んでくる
	  if(!state.getPieceAt(to).isEmpty()) return false;
	  Position pos1=to-offset;
	  // BISHOPの利き一つで止めていた
	  Piece p=state.getPieceAt(pos1);
	  if(p.canMoveOn<altP>() &&
	     state.countEffect(P,pos1)==1){
	    return true;
	  }
	}
	return false;
      }
      template<Player P,bool canDrop,bool setBestMove>
      bool hasKnightCheckmate(NumEffectState const& state, 
			      Position target, 
			      Position pos,
			      King8Info canMoveMask,
			      Move& bestMove, mask_t mask1)
      {
	if(!pos.isOnBoard()) return false;
	const Player altP=PlayerTraits<P>::opponent;
	Piece p=state.getPieceAt(pos);
	if(p.canMoveOn<P>() && 
	   !state.hasEffectNotMask(altP,pos,~state.pinOrOpen(altP))
	  ){
	  mask_t mask=state.getEffect(pos).getMask<KNIGHT>()&mask1;
	  if(mask.any()){
	    if(blockingVerticalAttack<P>(state,pos) ||
	       blockingDiagonalAttack<P>(state,pos,target,canMoveMask)) return false;
	    if(setBestMove){
	      int num=mask.takeOneBit()+(PtypeFuns<KNIGHT>::indexNum<<5);
	      Piece p1=state.getPieceOf(num);
	      Position from=p1.position();
	      bestMove=Move(from,pos,KNIGHT,p.ptype(),false,P);
	    }
	    return true;
	  }
	  else if(canDrop && p.isEmpty()){
	    if(blockingVerticalAttack<P>(state,pos) ||
	       blockingDiagonalAttack<P>(state,pos,target,canMoveMask)) return false;
	    if(setBestMove)
	      bestMove=Move(pos,KNIGHT,P);
	    return true;
	  }
	}
	return false;
      }
      // KNIGHT
      // KNIGHTのdropは利きを遮ることはない
      template<Player P,bool setBestMove>
      bool hasCheckmateMoveKnight(NumEffectState const& state, Position target, 
				  King8Info canMoveMask,Move& bestMove)
      {
	// 8近傍に移動できる時は桂馬の一手詰めはない
	if((canMoveMask.value&0xff00)!=0) return false;
	mask_t mask=mask_t::makeDirect(PtypeFuns<KNIGHT>::indexMask);
	mask&=state.getOnBoardMask(P).getMask<KNIGHT>();
	mask&= ~state.promotedPieces().getMask<KNIGHT>();
	mask&= ~state.pinOrOpen(P).getMask<KNIGHT>();
	if(state.hasPieceOnStand<KNIGHT>(P)){
	  Position pos=target-DirectionPlayerTraits<UUR,P>::offset();
	  if(hasKnightCheckmate<P,true,setBestMove>(state,target,pos,canMoveMask,bestMove,mask))
	    return true;
	  pos=target-DirectionPlayerTraits<UUL,P>::offset();
	  return hasKnightCheckmate<P,true,setBestMove>(state,target,pos,canMoveMask,bestMove,mask);
	}
	else{
	  Position pos=target-DirectionPlayerTraits<UUR,P>::offset();
	  if(hasKnightCheckmate<P,false,setBestMove>(state,target,pos,canMoveMask,bestMove,mask))
	    return true;
	  pos=target-DirectionPlayerTraits<UUL,P>::offset();
	  return hasKnightCheckmate<P,false,setBestMove>(state,target,pos,canMoveMask,bestMove,mask);
	}
	return false;
      }
      template<Player P,bool setBestMove>
      bool slowCheckDrop(NumEffectState const& state,Position target,
			 Ptype ptype,King8Info canMoveMask,Move& bestMove)
      {
	unsigned int dropMask=(canMoveMask.value&0xff)
	  &Immediate_Checkmate_Table.ptypeDropMask(ptype,canMoveMask);
	// dropMaskが0ならここに来ない
	assert(dropMask!=0);
	while(dropMask!=0){
	  int i=BitOp::takeOneBit(dropMask);
	  Direction d=static_cast<Direction>(i);
	  unsigned int blockingMask=Immediate_Checkmate_Table.blockingMask(ptype,d) &
	    (canMoveMask.value>>16);
	  Position drop=target-Board_Table.getOffset<P>(d);
	  if(blockingMask!=0){
	    NumBitmapEffect effect=state.getEffect(drop);
	    mask_t longEffect=effect.getMask(1)&NumBitmapEffect::longEffectMask();
	    longEffect&=(state.getOnBoardMask(P).getMask(1)<<8);
	    if(longEffect.any()){
	      do{
		int j=BitOp::takeOneBit(blockingMask);
		Direction d1=static_cast<Direction>(j);
		Position pos=target-Board_Table.getOffset<P>(d1);
		NumBitmapEffect effect1=state.getEffect(pos);
		if(effect1.countEffect(P)>1) continue;
		mask_t longEffect1=effect1.getMask(1)&longEffect;
		if(!longEffect1.any()) continue;
		//
		int num=longEffect1.takeOneBit()+NumBitmapEffect::longToNumOffset;
		if(Board_Table.isBetween(drop,state.getPieceOf(num).position(),pos))
		  goto tryNext;
	      }while(blockingMask!=0);
	    }
	  }
	  // blockingMaskの点がすべてOKならOK
	  if(setBestMove)
	    bestMove=Move(drop,ptype,P);
	  return true;
	tryNext:;
	}
	return false;
      }
    } // detail
  } // checkmate
} // osl

// not KNIGHT
template<osl::Player P,bool setBestMove>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateDrop(NumEffectState const& state, Position target,
		 King8Info canMoveMask,Move& bestMove)
{
  typedef misc::GeneralMask<unsigned short> mask_t;
  mask_t dropPtypeMask=mask_t::makeDirect(Immediate_Checkmate_Table.dropPtypeMask(canMoveMask));
  while(dropPtypeMask.any()){
    Ptype ptype=static_cast<Ptype>(dropPtypeMask.takeOneBit()+PTYPE_BASIC_MIN);
    if(state.hasPieceOnStand(P,ptype) &&
       detail::slowCheckDrop<P,setBestMove>(state,target,ptype,canMoveMask,
					    bestMove))
      return true;
  }
  return false;
}

template<osl::Player P,bool setBestMove>
bool osl::checkmate::ImmediateCheckmate::
slowHasCheckmateMoveDirPiece(NumEffectState const& state, Position target,
			     King8Info canMoveMask,Direction d,Position pos,Piece p,Ptype ptype,Move& bestMove){
  const Player altP=PlayerTraits<P>::opponent;
  // ptypeがPROOKの時は，更なるチェックが必要
  if(ptype==PROOK){
    int dx=target.x()-pos.x();
    int dy=target.y()-pos.y();
    if(abs(dx)==1 && abs(dy)==1){
      {
	Position pos1=pos+Offset(dx,0);
	Piece p1=state.getPieceAt(pos1);
	if(!p1.isEmpty()){
	  {
	    //  * -OU *
	    // (A)(B)(D)
	    //  * (C) *
	    // (E) *  *
	    // +RY (C) -> (A), (E) -> (A)
	    // -?? - (B)
	    // (D) - 竜以外の利きなし 
	    Position pos2=pos+Offset(2*dx,0);
	    if(state.getPieceAt(pos2).template canMoveOn<altP>()){
	      NumBitmapEffect effect2=state.getEffect(pos2);
	      if(effect2.countEffect(P)==0 ||
		 (effect2.countEffect(P)==1 &&
		  effect2.test(p.number())))
		return false;
	    }
	  }
	  {
	    //  * -OU *
	    // (A)(B) *
	    //  * (C) *
	    // +RY (C) -> (A)
	    // -?? - (B)竜でpinされているが実はAへの利き持つ
	    if(p.position()==target-Offset(0,2*dy) &&
	       state.hasEffectByPiece(p1,pos))
	      return false;
	  }
	}
      }
      {
	Position pos1=pos+Offset(0,dy);
	Piece p1=state.getPieceAt(pos1);
	if(!p1.isEmpty()){
	  Position pos2=pos+Offset(0,2*dy);
	  {
	    if(state.getPieceAt(pos2).template canMoveOn<altP>()){
	      NumBitmapEffect effect2=state.getEffect(pos2);
	      if(effect2.countEffect(P)==0 ||
		 (effect2.countEffect(P)==1 &&
		  effect2.test(p.number())))
		return false;

	    }
	    {
	      // (C)(B)-OU
	      //  * (A) *
	      // +RY (C) -> (A)
	      // -?? - (B)竜でpinされているが実はAへの利き持つ
	      if(p.position()==target-Offset(2*dx,0) &&
		 state.hasEffectByPiece(p1,pos))
		return false;
	    }
	  }
	}
      }
    }
  }
  // 元々2つの利きがあったマスが，
  // block & 自分の利きの除去で利きがなくなることはあるか?
  // -> ある．
  // +KA  *   *
  //  *  (A) +KI
  //  *  -OU (B)
  //  *   *   *
  // で金がAに移動して王手をかけると，Bの利きが2から0になる．
  mask_t mask=mask_t::makeDirect((canMoveMask.value>>16)&Immediate_Checkmate_Table.noEffectMask(ptype,d));
  if(mask.any()){
    int num=p.number();
    NumBitmapEffect effect2=state.getEffect(pos);
    effect2.reset(num+8);
    mask_t longEffect2=effect2.getMask(1)&NumBitmapEffect::longEffectMask();
    longEffect2&=(state.getOnBoardMask(P).getMask(1)<<8);
    do {
      Direction d1=static_cast<Direction>(mask.takeOneBit());
      Position pos1=target-Board_Table.getOffset<P>(d1);
      NumBitmapEffect effect1=state.getEffect(pos1);
      int count=effect1.countEffect(P);
      // 自分の利きの除去
      if(effect1.test(num)) count--;
      if(count==0) return false;
      // blockしている利きの除去
      mask_t longEffect1=effect1.getMask(1)&longEffect2;
      while(longEffect1.any()){
	int num1=longEffect1.takeOneBit()+NumBitmapEffect::longToNumOffset;
	if(Board_Table.isBetween(pos,state.getPieceOf(num1).position(),pos1))
	  count--;
	if(count==0) return false;
      }
    } while (mask.any());
  }
  // 自殺手でないことのチェックを入れる
  if(move_classifier::KingOpenMove<P>::isMember(state,ptype,p.position(),pos)) return false;
  if(setBestMove){
    bestMove=Move(p.position(),pos,ptype,
		  state.getPieceAt(pos).ptype(),
		  ptype!=p.ptype(),P);
  }
  return true;
}

template<osl::Player P,bool setBestMove>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMoveDirPiece(NumEffectState const& state, Position target,
			 King8Info canMoveMask,Direction d,Position pos,Piece p,Move& bestMove){
  Position from=p.position();
  Ptype ptype=p.ptype();
  // 相手の利きが伸びてしまって移動後も利きがついてくる可能性
  {
    const Player altP=PlayerTraits<P>::opponent;
    Direction d1=Board_Table.getShort8Unsafe<P>(from,pos);
    if(d1!=DIRECTION_INVALID_VALUE){ // not knight move
      int num=state.longEffectNumTable()[p.number()][P==BLACK ? d1 : inverse(d1)];
      if(num != EMPTY_NUM && state.getPieceOf(num).isOnBoardByOwner<altP>())
	return false;
    }
  }
  if(canPromote(ptype) &&
     (from.canPromote<P>() || pos.canPromote<P>())){
    Ptype pptype=promote(ptype);
    if((((canMoveMask.value>>8)|0x100)&
	Immediate_Checkmate_Table.noEffectMask(pptype,d))==0){
      if(slowHasCheckmateMoveDirPiece<P,setBestMove>(state,target,canMoveMask,d,pos,p,pptype,bestMove)) return true;
    }
    if (ptype==PAWN || /*basic because canpromote*/isMajorBasic(ptype)) 
      return false;
  }
  if((((canMoveMask.value>>8)|0x100)&
      Immediate_Checkmate_Table.noEffectMask(ptype,d))==0){
    if(slowHasCheckmateMoveDirPiece<P,setBestMove>(state,target,canMoveMask,d,pos,p,ptype,bestMove)) return true;
  }
  return false;
}

template<osl::Player P,bool setBestMove>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMoveDir(NumEffectState const& state, Position target,
		    King8Info canMoveMask,Direction d,Move& bestMove){
  Position pos=target-Board_Table.getOffset<P>(d);
  if(state.countEffect(P,pos)<2 &&
     !effect_util::AdditionalEffect::hasEffect(state,pos,P)) return false;
  PieceMask pieceMask=state.getOnBoardMask(P)&state.getEffect(pos);
  assert(pos.isOnBoard());
  // 玉で王手をかけない
  pieceMask.reset(KingTraits<P>::index);
  for(int i=0;i<=PieceMask::numToIndex(40);i++){
    mask_t mask=pieceMask.getMask(i);
    while (mask.any()){
      const int num=mask.takeOneBit()+i*32;
      if(hasCheckmateMoveDirPiece<P,setBestMove>(state,target,canMoveMask,d,pos,state.getPieceOf(num),bestMove)) return true;
    }
  }
  return false;
}

// not KNIGHT
template<osl::Player P,bool setBestMove>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMove(NumEffectState const& state, Position target,
		 King8Info canMoveMask,Move& bestMove)
{
  assert(! state.inCheck());
  typedef misc::GeneralMask<unsigned int> mask_t;
  mask_t mask2=mask_t::makeDirect((canMoveMask.value>>24)&0xff);
  while(mask2.any()){
    Direction d=static_cast<Direction>(mask2.takeOneBit());
    if(hasCheckmateMoveDir<P,setBestMove>(state,target,canMoveMask,d,bestMove)) return true;
  }
  return false;
}

template<osl::Player P>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMove(NumEffectState const& state, King8Info canMoveMask)
{
  const Player altP=PlayerTraits<P>::opponent;
  const Position target=state.getKingPosition(altP);
  assert(target.isOnBoard());
  // 相手からの王手がかかっていない
  Move dummy;
  if(hasCheckmateMove<P,false>(state,target,canMoveMask,dummy)) return true;
  if(detail::hasCheckmateMoveKnight<P,false>(state,target,canMoveMask,dummy)) return true;
  return hasCheckmateDrop<P,false>(state,target,canMoveMask,dummy);
}

template<osl::Player P>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMove(NumEffectState const& state)
{
  const Player altP=PlayerTraits<P>::opponent;
  const Position target=state.getKingPosition(altP);
  assert(target.isOnBoard());
  King8Info canMoveMask(state.Iking8Info(altP));
  return hasCheckmateMove<P>(state, canMoveMask);
}

template<osl::Player P>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMove(NumEffectState const& state, King8Info canMoveMask,
		 Position target, Move& bestMove)
{
  assert(! state.inCheck());
  assert(target.isOnBoard());

  if(hasCheckmateMove<P,true>(state,target,canMoveMask,bestMove)) return true;
  if(detail::hasCheckmateMoveKnight<P,true>(state,target,canMoveMask,bestMove)) return true;
  return  hasCheckmateDrop<P,true>(state,target,canMoveMask,bestMove);
}

template<osl::Player P>
bool osl::checkmate::ImmediateCheckmate::
hasCheckmateMove(NumEffectState const& state,Move& bestMove)
{
  const Player altP=PlayerTraits<P>::opponent;
  const Position target=state.getKingPosition(altP);
  King8Info canMoveMask(state.Iking8Info(altP));
  return hasCheckmateMove<P>(state, canMoveMask, target, bestMove);
}

#endif /* _CHECKMATE_IMMEDIATE_CHECKMATE_TCC */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

