package ru.novosoft.uml.gen;

import java.util.*;
import java.io.*;

import ru.novosoft.uml.gen.mmm.*;

public class GenMMXMIReader extends GenMMWriter
{
  public static String CLASSNAME = "XMIReader";
  public static String PACKAGE= "ru.novosoft.uml.xmi";

  protected MPackage root = null;

  GenMMXMIReader(GenMM g, HashMap hmTypes) throws IOException
  {
    super(g, PACKAGE, CLASSNAME+".java");
    try
    {
      root = g.getRootPackage();

      prolog();

      sline("package "); print(PACKAGE); println(";");
      println();

      imports();

      println();
      sline("public class "); print(CLASSNAME); println(" extends HandlerBase");
      sblock();

      appendResource(PACKAGE, CLASSNAME+".user");

      // startElement

      line("public void startElement(String p_name, AttributeList p_attrs)");
      sblock();

      line("try");
      sblock();

      line("if (deepNotModelProcessing > 0)");
      sblock();
      line("deepNotModelProcessing++;");
      line("return;");
      eblock();
      println();

      line("Object o = liStack.get(liStack.size()-1);");
      println();

      line("boolean processed = false;");

      line("if (o instanceof Integer)");
      sblock();
      line("processed = processIntegerMain(p_name, p_attrs);");
      eblock();

      line("else if (o instanceof MExtension)");
      sblock();


      line("if (0 != lastString.length())");
      sblock();
        line("lastXMIExtension.addContent(lastString.toString());");
      eblock();
      println();

      line("Element newelem1 = new Element(p_name);");
      line("lastXMIExtension.addContent(newelem1);");
      println();

      line("int l1 = p_attrs.getLength();");
      line("for (int j1=0; j1<l1; j1++)");
      sblock();
        line("newelem1.addAttribute(p_attrs.getName(j1), p_attrs.getValue(j1));");
      eblock();
      line("lastXMIExtension = newelem1;");
      println();

      line("liStack.add(STATE_EXTENSION);");
      line("liNameStack.add(p_name);");
      println();

      line("processed = true;");
      eblock();

      HashSet hsProcessedClasses = new HashSet();
      HashSet hsLevel = new HashSet();

      Iterator i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        Collection colSub = c.getSubClasses();
        if (null == colSub || 0 == colSub.size())
        {
          hsLevel.add(c);
        }
      }

      while(!hsLevel.isEmpty())
      {
        i = hsLevel.iterator();
        while(i.hasNext())
        {
          MClass c = (MClass)i.next();
          if (!hsProcessedClasses.contains(c))
          {
            hsProcessedClasses.add(c);
            if ((c instanceof MElement || c instanceof MDataType) && (!c.getName().equals("Base") && !c.getName().equals("Extension")))
            {
              genSelectorElement(c);
            }
          }
        }

        HashSet hsNext = new HashSet();
        i = hsLevel.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          Collection colSuper = c.getSuperClasses();
          if (null != colSuper)
          {
            hsNext.addAll(colSuper);
          }
        }

        HashSet all = new HashSet();
        i = hsNext.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          getSuperclasses(c, all);
        }

        hsNext.removeAll(all);
        hsLevel = hsNext;
      }
      println();

      line("if (!processed)");
      sblock();
      sif("0 == deepNotModelProcessing");
/*
      line("System.err.println(\"[Error] \" + p_attrs.getValue(\"xmi.id\"));");
      line("System.err.println(\"[Error] \" + p_attrs.getValue(\"xmi.idref\"));");
*/
      line("System.err.println(\"[Error] Illegal element '\" + p_name + \"'\");");
      eif();
      println();

      line("deepNotModelProcessing = 1;");
      println();

      line("liStack.add(STATE_UNKNOWN);");
      line("liNameStack.add(p_name);");
      println();

      line("return;");
      eblock();
      println();

      line("lastString = new StringBuffer();");

      eblock();
      line("catch (Exception ex)");
      sblock();
      line("ex.printStackTrace();");
      eblock();

      eblock();
      println();

      // endElement

      line("public void endElement(String p_name)");
      sblock();

      line("try");
      sblock();

      sif("deepNotModelProcessing > 0");
        line("deepNotModelProcessing--;");
        sif("0 == deepNotModelProcessing");
          line("liStack.remove(liStack.size()-1);");
          line("liNameStack.remove(liNameStack.size()-1);");
          println();
  
          //line("deepNotModelProcessing = -1;");
        eif();
        println();
        line("return;");
      eif();
      println();

      line("Object o = liStack.get(liStack.size()-2);");
      line("Object o2 = liStack.get(liStack.size()-1);");
      line("boolean bMultiple = false;");
      println();

      sif("STATE_MULTIPLE == o");
      line("p_name = (String)liNameStack.get(liNameStack.size()-2);");
      line("lastObject = liStack.get(liStack.size()-1);");
      line("liStack.remove(liStack.size()-1);");
      line("liNameStack.remove(liNameStack.size()-1);");
      line("o = liStack.get(liStack.size()-2);");
      line("bMultiple = true;");
      eif();

      println();

      line("try");
      sblock();

      //sif("deepNotModelProcessing < 0");
      //  line("deepNotModelProcessing = 0;");
      //eblock();
      line("if (STATE_MULTIPLE == o2)");
      sblock();
      eblock();
      line("else if (o instanceof Integer)");
      sblock();
      line("postprocessIntegerMain(p_name);");
      eblock();
      line("else if (o instanceof MExtension)");
      sblock();
      line("if (0 != lastString.length())");
        sblock();
          line("lastXMIExtension.addContent(lastString.toString());");
        eblock();
        line("lastXMIExtension = lastXMIExtension.getParent();");
      eblock();

      hsProcessedClasses = new HashSet();
      hsLevel = new HashSet();

      i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        Collection colSub = c.getSubClasses();
        if (null == colSub || 0 == colSub.size())
        {
          hsLevel.add(c);
        }
      }

      while(!hsLevel.isEmpty())
      {
        i = hsLevel.iterator();
        while(i.hasNext())
        {
          MClass c = (MClass)i.next();
          if (!hsProcessedClasses.contains(c))
          {
            hsProcessedClasses.add(c);
            if ((c instanceof MElement || c instanceof MDataType) && (!c.getName().equals("Base") && !c.getName().equals("Extension")))
            {
              genSelectorEndElement(c);
            }
          }
        }

        HashSet hsNext = new HashSet();
        i = hsLevel.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          Collection colSuper = c.getSuperClasses();
          if (null != colSuper)
          {
            hsNext.addAll(colSuper);
          }
        }

        HashSet all = new HashSet();
        i = hsNext.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          getSuperclasses(c, all);
        }

        hsNext.removeAll(all);
        hsLevel = hsNext;
      }

      eblock();
      line("catch (ClassCastException ex)");
      sblock();
      eblock();

      line("if (!bMultiple)");
      sblock();
      line("lastObject = liStack.get(liStack.size()-1);");
      line("liStack.remove(liStack.size()-1);");
      line("liNameStack.remove(liNameStack.size()-1);");
      eblock(); 

      line("lastString = new StringBuffer();");

      eblock();
      line("catch (Exception ex)");
      sblock();
      line("ex.printStackTrace();");
      eblock();

      eblock();
      println();

      // process

      line("public Object process(String p_name, AttributeList p_attrs)");
      sblock();
      line("boolean ref = false;");
      line("if (null != p_attrs)");
      sblock();
      line("ref = (null != p_attrs.getValue(\"xmi.idref\")) ||"); ident();
      line("(null != p_attrs.getValue(\"xmi.uuidref\"));"); unident();
      eblock();
      println();
 
      line("String lastName = null;");
      line("String nodeName = p_name;");
      println();
  
      i = root.getElements().iterator();
      while(i.hasNext())
      {
        Object o = i.next();
        if (o instanceof MPackage)
        {
          genSelectorPackage((MPackage)o, 0);
        }
      }
      println();

      line("return null;");
  
      eblock();

      i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        if ((c instanceof MElement || c instanceof MDataType) && (!c.getName().equals("Base") && !c.getName().equals("Extension")))
        {
          genClass(c);
        }
      }

      eblock();
    }
    finally
    {
      close();
    }
  }

  protected void imports()
  {
    importCollections();
    sline("import "); print(getGenerator().getCollectionsPackage()); println(".HashMap;");
    sline("import "); print(getGenerator().getCollectionsPackage()); println(".Map;");

    println();

    line("import java.util.StringTokenizer;");
    println();
    
    line("import java.io.*;");
    println();

    line("import org.jdom.*;");
    println();

    line("import ru.novosoft.uml.*;");
    line("import ru.novosoft.uml.foundation.core.*;");
    line("import ru.novosoft.uml.foundation.data_types.*;");
    line("import ru.novosoft.uml.foundation.extension_mechanisms.*;");
    line("import ru.novosoft.uml.behavior.*;");
    line("import ru.novosoft.uml.behavior.use_cases.*;");
    line("import ru.novosoft.uml.behavior.common_behavior.*;");
    line("import ru.novosoft.uml.behavior.state_machines.*;");
    line("import ru.novosoft.uml.behavior.collaborations.*;");
    line("import ru.novosoft.uml.behavior.activity_graphs.*;");
    line("import ru.novosoft.uml.model_management.*;");
    println();
    
    //line("import org.w3c.dom.*;");
    println();
    
    line("import org.xml.sax.*;");
    line("import javax.xml.parsers.*;");
  }

  protected void genClass(MClass p_cls)
  {
    if (!p_cls.isAbstract())
    {
      // process

      sline("public boolean "); printProcessMainName(p_cls); println("(String p_name, AttributeList p_attrs)");
      sblock();
      if (p_cls instanceof MDataType)
      {
        sline(); printUMLMName(p_cls); print("Editor o = ("); printUMLMName(p_cls); println("Editor)liStack.get(liStack.size()-1);");
      }
      else
      {
        sline(); printUMLMName(p_cls); print(" o = ("); printUMLMName(p_cls); println(")liStack.get(liStack.size()-1);");
      }

      println();
      {
        sline("if ("); printProcessAttributesName(p_cls); println("(p_name, p_attrs, o))");
        sblock();
        line("return true;");
        eblock();
        println();
    
        sline("if ("); printProcessRolesName(p_cls); println("(p_name, p_attrs, o))");
        sblock();
        line("return true;");
        eblock();
      }

      line("return processXMIExtensionMain(p_name, p_attrs);");

      eblock();
      println();

      // postprocess

      sline("public void "); printPostProcessMainName(p_cls); println("(String p_name)");
      sblock();

      if (p_cls instanceof MDataType)
      {
        //sline("Object o = ("); printUMLMName(p_cls); println("Editor)liStack.get(liStack.size()-2);");
        //sline("if (o instanceof "); printUMLMName(p_cls); println(")");
        //sblock();
        sline(); printUMLMName(p_cls); print("Editor o = ("); printUMLMName(p_cls); println("Editor)liStack.get(liStack.size()-2);");
        //eblock();
      }
      else
      {
        sline(); printUMLMName(p_cls); print(" o = ("); printUMLMName(p_cls); println(")liStack.get(liStack.size()-2);");
      }
      println();

      sline("if ("); printPostProcessAttributesName(p_cls); println("(p_name, o))");
      sblock();
      line("return;");
      eblock();
      println();
  
      sline("if ("); printPostProcessRolesName(p_cls); println("(p_name, o))");
      sblock();
      line("return;");
      eblock();

      line("postprocessXMIExtensionMain(p_name, o);");

      eblock();
      println();
    }

    if (!p_cls.getName().equals("MultiplicityRange") && !p_cls.getName().equals("Multiplicity"))
    {
      genClassAttributes(p_cls);
      genClassRoles(p_cls);
    }
  }

  protected void genClassAttributes(MClass p_cls)
  {
    // process

    if (p_cls instanceof MDataType)
    {
      sline("public boolean "); printProcessAttributesName(p_cls); print("(String p_name, AttributeList p_attrs, "); printUMLMName(p_cls); println("Editor o)");
    }
    else
    {
      sline("public boolean "); printProcessAttributesName(p_cls); print("(String p_name, AttributeList p_attrs, "); printUMLMName(p_cls); println(" o)");
    }
    sblock();

    HashSet all = new HashSet();
    HashSet sc1 = new HashSet();

    Iterator i = p_cls.getSuperClasses().iterator();
    MClass sc = null;
    if (i.hasNext())
    {
      sc = (MClass)i.next();

      if (!sc.getName().equals("Base") && !sc.getName().equals("Extension"))
      {
        sline("if ("); printProcessAttributesName(sc); println("(p_name, p_attrs, o))");
        sblock();
        line("return true;");
        eblock();
      }
    }

    getSuperclasses(p_cls, all);
    getSuperclasses(sc, sc1);

    HashSet notImpl = new HashSet(all);

    notImpl.removeAll(sc1);
    notImpl.remove(sc);
    notImpl.add(p_cls);

    i = notImpl.iterator();
    while (i.hasNext())
    {
      MClass ic = (MClass)i.next();

      Iterator j = ic.getAttributes().iterator();
      if (j.hasNext())
      {
        sline("if (p_name.startsWith(\""); print(getFullXMITagName(ic)); println(".\"))");
        sblock();
        sline("String lastName = p_name.substring("); print(getFullXMITagName(ic).length() + 1); println(");");
        println();

        while(j.hasNext())
        {
          MAttribute attr = (MAttribute)j.next();
          genClassAttribute(p_cls, attr);
        }

        eblock();
      }
    }

    line("return false;");
    eblock();
    println();

    // postprocess

    if (p_cls instanceof MDataType)
    {
      sline("public boolean "); printPostProcessAttributesName(p_cls); print("(String p_name, "); printUMLMName(p_cls); println("Editor o)");
    } 
    else
    {
      sline("public boolean "); printPostProcessAttributesName(p_cls); print("(String p_name, "); printUMLMName(p_cls); println(" o)");
    }
    sblock();

    all = new HashSet();
    sc1 = new HashSet();

    i = p_cls.getSuperClasses().iterator();
    sc = null;
    if (i.hasNext())
    {
      sc = (MClass)i.next();

      if (!sc.getName().equals("Base") && !sc.getName().equals("Extension"))
      {
        sline("if ("); printPostProcessAttributesName(sc); println("(p_name, o))");
        sblock();
        line("return true;");
        eblock();
      }
    }

    getSuperclasses(p_cls, all);
    getSuperclasses(sc, sc1);

    notImpl = new HashSet(all);

    notImpl.removeAll(sc1);
    notImpl.remove(sc);
    notImpl.add(p_cls);

    i = notImpl.iterator();
    while (i.hasNext())
    {
      MClass ic = (MClass)i.next();

      Iterator j = ic.getAttributes().iterator();
      if (j.hasNext())
      {
        sline("if (p_name.startsWith(\""); print(getFullXMITagName(ic)); println(".\"))");
        sblock();
        sline("String lastName = p_name.substring("); print(getFullXMITagName(ic).length() + 1); println(");");
        println();

        while(j.hasNext())
        {
          MAttribute attr = (MAttribute)j.next();
          genClassPostAttribute(p_cls, attr);
        }

        eblock();
      }
    }

    line("return false;");
    eblock();
    println();
  }

  protected void genClassAttribute(MClass p_cls, MAttribute p_attr)
  {
    sline("if (lastName.equals(\""); print(p_attr.getName()); println("\"))");
    sblock();

    sline("lastMethod = \""); print(p_attr.getName()); println("\";");
    line("lastMethodType = true;");

    if (p_attr.getType().getName().equals("Boolean"))
    {
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(convertXMIBooleanValue(p_attrs.getValue(\"xmi.value\")));");
    }
    else if (p_attr.getType() instanceof MEnum)
    {
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); print("("); printUMLMName(p_attr.getType()); println(".forName(p_attrs.getValue(\"xmi.value\")));");
    }
    else if(p_attr.getType().getName().equals("MultiplicityRange"))
    {
      throw new IllegalArgumentException("Attributes with MultiplicityRange type are not supported.");
    }
    else if (p_attr.getType() instanceof MDataType)
    {
      line("liStack.add(STATE_SINGLE);");
      line("liNameStack.add(p_name);");
      line("return true;");
      eblock();
      println();
      return;
    }

    line("liStack.add(o);");
    line("liNameStack.add(p_name);");
    line("return true;");
    eblock();
    println();
  }

  protected void genClassPostAttribute(MClass p_cls, MAttribute p_attr)
  {
    sline("if (lastName.equals(\""); print(p_attr.getName()); println("\"))");
    sblock();

    if (p_attr.getType().getName().equals("Name") || p_attr.getType().getName().equals("String") || p_attr.getType().getName().equals("LocationReference") || p_attr.getType().getName().equals("Geometry"))
    {
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(lastString.toString());");
    }
    else if(p_attr.getType().getName().equals("MultiplicityRange"))
    {
      throw new IllegalArgumentException("Attributes with MultiplicityRange type are not supported.");
    }
    else if (p_attr.getType().getName().equals("Integer") || p_attr.getType().getName().equals("UnlimitedInteger"))
    {
      line("if (0 != lastString.length())");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(Integer.parseInt(lastString.toString()));");
      eblock();
      line("else");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(0);");
      eblock();
    }
    else if (p_attr.getType() instanceof MDataType)
    {
      line("if (!(lastObject instanceof Link))");
      sblock();
      sline(); printUMLMName(p_attr.getType()); println(" oexp = null;");
      sline("if (lastObject instanceof "); printUMLMName(p_attr.getType()); println(")");
      sblock();
      sline("oexp = ("); printUMLMName(p_attr.getType()); println(")lastObject;");
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(oexp);");
      eblock();
      line("else");
      sblock();
      sline("oexp = (("); printUMLMName(p_attr.getType()); print("Editor)lastObject).to"); print(p_attr.getType().getName()); println("();");
      println();
      line("String xmiid = getXMIIDByElement(lastObject);");
      sif("null != xmiid");
      line("removeXMIID(lastObject);");
      line("putXMIID(xmiid, oexp);");
      eif();
      println();
      line("String xmiuuid = getXMIUUIDByElement(lastObject);");
      sif("null != xmiuuid");
      line("removeXMIUUID(lastObject);");
      line("putXMIUUID(xmiuuid, oexp);");
      eif();
      eblock();
      println();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(oexp);");
      eblock();
    }

    line("return true;");
    eblock();
    println();
  }

  protected void genClassRoles(MClass p_cls)
  {
    // process

    if (p_cls instanceof MDataType)
    {
      sline("public boolean "); printProcessRolesName(p_cls); print("(String p_name, AttributeList p_attrs, "); printUMLMName(p_cls); println("Editor o)");
    }
    else
    {
      sline("public boolean "); printProcessRolesName(p_cls); print("(String p_name, AttributeList p_attrs, "); printUMLMName(p_cls); println(" o)");
    }
    sblock();

    HashSet all = new HashSet();
    HashSet sc1 = new HashSet();

    Iterator i = p_cls.getSuperClasses().iterator();
    MClass sc = null;
    if (i.hasNext())
    {
      sc = (MClass)i.next();

      if (!sc.getName().equals("Base") && !sc.getName().equals("Extension"))
      {
        sline("if ("); printProcessRolesName(sc); println("(p_name, p_attrs, o))");
        sblock();
        line("return true;");
        eblock();
      }
    }

    getSuperclasses(p_cls, all);
    getSuperclasses(sc, sc1);

    HashSet notImpl = new HashSet(all);

    notImpl.removeAll(sc1);
    notImpl.remove(sc);
    notImpl.add(p_cls);

    i = notImpl.iterator();
    while (i.hasNext())
    {
      MClass ic = (MClass)i.next();

      Iterator j = ic.getRoles().iterator();

      if (j.hasNext())
      {
        sline("if (p_name.startsWith(\""); print(getFullXMITagName(ic)); println(".\"))");
        sblock();
        sline("String lastName = p_name.substring("); print(getFullXMITagName(ic).length() + 1); println(");");
        println();

        while(j.hasNext())
        {
          MRole role = (MRole)j.next();
          genClassRole(ic, oppositeRole(role));
        }

        eblock();
      }
    }
    println();

    //line("return processXMIExtension(o, n);");
    line("return false;");

    eblock();
    println();

    // postprocess

    if (p_cls instanceof MDataType)
    {
      sline("public boolean "); printPostProcessRolesName(p_cls); print("(String p_name, "); printUMLMName(p_cls); println("Editor o)");
    }
    else
    {
      sline("public boolean "); printPostProcessRolesName(p_cls); print("(String p_name, "); printUMLMName(p_cls); println(" o)");
    }
    sblock();

    all = new HashSet();
    sc1 = new HashSet();

    i = p_cls.getSuperClasses().iterator();
    sc = null;
    if (i.hasNext())
    {
      sc = (MClass)i.next();

      if (!sc.getName().equals("Base") && !sc.getName().equals("Extension"))
      {
        sline("if ("); printPostProcessRolesName(sc); println("(p_name, o))");
        sblock();
        line("return true;");
        eblock();
      }
    }

    getSuperclasses(p_cls, all);
    getSuperclasses(sc, sc1);

    notImpl = new HashSet(all);

    notImpl.removeAll(sc1);
    notImpl.remove(sc);
    notImpl.add(p_cls);

    i = notImpl.iterator();
    while (i.hasNext())
    {
      MClass ic = (MClass)i.next();

      Iterator j = ic.getRoles().iterator();

      if (j.hasNext())
      {
        sline("if (p_name.startsWith(\""); print(getFullXMITagName(ic)); println(".\"))");
        sblock();
        sline("String lastName = p_name.substring("); print(getFullXMITagName(ic).length() + 1); println(");");
        println();

        while(j.hasNext())
        {
          MRole role = (MRole)j.next();
          genClassPostRole(ic, oppositeRole(role));
        }

        eblock();
      }
    }
    println();

    //line("return processXMIExtension(o, n);");
    line("return false;");

    eblock();
    println();
  }

  protected void genClassRole(MClass p_cls, MRole p_role)
  {
    if (!p_role.getName().equals(""))
    {
      MRole roleOp = oppositeRole(p_role);
      if (!p_role.getName().substring(0, 1).equals("/") && !roleOp.getName().substring(0, 1).equals("/"))
      {
        sline("if (lastName.equals(\""); printXMIRoleName(p_role); println("\"))");
        sblock();

        if (p_role.isNavigable() && ((!roleOp.isNavigable()) ||
          (roleOp.isComposite()) ||  
          (!p_role.isComposite() && roleOp.getKind().equals("ref")) ||
          (!p_role.isComposite() && (roleOp == roleOp.getAssociation().getRoles().get(0)))))
        {
          sline("lastMethod = \""); print(p_role.getName()); println("\";");
        }
        else
        {
          line("lastMethod = null;");
        }

        if (p_role.getKind().equals("bag") || p_role.getKind().equals("list"))
        {
          line("lastMethodType = false;");
          line("liStack.add(STATE_MULTIPLE);");
        }
        else
        {
          line("lastMethodType = true;");
          line("liStack.add(STATE_SINGLE);");
        }
        line("liNameStack.add(p_name);");
        line("return true;");

        eblock();
      }
    }
  }

  protected void genClassPostRole(MClass p_cls, MRole p_role)
  {
    if (!p_role.getName().equals(""))
    {
      MRole roleOp = oppositeRole(p_role);
      if (!p_role.getName().substring(0, 1).equals("/") && !roleOp.getName().substring(0, 1).equals("/"))
      {
        sline("if (lastName.equals(\""); printXMIRoleName(p_role); println("\"))");
        sblock();

        {
          if (p_role.getKind().equals("bag") || p_role.getKind().equals("list"))
          {
            MClass rt = p_role.getType();
  
            sline(); printUMLMName(rt); print(" el = ("); printUMLMName(rt); println(")lastObject;");
  
            line("if (null != el)");
            sblock();

            if (p_role.isNavigable() && ((!roleOp.isNavigable()) ||
              (roleOp.isComposite()) ||  
              (!p_role.isComposite() && roleOp.getKind().equals("ref")) ||
              (!p_role.isComposite() && (roleOp == roleOp.getAssociation().getRoles().get(0)))))
            {
              sline("o.add"); printJavaName(p_role.getName()); println("(el);");
            }

            line("return true;");
            eblock();
          }
          else
          {
            sline(); printUMLMName(p_role.getType()); print(" el = ("); printUMLMName(p_role.getType()); println(")lastObject;");

            line("if (null != el)");
            sblock();

            if (p_role.isNavigable() && ((!roleOp.isNavigable()) ||
              roleOp.isComposite() || 
              //(!p_role.isComposite() && (roleOp.getKind().equals("ref") && (p_role.getKind().equals("bag") || p_role.getKind().equals("list")))) ||
              (!p_role.isComposite() && (roleOp == roleOp.getAssociation().getRoles().get(0)))))
            {
              sline("o.set"); printJavaName(p_role.getName()); println("(el);");
            }

            line("return true;");
            eblock();
          }
        }

        line("return false;");
        eblock();
      }
    }
  }

  protected void genSelectorPackage(MPackage p_mpackage, int p_level)
  {
    String packageName = p_mpackage.getName();
    boolean bFirst = true;

    if (null == packageName)
    {
      packageName = "";
    }

    sline("if (nodeName.startsWith(\""); print(packageName); 
      print(".\","); print(p_level); println("))");
    sblock();

    Iterator i = p_mpackage.getElements().iterator();
    while(i.hasNext())
    {
      Object o = i.next();
      if (o instanceof MPackage)
      {
        genSelectorPackage((MPackage)o, p_level+packageName.length() + 1);
      }
    } 

    i = p_mpackage.getElements().iterator();
    while(i.hasNext())
    {
      Object o = i.next();
      if(o instanceof MElement || o instanceof MDataType)
      {
        if (bFirst)
        {
          bFirst = false;
          sline("lastName = nodeName.substring("); print(p_level+packageName.length() + 1); println(");");
          println();
        }

        genSelector((MClass)o);
      }
    }

    eblock();
  }

  protected void genSelector(MClass p_cls)
  {
      sline("if (lastName.equals(\"");
        print(p_cls.getName().replace(' ', '_')); println("\"))");
      sblock();
      line("if (ref)");
      sblock();

      if (p_cls instanceof MDataType)
      {
        if (p_cls.getName().equals("MultiplicityRange"))
        {
          line("throw new IllegalArgumentException(\"Reference to MultiplicityRange not supported!!!\");");
        }
        else
        {
          line("Object o = getObjectByRef(p_attrs);");
          line("if (null == o || this == o)");
          sblock();
          line("putObjectByRef(p_attrs, this);");
          line("Link l = new Link();");
          line("l.parameterXMIID = p_attrs.getValue(\"xmi.idref\");");
          line("l.parameterXMIUUID = p_attrs.getValue(\"xmi.uuidref\");");
          line("return l;");
          eblock();
          println();
          line("return o;");
        }
      }
      else
      {
        line("Object o = getObjectByRef(p_attrs);");
        line("if (null == o || this == o)");
        sblock();
        line("putObjectByRef(p_attrs, this);");
        line("Link l = new Link();");
        line("l.parameterXMIID = p_attrs.getValue(\"xmi.idref\");");
        line("l.parameterXMIUUID = p_attrs.getValue(\"xmi.uuidref\");");
        line("return l;");
        eblock();
        println();

        if (!p_cls.isAbstract())
        {
          sline(); printUMLMName(p_cls); print(" o2 = ("); printUMLMName(p_cls); println(")o;");
  
          if ("Model".equals(p_cls.getName()))
          {
            line("if (null == rootModel)");
            sblock();
            line("rootModel = o2;");
            eblock();
          }
  
          line("String nodeXMIUUID = p_attrs.getValue(\"xmi.uuidref\");");
          println();
          line("if (null != nodeXMIUUID)");
          sblock();
          line("o2.setUUID(nodeXMIUUID);");
          eblock();
          line("putObjectByRef(p_attrs, o2);");
  
          println();
          line("return o2;");
        }
        else
        {
          line("return o;");
        }
      }

      eblock();

      if (!p_cls.isAbstract())
      {
        line("else");
        sblock();
        if (p_cls instanceof MDataType)
        {
          sline(); printUMLMName(p_cls); print("Editor o = new "); printUMLMName(p_cls); println("Editor();");
          line("String nodeXMIUUID = p_attrs.getValue(\"xmi.uuid\");");
          println();
          /*
          line("if (null != nodeXMIUUID)");
          sblock();
          line("o.setUUID(nodeXMIUUID);");
          eblock();
          */
          line("putObject(p_attrs, o);");
          println();
          line("return o;");
        }
        else
        {
          sline(); printUMLMName(p_cls); println(" o2;");
          line("Object o = getObject(p_attrs);");
          line("if (null == o || this == o)");
          sblock();
          sline("o2 = factory.create"); printUMLName(p_cls); println("();");
          if ("Model".equals(p_cls.getName()))
          {
            line("if (null == rootModel)");
            sblock();
            line("rootModel = o2;");
            eblock();
          }
          eblock();
          line("else");
          sblock();
          sline("o2 = ("); printUMLMName(p_cls); println(")o;");
          eblock();
  
          println();
          line("String nodeXMIUUID = p_attrs.getValue(\"xmi.uuid\");");
          println();
          line("if (null != nodeXMIUUID)");
          sblock();
          line("o2.setUUID(nodeXMIUUID);");
          eblock();
          line("putObject(p_attrs, o2);");
  
          println();
          line("return o2;");
        }
        eblock();
      }

      eblock();
      println();
  }

  protected void genSelectorElement(MClass p_cls)
  {
    if (!p_cls.isAbstract())
    {
      if (p_cls instanceof MDataType)
      {
        sline("else if (o instanceof "); printUMLMName(p_cls); println("Editor)");
      }
      else
      {
        sline("else if (o instanceof "); printUMLMName(p_cls); println(")");
      }
      sblock();
      sline("processed = "); printProcessMainName(p_cls); println("(p_name, p_attrs);");
      eblock();
    }
  }

  protected void genSelectorEndElement(MClass p_cls)
  {
    if (!p_cls.isAbstract())
    {
      if (p_cls instanceof MDataType)
      {
        sline("else if (o instanceof "); printUMLMName(p_cls); println("Editor)");
      }
      else
      {
        sline("else if (o instanceof "); printUMLMName(p_cls); println(")");
      }
      sblock();
      sline(); printPostProcessMainName(p_cls); println("(p_name);");
      eblock();
    }
  }

  protected String getFullXMITagName(MClass p_cls)
  {
    MPackage pkg = p_cls.getPackage();
    String s = "";

    while (pkg != root)
    {
      s = pkg.getName() + "." + s;
      pkg = pkg.getPackage();
    }

    return s + p_cls.getName().replace(' ', '_');
  }

  public void printProcessMainName(MClass p_cls)
  {
    print("process"); print(p_cls.getName()); print("Main");
  }

  public void printPostProcessMainName(MClass p_cls)
  {
    print("postprocess"); print(p_cls.getName()); print("Main");
  }

  public void printProcessAttributesName(MClass p_cls)
  {
    print("process"); print(p_cls.getName()); print("Attributes");
  }

  public void printPostProcessAttributesName(MClass p_cls)
  {
    print("postprocess"); print(p_cls.getName()); print("Attributes");
  }

  public void printProcessRolesName(MClass p_cls)
  {
    print("process"); print(p_cls.getName()); print("Roles");
  }

  public void printPostProcessRolesName(MClass p_cls)
  {
    print("postprocess"); print(p_cls.getName()); print("Roles");
  }

  public void printUMLMName(MClass p_cls)
  {
    print("M"); print(p_cls.getName());
  }

  public void printUMLName(MClass p_cls)
  {
    print(p_cls.getName());
  }

  public void printJavaName(String p_name)
  {
    print(p_name.substring(0, 1).toUpperCase() + p_name.substring(1));
  }

  public String xmiElementName(String s)
  {
    String s2 = s.replace(' ', '_');
    return s2.substring(0, 1).toUpperCase() + s2.substring(1);
  }

  public void printGetterUML(MClass p_cls, String p_name)
  {
    if (p_cls.getName().equals("Boolean"))
    {
      print(p_name);
    }

    print("get"); printJavaName(p_name);
  }

  public void printSetterUML(MClass p_cls, String p_name)
  {
    print("set");
    if (p_cls.getName().equals("Boolean"))
    {
      printJavaName(p_name.substring(2));
    }
    else
    {
      printJavaName(p_name);
    }
  }

  protected void printXMIRoleName(MRole p_role)
  {
    String xminame = p_role.getXMIName();
    if (null == xminame || xminame.equals(""))
    {
      xminame = p_role.getName();
    }

    print(xminame);
  }

}