/*
    Copyright (C) 2000,2001 Guillaume Morin, Alcve

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    $Id: torture.c,v 1.12 2001/11/10 13:36:15 loic Exp $
    $Source: /cvsroot/nss-mysql/nss-mysql/tests/torture.c,v $
    $Date: 2001/11/10 13:36:15 $
    $Author: loic $
*/
#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <shadow.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>

/* comments suck */

#define THREAD_NB1 7 
#define THREAD_NB2 1000

#define TEST2_LOOPS 1000

#define ALLOC 10000

struct sh_ {
	int nb;
	char ** e;
};

struct pw_ {
	int nb;
	char ** nam_e;
	int * id_e;
};

struct pw_ password = {0,NULL,NULL};
struct sh_ shadow = {0,NULL};
struct pw_ group = {0,NULL,NULL};

#define sl() sleep((1+(int) (10.0*rand()/(RAND_MAX+1.0)))/10);


void * sp(void * arg) {
	int i = 0;
	struct spwd *s;

	if (arg) {
		shadow.e = malloc(ALLOC * sizeof(char *));
	}
	setspent();
	while ((s = getspent()) != NULL) {
		if (arg) {
			if (i > ALLOC) {
				puts("After allocation ...");
				continue;
			}
			shadow.e[i] = s->sp_namp;
			++i;
			continue;
		}
		sl();	
	}
	if (arg) shadow.nb = i;
	endspent();
	return NULL;
}
	
void * gr(void * arg) {
	struct group *g;
	int i = 0;

	if (arg) {
		group.nam_e = malloc(ALLOC * sizeof(char *));
		group.id_e = malloc(ALLOC * sizeof(int));
	}

	setgrent();
	while ((g = getgrent()) != NULL) {
		if (arg) {
			if (i>ALLOC) {
				puts("After allocation ...");
				continue;
			}
			group.nam_e[i] = g->gr_name;
			group.id_e[i] = g->gr_gid;
			++i;
			continue;
		} 
		sl();
	}
	if (arg) group.nb = i;
	endgrent();
	return NULL;
}

void * pw(void * arg) {
	struct passwd *p;
	int i = 0;

	if (arg) {
		password.nam_e = malloc(ALLOC * sizeof(char *));
		password.id_e = malloc(ALLOC * sizeof(int));
	}
	
	setpwent();
	while ((p = getpwent()) != NULL) {
		if (arg) {
			if (i>ALLOC) {
				puts("After allocation ...");
				continue;
			}
			password.nam_e[i] = p->pw_name;
			password.id_e[i] = p->pw_uid;
			++i;
			continue;
		} 
		sl();
	}
	if (arg) password.nb = i;
	endpwent();
	return NULL;
}

void * pw_test2(void * arg) {
	int i;
	for (i = 0 ; i < TEST2_LOOPS ; ++i) {
	int n = (int) ((float) password.nb*rand()/(RAND_MAX+1.0));
		getpwnam(password.nam_e[n]);
		sl();
		getpwuid(password.id_e[n]);
	}
	return NULL;
}


void * gr_test2(void * arg) {
	int i;
	for (i=0;i<TEST2_LOOPS;++i) {
		int n = (int) ((float) group.nb*rand()/(RAND_MAX+1.0));
		getgrnam(group.nam_e[n]);
		sl();
		getgrgid(group.id_e[n]);
	}
	return NULL;
}

void * sp_test2(void * arg) {
	int i;
	for (i=0;i<TEST2_LOOPS;++i) {
		int n = (int) ((float) shadow.nb*rand()/(RAND_MAX+1.0));
		getspnam(shadow.e[n]);
		sl();
	}
	return NULL;
}

int main(int argc, char ** argv) {
	pthread_t th[THREAD_NB2];
	int i,j;
	time_t t;

	srand(time(NULL));

	printf("Testing ent functions... ");
	fflush(stdout);
	t = time(NULL);
	for (i = 0 ; i < THREAD_NB1 ; ++i ) {
		switch(j = ((int) (3.0*rand()/(RAND_MAX+1.0)))) {
			case 0:
				pthread_create(&th[i],NULL,sp,NULL);break;
			case 1:
				pthread_create(&th[i],NULL,gr,NULL);break;
			case 2:
				pthread_create(&th[i],NULL,pw,NULL);break;
			default:
				printf("%d, should not happen\n",j);
		}
	}

	for (i = 0 ; i < THREAD_NB1 ; ++i ) {
		pthread_join(th[i],NULL);
	}
	printf("OK (%lu seconds)\n",time(NULL)-t);

	printf("Caching entries...");
	fflush(stdout);
	t = time(NULL);
	sp(&i);
	gr(&i);
	pw(&i);
	printf("OK (%lu seconds)\n",time(NULL)-t);
	if (password.nb) {
		printf("Testing getpw[nam|uid]... ");
		fflush(stdout);
		t = time(NULL);
		for (i = 0 ; i < THREAD_NB2 ; ++i ) {
			pthread_create(&th[i],NULL,pw_test2,NULL);break;
		}

		for (i = 0 ; i < THREAD_NB2 ; ++i ) {
			pthread_join(th[i],NULL);
		}
		printf("OK (%lu seconds)\n",time(NULL)-t);
	}

	if (group.nb) {
		printf("Testing getgr[nam|gid]... ");
		fflush(stdout);
		t= time(NULL);
		for (i = 0 ; i < THREAD_NB2 ; ++i ) {
			pthread_create(&th[i],NULL,gr_test2,NULL);break;
		}
	
		for (i = 0 ; i < THREAD_NB2 ; ++i ) {
			pthread_join(th[i],NULL);
		}
		printf("OK (%lu seconds)\n",time(NULL)-t);
	}

	if (shadow.nb) {
		printf("Testing getspnam... ");
		fflush(stdout);
		t= time(NULL);
		for (i = 0 ; i < THREAD_NB2 ; ++i ) {
			pthread_create(&th[i],NULL,sp_test2,NULL);break;
		}

		for (i = 0 ; i < THREAD_NB2 ; ++i ) {
			pthread_join(th[i],NULL);
		}
		printf("OK (%lu seconds)\n",time(NULL)-t);
	}
	
	return 0;
}

