#!/bin/sh

LOGFILE=test.log
SERVERLOG=serv.log
SSLDIR=./test/ssl
OPENSSL=openssl
LDAPSEARCH=ldapsearch
LDAPCONF=./test/slapd.conf
OPENSSLCONF="-config ./test/openssl/openssl.cnf"
if [ "$RUBY" = "" ]
then
  RUBY=ruby
fi

SCRIPTS="test/bind.rb \
         test/add.rb \
         test/add2.rb \
         test/search.rb \
         test/search2.rb \
         test/search3.rb \
         test/modrdn.rb \
         test/search2.rb \
         test/delete.rb \
	 test/search2.rb"

print_usage(){
  echo "$0 {openldap1|openldap2|openldap2-ssl|newcert|clean} <slapd> <schema-dir>"
}


if [ x"$3" = x"" ]
then
  LDAPSCHEMADIR=
else
  LDAPSCHEMADIR=$3
fi

if [ x"$2" = x"" ]
then
  LDAPD=slapd
else
  LDAPD=$2
fi

case "$1" in
'clean')
  rm -rf $LOGFILE $SERVERLOG $SSLDIR $LDAPCONF
  exit 0
  ;;
'openldap1')
  # for OpenLDAP1
  TESTDIR=./test/openldap1
  LDAPCONFIN=$TESTDIR/slapd.conf.in
  DBDIR=$TESTDIR/test-db
  PIDFILE=$DBDIR/slapd.pid
  PORT=6666
  LDAPURL="ldap://localhost:$PORT/"
  LDAPDOPT="-d 2 -f $LDAPCONF -h \"$LDAPURL\""
  LDAPDCMD="$LDAPD $LDAPDOPT"
  ;;
'openldap2')
  # for OpenLDAP2
  TESTDIR=./test/openldap2
  LDAPCONFIN=$TESTDIR/slapd.conf.in
  DBDIR=$TESTDIR/test-db
  PIDFILE=$DBDIR/slapd.pid
  PORT=6666
  LDAPURL="ldap://localhost:$PORT/"
  LDAPDOPT="-d 2 -f $LDAPCONF -h \"$LDAPURL\""
  LDAPDCMD="$LDAPD $LDAPDOPT"
  SCRIPTS="$SCRIPTS test/subschema.rb"
  ;;
'openldap2-ssl')
  # -- experimental -- OpenLDAP2 with SSL,SASL
  TESTDIR=./test/openldap2
  LDAPCONFIN=$TESTDIR/slapd-ssl.conf.in
  DBDIR=$TESTDIR/test-db
  PIDFILE=$DBDIR/slapd.pid
  PORT=6666
  SSLPORT=6667
  LDAPURL="ldaps://localhost:$SSLPORT/ ldap://localhost:$PORT/"
  LDAPDOPT="-d127 -f $LDAPCONF -h \"$LDAPURL\""
  LDAPDCMD="$LDAPD $LDAPDOPT"
  SCRIPTS="$SCRIPTS test/subschema.rb test/bind-ssl.rb test/bind-ldaps.rb"
  ;;
'newcert')
  rm -rf $SSLDIR
  mkdir $SSLDIR
  openssl req -new -x509 -out $SSLDIR/server.pem \
          -nodes -keyout $SSLDIR/server.pem \
	  -config ./test/openssl/openssl.cnf
  exit 0
  ;;
*)
  print_usage
  exit
  ;;
esac


# create slapd.conf
$RUBY -p -e "gsub(/%LDAPSCHEMADIR%/, \"$LDAPSCHEMADIR\")" < $LDAPCONFIN > $LDAPCONF

error(){
  echo $@ 1>&2
}

runruby(){
  echo "-- $RUBY $1 $PORT $SSLPORT --" >> $LOGFILE
  $RUBY $1 $PORT $SSLPORT 1>> $LOGFILE 2>> $LOGFILE
}


if [ `basename $PWD` = "test" ]; then
  error "run in the parent directory"
  exit
fi

# initialize DB
rm -rf $DBDIR
mkdir $DBDIR

# start slapd
rm -f $LOGFILE
rm -f $SERVERLOG

eval $LDAPDCMD 1>> $SERVERLOG 2>> $SERVERLOG &
echo $LDAPDCMD

while [ ! -f "$PIDFILE" ]; do
  echo "waiting for ldapd"
  sleep 1
done


if [ -f "$LOGFILE" ]; then
  rm $LOGFILE
fi

RESULT=ok
for f in $SCRIPTS
do
  printf "running $f .... "
  if runruby $f; then
    echo "succeed"
  else
    echo "fail"
    RESULT=error
  fi
done

# $LDAPSEARCH -b "o=JAIST, c=JP" -h localhost -p $SSLPORT -Z "(objectclass=*)"

# stop slapd
kill -TERM `cat $PIDFILE`
rm -rf $DBDIR
