package de.intarsys.tools.geometry;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.RectangularShape;

public class ShapeTools {

	/**
	 * Returns the shapes fill style winding rule.
	 * 
	 * @return an integer representing the shapes winding rule.
	 * @see #WIND_EVEN_ODD
	 * @see #WIND_NON_ZERO
	 * @see #setWindingRule
	 */
	static public int getWindingRule(Shape shape) {
		if (shape instanceof IShapeWrapper) {
			return getWindingRule(((IShapeWrapper) shape).getBaseShape());
		}
		if (shape instanceof GeneralPath) {
			return ((GeneralPath) shape).getWindingRule();
		}
		if (shape instanceof RectangularShape) {
			return PathIterator.WIND_NON_ZERO;
		}
		if (shape instanceof Area) {
			return PathIterator.WIND_NON_ZERO;
		}
		return shape.getPathIterator(null).getWindingRule();
	}
}
