package org.pietschy.command;

import javax.swing.*;

/**
 * Icon factories are used by the command manager to create icons whenever the
 * icon type is specified as <code>icon-factory</code>.  By implementing
 * this interface you can get complete control over how icons are loaded from the
 * face configuration elements.
 * <p>
 * For example, a icon configuration of
 * <pre>   &lt;icon type="icon-factory"&gt;abcd&lt;icon&gt;</pre>
 * will result in a call to {@link #createIcon(String)} where the parameter
 * value is <code>abcd</code>.
 * <p>
 * The factory must be configured in the {@link CommandManager} prior to any
 * configuration file being loaded.
 *
 * @see CommandManager#setIconFactory(IconFactory)
 * @see AbstractReflectionIconFactory
 */
public interface
IconFactory
{
   /**
    * Creates a new icon based on the specified parameter string.
    *
    * @param parameters the icon text as specified by the configuration file.
    * @return an Icon instance based on the specified parameters.
    * @throws Exception if the there was an error creating the icon.
    */
   public Icon createIcon(String parameters)
   throws Exception;
}
