/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DefaultGroupMemberFactory.java,v 1.2 2005/06/15 23:42:58 pietschy Exp $
 */
package org.pietschy.command;

/**
 * @author andrewp
 * @version $Revision: 1.2 $
 */
public class
DefaultGroupMemberFactory
implements GroupMemberFactory
{
   public GroupMember
   createGlueMember()
   {
      return new GlueMember();
   }

   public GroupMember
   createSeparatorMember()
   {
      return new SeparatorMember();
   }

   public GroupMember
   createSimpleMember(CommandGroup parent, Command command)
   {
      return new SimpleMember(parent, command);
   }

   public GroupMember
   createLazyMember(CommandGroup parent, String commandId, boolean inline)
   {
      return new LazyMember(parent, commandId, inline);
   }

   public GroupMember
   createInlineMember(CommandGroup parent, CommandGroup inlineGroup)
   {
      return new InlineMember(parent, inlineGroup);
   }

   public ExpansionGroupMember
   createExpansionMember(String name)
   {
      return new ExpansionMember(name);
   }

   /**
    * Factory method for creating {@link GroupContainerManager} instances.  Subclasses can override this to
    * customize their container management strategies.
    *
    * @return a {@link GroupContainerManager} instance for this group.
    * @see CommandManager#setGroupFactory(GroupFactory)
    */
   public GroupContainerManager
   createContainerManager()
   {
      return new DefaultGroupContainerManager();
   }

}
