#line 41 "../noweb/s_clib.nw"
/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


#line 24 "../noweb/s_clib.nw"
/* DO NOT read or edit this file ! Use ../noweb/s_clib.nw instead */

#line 64 "../noweb/s_clib.nw"
#include <config.h>

#include <glib.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>
#endif

#include "defines.h"


void s_clib_free(void);

#line 85 "../noweb/s_clib.nw"
static GSList *clib_directories = NULL;

static GHashTable *clib_cache = NULL;


#line 101 "../noweb/s_clib.nw"
void s_clib_init(void)
{
  if (clib_directories != NULL || clib_cache != NULL) {
    s_clib_free();
  }

  clib_cache = g_hash_table_new(g_str_hash, g_str_equal);

}

#line 122 "../noweb/s_clib.nw"
static void
clib_free_cache_entry(gpointer key, gpointer value, gpointer user_data)
{
  g_free(key);
  if (value != NULL) {
    /* value is a singly-linked list of strings */
    g_slist_foreach(value, (GFunc) g_free, NULL);
    g_slist_free((GSList *) value);
  }
}

void s_clib_free(void)
{
  if (clib_directories != NULL) {
    g_slist_foreach(clib_directories, (GFunc) g_free, NULL);
    g_slist_free(clib_directories);
    clib_directories = NULL;
  }

  if (clib_cache != NULL) {
    g_hash_table_foreach(clib_cache, clib_free_cache_entry, NULL);
    g_hash_table_destroy(clib_cache);
    clib_cache = NULL;
  }

}


#line 161 "../noweb/s_clib.nw"
void s_clib_add_directory(const gchar * directory)
{
  /* search for directory in clib_directories */
  if (!g_slist_find_custom(clib_directories,
			   directory, (GCompareFunc) g_strcasecmp)) {
    /* directory not yet in the list of known directories */
    /* add directory to list */
    clib_directories = g_slist_append(clib_directories,
				      g_strdup(directory));
  }

}

#line 189 "../noweb/s_clib.nw"
const GSList *s_clib_get_directories()
{
  return clib_directories;
}

#line 205 "../noweb/s_clib.nw"
GSList *s_clib_get_files(const gchar * directory, const gchar * filter)
{
  GDir *dir;
  const gchar *entry;
  GSList *ret = NULL;

  /* check directory is in clib_directories */
  if (g_slist_find_custom(clib_directories,
			  directory,
			  (GCompareFunc) g_strcasecmp) == NULL) {
    /* no, unknown directory: report an error */
    s_log_message("Directory [%s] is not part of the component library\n",
		  directory);
    return NULL;
  }

  /* open the directory */
  dir = g_dir_open(directory, 0, NULL);
  if (dir == NULL) {
    s_log_message("Failed to open directory [%s]\n", directory);
    return NULL;
  }

  /* now read the entire directory */
  /* and build a list of filenames in directory that match filter */
  while ((entry = g_dir_read_name(dir)) != NULL) {
    /* skip .'s */
    if (entry[0] == '.') {
      continue;
    }

    /* identify filter-matching filenames */
    if (strstr(entry, filter)) {
      ret = g_slist_append(ret, (gpointer) g_strdup(entry));
    }

  }

  /* finished: close the directory stream */
  g_dir_close(dir);

  /* sort the list alphabetically */
  ret = g_slist_sort(ret, (GCompareFunc) g_strcasecmp);

  /* and return the sorted list of filenames */
  return ret;
}

#line 269 "../noweb/s_clib.nw"
const GSList *s_clib_search_basename(const gchar * basename)
{
  GSList *ret, *tmp;

  /* first check if basename is in cache */
  ret = g_hash_table_lookup(clib_cache, basename);
  if (ret != NULL) {
    /* yes, found basename in cache, nothing more to do */
    return ret;
  }

  /* looks like we have to search for basename in the library */
  for (tmp = clib_directories; tmp != NULL; tmp = g_slist_next(tmp)) {
    gchar *dir_name = (gchar *) tmp->data;
    gchar *file_name = g_strconcat(dir_name,
				   G_DIR_SEPARATOR_S,
				   basename,
				   NULL);

    if (g_file_test(file_name, G_FILE_TEST_EXISTS)) {
      /* add directory name to the list */
      ret = g_slist_append(ret, g_strdup(dir_name));
    }

    g_free(file_name);
  }

  /* have we found something? */
  if (ret != NULL) {
    /* yes, add the result to cache */
    g_hash_table_insert(clib_cache, g_strdup(basename), ret);
  }

  return ret;
}
