/* vfs-impl-gio.c generated by valac, the Vala compiler
 * generated from vfs-impl-gio.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS implementation (with GIO).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION (desktop_agnostic_vfs_gio_implementation_get_type ())
#define DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION, DesktopAgnosticVFSGIOImplementation))
#define DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION, DesktopAgnosticVFSGIOImplementationClass))
#define DESKTOP_AGNOSTIC_VFS_IS_GIO_IMPLEMENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_IS_GIO_IMPLEMENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION))
#define DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION, DesktopAgnosticVFSGIOImplementationClass))

typedef struct _DesktopAgnosticVFSGIOImplementation DesktopAgnosticVFSGIOImplementation;
typedef struct _DesktopAgnosticVFSGIOImplementationClass DesktopAgnosticVFSGIOImplementationClass;
typedef struct _DesktopAgnosticVFSGIOImplementationPrivate DesktopAgnosticVFSGIOImplementationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO (desktop_agnostic_vfs_volume_monitor_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIOClass))

typedef struct _DesktopAgnosticVFSVolumeMonitorGIO DesktopAgnosticVFSVolumeMonitorGIO;
typedef struct _DesktopAgnosticVFSVolumeMonitorGIOClass DesktopAgnosticVFSVolumeMonitorGIOClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO (desktop_agnostic_vfs_file_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOClass))

typedef struct _DesktopAgnosticVFSFileGIO DesktopAgnosticVFSFileGIO;
typedef struct _DesktopAgnosticVFSFileGIOClass DesktopAgnosticVFSFileGIOClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO (desktop_agnostic_vfs_file_monitor_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOClass))

typedef struct _DesktopAgnosticVFSFileMonitorGIO DesktopAgnosticVFSFileMonitorGIO;
typedef struct _DesktopAgnosticVFSFileMonitorGIOClass DesktopAgnosticVFSFileMonitorGIOClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO (desktop_agnostic_vfs_trash_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIO))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_TRASH_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO))
#define DESKTOP_AGNOSTIC_VFS_TRASH_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO, DesktopAgnosticVFSTrashGIOClass))

typedef struct _DesktopAgnosticVFSTrashGIO DesktopAgnosticVFSTrashGIO;
typedef struct _DesktopAgnosticVFSTrashGIOClass DesktopAgnosticVFSTrashGIOClass;

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO (desktop_agnostic_vfs_volume_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIOClass))

typedef struct _DesktopAgnosticVFSVolumeGIO DesktopAgnosticVFSVolumeGIO;
typedef struct _DesktopAgnosticVFSVolumeGIOClass DesktopAgnosticVFSVolumeGIOClass;

struct _DesktopAgnosticVFSGIOImplementation {
	GObject parent_instance;
	DesktopAgnosticVFSGIOImplementationPrivate * priv;
};

struct _DesktopAgnosticVFSGIOImplementationClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSGIOImplementationPrivate {
	DesktopAgnosticVFSVolumeMonitor* vmonitor;
};


static gpointer desktop_agnostic_vfs_gio_implementation_parent_class = NULL;
static DesktopAgnosticVFSImplementationIface* desktop_agnostic_vfs_gio_implementation_desktop_agnostic_vfs_implementation_parent_iface = NULL;

GType desktop_agnostic_vfs_gio_implementation_get_type (void);
#define DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION, DesktopAgnosticVFSGIOImplementationPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_NAME,
	DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_FILE_TYPE,
	DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_FILE_MONITOR_TYPE,
	DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_TRASH_TYPE,
	DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_VOLUME_TYPE
};
static void desktop_agnostic_vfs_gio_implementation_real_init (DesktopAgnosticVFSImplementation* base);
static void _g_slist_free_g_object_unref (GSList* self);
static GSList* desktop_agnostic_vfs_gio_implementation_real_files_from_uri_list (DesktopAgnosticVFSImplementation* base, const char* uri_list, GError** error);
DesktopAgnosticVFSVolumeMonitorGIO* desktop_agnostic_vfs_volume_monitor_gio_new (void);
DesktopAgnosticVFSVolumeMonitorGIO* desktop_agnostic_vfs_volume_monitor_gio_construct (GType object_type);
GType desktop_agnostic_vfs_volume_monitor_gio_get_type (void);
static DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_gio_implementation_real_volume_monitor_get_default (DesktopAgnosticVFSImplementation* base);
static void desktop_agnostic_vfs_gio_implementation_real_shutdown (DesktopAgnosticVFSImplementation* base);
DesktopAgnosticVFSGIOImplementation* desktop_agnostic_vfs_gio_implementation_new (void);
DesktopAgnosticVFSGIOImplementation* desktop_agnostic_vfs_gio_implementation_construct (GType object_type);
GType desktop_agnostic_vfs_file_gio_get_type (void);
GType desktop_agnostic_vfs_file_monitor_gio_get_type (void);
GType desktop_agnostic_vfs_trash_gio_get_type (void);
GType desktop_agnostic_vfs_volume_gio_get_type (void);
static void desktop_agnostic_vfs_gio_implementation_finalize (GObject* obj);
static void desktop_agnostic_vfs_gio_implementation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType register_plugin (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static void desktop_agnostic_vfs_gio_implementation_real_init (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSGIOImplementation * self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static GSList* desktop_agnostic_vfs_gio_implementation_real_files_from_uri_list (DesktopAgnosticVFSImplementation* base, const char* uri_list, GError** error) {
	DesktopAgnosticVFSGIOImplementation * self;
	GSList* result;
	GError * _inner_error_;
	GSList* files;
	char** _tmp1_;
	gint uris_size;
	gint uris_length1;
	char** _tmp0_;
	char** uris;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	g_return_val_if_fail (uri_list != NULL, NULL);
	_inner_error_ = NULL;
	files = NULL;
	uris = (_tmp1_ = _tmp0_ = g_uri_list_extract_uris (uri_list), uris_length1 = _vala_array_length (_tmp0_), uris_size = uris_length1, _tmp1_);
	{
		char** uri_collection;
		int uri_collection_length1;
		int uri_it;
		uri_collection = uris;
		uri_collection_length1 = uris_length1;
		for (uri_it = 0; uri_it < uris_length1; uri_it = uri_it + 1) {
			const char* uri;
			uri = uri_collection[uri_it];
			{
				DesktopAgnosticVFSFile* file;
				DesktopAgnosticVFSFile* _tmp2_;
				file = desktop_agnostic_vfs_file_new_for_uri (uri, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					__g_slist_free_g_object_unref0 (files);
					uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
					return NULL;
				}
				files = g_slist_append (files, (_tmp2_ = file, file = NULL, _tmp2_));
				_g_object_unref0 (file);
			}
		}
	}
	result = files;
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static DesktopAgnosticVFSVolumeMonitor* desktop_agnostic_vfs_gio_implementation_real_volume_monitor_get_default (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSGIOImplementation * self;
	DesktopAgnosticVFSVolumeMonitor* result;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	if (self->priv->vmonitor == NULL) {
		DesktopAgnosticVFSVolumeMonitor* _tmp0_;
		self->priv->vmonitor = (_tmp0_ = (DesktopAgnosticVFSVolumeMonitor*) desktop_agnostic_vfs_volume_monitor_gio_new (), _g_object_unref0 (self->priv->vmonitor), _tmp0_);
	}
	result = self->priv->vmonitor;
	return result;
}


static void desktop_agnostic_vfs_gio_implementation_real_shutdown (DesktopAgnosticVFSImplementation* base) {
	DesktopAgnosticVFSGIOImplementation * self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
}


DesktopAgnosticVFSGIOImplementation* desktop_agnostic_vfs_gio_implementation_construct (GType object_type) {
	DesktopAgnosticVFSGIOImplementation * self;
	self = (DesktopAgnosticVFSGIOImplementation*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSGIOImplementation* desktop_agnostic_vfs_gio_implementation_new (void) {
	return desktop_agnostic_vfs_gio_implementation_construct (DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION);
}


static const char* desktop_agnostic_vfs_gio_implementation_real_get_name (DesktopAgnosticVFSImplementation* base) {
	const char* result;
	DesktopAgnosticVFSGIOImplementation* self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	result = "GIO";
	return result;
}


static GType desktop_agnostic_vfs_gio_implementation_real_get_file_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGIOImplementation* self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO;
	return result;
}


static GType desktop_agnostic_vfs_gio_implementation_real_get_file_monitor_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGIOImplementation* self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO;
	return result;
}


static GType desktop_agnostic_vfs_gio_implementation_real_get_trash_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGIOImplementation* self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_TRASH_GIO;
	return result;
}


static GType desktop_agnostic_vfs_gio_implementation_real_get_volume_type (DesktopAgnosticVFSImplementation* base) {
	GType result;
	DesktopAgnosticVFSGIOImplementation* self;
	self = (DesktopAgnosticVFSGIOImplementation*) base;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO;
	return result;
}


static void desktop_agnostic_vfs_gio_implementation_class_init (DesktopAgnosticVFSGIOImplementationClass * klass) {
	desktop_agnostic_vfs_gio_implementation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSGIOImplementationPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_gio_implementation_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_gio_implementation_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_FILE_TYPE, "file-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_FILE_MONITOR_TYPE, "file-monitor-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_TRASH_TYPE, "trash-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_VOLUME_TYPE, "volume-type");
}


static void desktop_agnostic_vfs_gio_implementation_desktop_agnostic_vfs_implementation_interface_init (DesktopAgnosticVFSImplementationIface * iface) {
	desktop_agnostic_vfs_gio_implementation_desktop_agnostic_vfs_implementation_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = desktop_agnostic_vfs_gio_implementation_real_init;
	iface->files_from_uri_list = desktop_agnostic_vfs_gio_implementation_real_files_from_uri_list;
	iface->volume_monitor_get_default = desktop_agnostic_vfs_gio_implementation_real_volume_monitor_get_default;
	iface->shutdown = desktop_agnostic_vfs_gio_implementation_real_shutdown;
	iface->get_name = desktop_agnostic_vfs_gio_implementation_real_get_name;
	iface->get_file_type = desktop_agnostic_vfs_gio_implementation_real_get_file_type;
	iface->get_file_monitor_type = desktop_agnostic_vfs_gio_implementation_real_get_file_monitor_type;
	iface->get_trash_type = desktop_agnostic_vfs_gio_implementation_real_get_trash_type;
	iface->get_volume_type = desktop_agnostic_vfs_gio_implementation_real_get_volume_type;
}


static void desktop_agnostic_vfs_gio_implementation_instance_init (DesktopAgnosticVFSGIOImplementation * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_gio_implementation_finalize (GObject* obj) {
	DesktopAgnosticVFSGIOImplementation * self;
	self = DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION (obj);
	_g_object_unref0 (self->priv->vmonitor);
	G_OBJECT_CLASS (desktop_agnostic_vfs_gio_implementation_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_gio_implementation_get_type (void) {
	static GType desktop_agnostic_vfs_gio_implementation_type_id = 0;
	if (desktop_agnostic_vfs_gio_implementation_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSGIOImplementationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_gio_implementation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSGIOImplementation), 0, (GInstanceInitFunc) desktop_agnostic_vfs_gio_implementation_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_implementation_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_gio_implementation_desktop_agnostic_vfs_implementation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		desktop_agnostic_vfs_gio_implementation_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSGIOImplementation", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_gio_implementation_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_IMPLEMENTATION, &desktop_agnostic_vfs_implementation_info);
	}
	return desktop_agnostic_vfs_gio_implementation_type_id;
}


static void desktop_agnostic_vfs_gio_implementation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSGIOImplementation * self;
	self = DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_NAME:
		g_value_set_string (value, desktop_agnostic_vfs_implementation_get_name ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_FILE_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_file_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_FILE_MONITOR_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_file_monitor_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_TRASH_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_trash_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_GIO_IMPLEMENTATION_VOLUME_TYPE:
		g_value_set_gtype (value, desktop_agnostic_vfs_implementation_get_volume_type ((DesktopAgnosticVFSImplementation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType register_plugin (void) {
	GType result;
	result = DESKTOP_AGNOSTIC_VFS_TYPE_GIO_IMPLEMENTATION;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




