#include <stdio.h>
#include <ctk/ctk.h>
#include <stdlib.h>

void clicked(CtkWidget* button, gpointer data)
{
	CTK_WINDOW(button);
	ctk_noise("Doink");
}
void enter(CtkWidget* button, gpointer data)
{
	ctk_noise("drip");
}
void leave(CtkWidget* button, gpointer data)
{
	ctk_noise("FingerSnap");
}
void pressed(CtkWidget* button, gpointer data)
{
	ctk_noise("Wooeep");
}
void released(CtkWidget* button, gpointer data)
{
	ctk_noise("Eeeooop");
}

void run_me()
{
	system("/home/terpstra/src/SAS/sat/src/dsat -m dialupmod");
}


CtkSignalFunc
    quit_test(CtkWidget *object, gpointer *data)
{		
	ctk_exit(0);
	
	return NULL;
}

CtkSignalFunc
    close_test(CtkWidget *object, gpointer *data)
{
	CtkWidget *window;
	
	window = CTK_WIDGET(data);

	ctk_widget_destroy(window);
//	ctk_widget_destroy(window);
//	ctk_widget_hide(window);
	
	return NULL;
}

CtkSignalFunc
    help_test(CtkWidget *object, gpointer *data)
{
	CtkWidget *window;
	CtkWidget *vbox;
	CtkWidget *hbox;
	CtkWidget *button;
	CtkWidget *entry;

	/* Window */
	window = ctk_window_new(CTK_WINDOW_TOPLEVEL);
	ctk_widget_set_usize(window,10,7);
	ctk_widget_set_uposition(window, 10,20);
	ctk_window_set_title(CTK_WINDOW(window),"Help Window");
	ctk_window_set_modal(CTK_WINDOW(window),TRUE);
	ctk_widget_show(window);

	ctk_signal_connect(CTK_OBJECT(window),"destroy",CTK_SIGNAL_FUNC(quit_test),NULL);
			
	/* V BOX */
	vbox = ctk_hbox_new(FALSE,1);
	ctk_widget_show(vbox);
	ctk_container_add(CTK_CONTAINER(window),vbox);

	/* Button */
	button = ctk_button_new_with_label("Okay");
	ctk_widget_show(button);
	ctk_container_set_border_width(CTK_CONTAINER(button),2);
	ctk_box_pack_start(CTK_BOX(vbox),button,FALSE,TRUE,0);
	
	ctk_signal_connect(CTK_OBJECT(button), "clicked",
		CTK_SIGNAL_FUNC(&run_me), NULL);

	/* Button */
	button = ctk_button_new_with_label("Quit");
	ctk_widget_show(button);
	ctk_container_set_border_width(CTK_CONTAINER(button),5);
	ctk_box_pack_start(CTK_BOX(vbox),button,TRUE,FALSE,0);
	ctk_signal_connect(CTK_OBJECT(button),"clicked",CTK_SIGNAL_FUNC(close_test),window);
	
	hbox = ctk_hbox_new(FALSE, 0);
	ctk_widget_show(hbox);
	ctk_box_pack_start(CTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	
	entry = ctk_combo_new();
	ctk_widget_show(entry);
	ctk_box_pack_start(CTK_BOX(hbox), entry, TRUE, TRUE, 0);

	return NULL;
}

CtkSignalFunc
    clist_test(CtkWidget *widget, gint row, gint col, gpointer event, gpointer data)
{
	gchar *text = NULL;
	gchar *real_text = NULL;
	gchar *chng_text = NULL;

	
	ctk_clist_get_text(CTK_CLIST(widget),row,col,&text);
	real_text = g_strdup(text);
	ctk_clist_freeze(CTK_CLIST(widget));
	ctk_clist_set_text(CTK_CLIST(widget),row,col,"Cool!");

	ctk_clist_get_text(CTK_CLIST(widget),row,col,&chng_text);

	ctk_close();
	printf("R: %d\n",row);
	printf("C: %d\n",col);
	printf("Real Text: %s\n",real_text);
	printf("Chng Text: %s\n",chng_text);
	exit(0);
}

CtkSignalFunc
    get_entry(CtkWidget *entry)
{
	gchar *text=NULL;
	
	//text = ctk_editable_get_chars(CTK_EDITABLE(entry),0,-1);
	text = ctk_entry_get_text(CTK_ENTRY(entry));
	
	ctk_close();
	printf("Text: *%s*\n",text);
	if (text)
	    g_free(text);
	exit(0);
}

int
main(void)
{
	CtkWidget *window;
	CtkWidget *vbox;
	CtkWidget *button;

	ctk_init(CTK_USEMOUSE);

	/* Window */
	window = ctk_window_new(CTK_WINDOW_TOPLEVEL);
	ctk_widget_set_usize(window,1,1);
	ctk_widget_set_uposition(window, 1,1);
	ctk_window_set_title(CTK_WINDOW(window),"Test Window 1");
	ctk_widget_show(window);

	ctk_signal_connect(CTK_OBJECT(window),"destroy",CTK_SIGNAL_FUNC(quit_test),NULL);
			
	/* V BOX */
	vbox = ctk_vbox_new(FALSE,1);
	ctk_widget_show(vbox);
	ctk_container_add(CTK_CONTAINER(window),vbox);

	/* Button */
	button = ctk_button_new_with_label("Okay");
	ctk_widget_show(button);
	ctk_container_set_border_width(CTK_CONTAINER(button),2);
	ctk_box_pack_start(CTK_BOX(vbox),button,FALSE,TRUE,0);

	/* Button */
//	button = ctk_button_new_with_label("Help");
	button = ctk_button_new();
	ctk_widget_show(button);
	ctk_container_set_border_width(CTK_CONTAINER(button),5);
	ctk_box_pack_start(CTK_BOX(vbox),button,TRUE,FALSE,0);
	ctk_signal_connect(CTK_OBJECT(button),"clicked",CTK_SIGNAL_FUNC(help_test),NULL);

	ctk_signal_connect(CTK_OBJECT(button), "clicked",
						CTK_SIGNAL_FUNC(&clicked), NULL);
	ctk_signal_connect(CTK_OBJECT(button), "enter",
						CTK_SIGNAL_FUNC(&enter), NULL);
	ctk_signal_connect(CTK_OBJECT(button), "leave",
						CTK_SIGNAL_FUNC(&leave), NULL);
	ctk_signal_connect(CTK_OBJECT(button), "pressed",
						CTK_SIGNAL_FUNC(&pressed), NULL);
	ctk_signal_connect(CTK_OBJECT(button), "released",
						CTK_SIGNAL_FUNC(&released), NULL);

	ctk_main();

	ctk_close();

	return 0;
}
