/***************************************************************************
  $RCSfile: ctdatacache.h,v $
                             -------------------
    cvs         : $Id: ctdatacache.h,v 1.2 2003/01/10 20:02:12 aquamaniac Exp $
    begin       : Thu Apr 25 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@libchipcard.de


 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */


#ifndef CTDATACACHE_H
#define CTDATACACHE_H

template <int SIZE, int GRANULARITY> class CHIPCARD_API CTDataCache;

#include <bitset>
#include <string>
using namespace std;


/**
 * This class supports caching of data blocks. It stores information
 * about which blocks are valid/dirty and the data itself.
 * @ingroup misc
 */
template <int SIZE, int GRANULARITY> class CHIPCARD_API CTDataCache {
private:
    bitset<SIZE/GRANULARITY> _valid;
    bitset<SIZE/GRANULARITY> _dirty;
    char _data[SIZE];
public:
    CTDataCache(){ _valid.reset(); _dirty.reset();};
    ~CTDataCache(){
#if DEBUGMODE>0
        fprintf(stderr,"~DataCache\n");
#endif
    };

    bool isValid(unsigned int block){return _valid.test(block);};
    bool isDirty(unsigned int block){ return _dirty.test(block);};
    unsigned int granularity(){ return GRANULARITY;};
    unsigned int size() { return SIZE;};
    void setAllValid() { _valid.set();};
    void setNoneValid() { _valid.reset();};
    void setAllDirty() { _dirty.set();};
    void setNoneDirty() { _dirty.reset();};
    void setData(const string &d, unsigned int pos) {
        memmove(_data+pos,
                d.data(),
                d.length());};
    string data(unsigned int pos, unsigned int s){
        return string(_data+pos,s);};

    void setValid(unsigned int block) { _valid.set(block);};
    void setInvalid(unsigned int block) { _valid.reset(block);};
    void setDirty(unsigned int block) { _dirty.set(block);};
    void setClean(unsigned int block) { _dirty.reset(block);};
};


#endif



