/* 
**  mod_mp3.c
*/ 

#include "mod_mp3.h"
#include "shout.h"

MP3_EXPORT(void) send_shout_headers(request_rec *r, mp3_conf* cfg, request_data *request) {
#ifdef DEBUG
	printf("Doing Shout\n");
#endif
	ap_rprintf(r, "ICY 200 OK");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-notice1:<BR>This stream requires a shoutcast compatible player.<BR>");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-notice2:mod_mp3<BR>");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-name:%s", cfg->cast_name);
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-genre:%s", cfg->genre_name);
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-url:%s", request->url);
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-irc:");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-icq:");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-aim:");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-pub:1");
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-br:%d", BITRATE);
	ap_rputs(MP3_CRLF,r);
	ap_rprintf(r, "icy-metaint:%d", METADATA_INTERVAL); 
	ap_rputs(MP3_CRLF,r);
	/* This is breaking recent xmms
	if(!mp3_match(ap_table_get(r->headers_in, "user-agent"), "*mozilla*")){
		ap_rprintf(r, "Content-type:%s%s", cfg->content_type, MP3_CRLF);
	}
	*/
	ap_rputs(MP3_CRLF,r);
}

/* This is where it gets interesting */
MP3_EXPORT(int) shout_write(request_rec *r, unsigned char c, const char *title, const char *artist, const char *url, int *flag) {
	static unsigned char buffer[METADATA_INTERVAL];
	int length = 0;
	int sent = 0;

	if(r->sent_bodyct == METADATA_INTERVAL) {
		if((sent =  ap_bwrite(r->connection->client, buffer, METADATA_INTERVAL)) == -1) 
			return -1;
#ifdef DEBUG
		printf("Sent %d(%d) Flag %d\n", sent, METADATA_INTERVAL, *flag);
#endif
		/* This number is how often we resent the shout message in the mp3 */
		if(((*flag) % 2) && title) {
			memset(buffer, 0, sizeof(unsigned char) * METADATA_INTERVAL);
			if(artist) {
				sprintf(&buffer[1], "StreamTitle='%s - %s';StreamUrl='%s';%c", title, artist, url, '\0');
			} else {
				sprintf(&buffer[1], "StreamTitle='%s';StreamUrl='%s';%c", title, url, '\0');
			}
			length = (1 + ((strlen ((char *) &buffer[1]) + 1) / 16)) * 16;
			buffer[0] = (unsigned char) (length / 16);
			if((sent =  ap_bwrite(r->connection->client, buffer, ((buffer[0] * 16) + 1))) == -1) 
				return -1;
#ifdef DEBUG
		printf("Sent %d(%d) Data (%.22s)\n", sent, ((buffer[0] * 16) + 1), &buffer[1]);
		printf("Sent %d(%d) Data (%s)\n", sent, ((buffer[0] * 16) + 1), &buffer[1]);
#endif
			memset(buffer, 0, sizeof(unsigned char) * METADATA_INTERVAL);
		} else {
			ap_rputc('\0', r);
		}
		++*flag;

		r->sent_bodyct = 0;
	}

	if(r->sent_bodyct == 0) {
		memset(&buffer, 0, METADATA_INTERVAL);
	}

	buffer[r->sent_bodyct] = c;
	r->sent_bodyct++;

	return sent;
}
