-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          29 Feb 2000 give the window a default size of 100x100 (size is not
--                      fixed, but changeable with the aid of a window manager)
--
-------------------------------------------------------------------------------

with X_Lib.Tasking,
     X_Toolkit,
     Xm_Widgets.Primitive.Arrow_Button,
     Xm_Widgets.Primitive.Label,
     Xm_Widgets.Manager.Frame,
     Rotate_Arrow_Global;
use  X_Toolkit,
     Xm_Widgets,
     Xm_Widgets.Primitive.Arrow_Button,
     Xm_Widgets.Primitive.Label,
     Xm_Widgets.Manager.Frame,
     Rotate_Arrow_Global;
procedure Rotate_Arrow is

begin
   X_Lib.Tasking.Resource.Seize;
   Xt_App_Initialize (Appshell, App_Con, "Rotate_Arrow");
   
   The_Frame  := Xm_Create_Frame (Appshell, "frame");
   Xt_Manage_Child (The_Frame);

   The_Button := Xm_Create_Arrow_Button (The_Frame, "arrow");
   Xt_Manage_Child (The_Button);

   -- clear the argument list just to be sure
   Argl := Null_Arg_List;
   Append_Set (Argl, Xm_N_Child_Type, Title_Child);
   The_Label := Xm_Create_Label (The_Frame, "title_label", Argl);
   Xt_Manage_Child (The_Label);

   Argl := Null_Arg_List;
   Append_Set (Argl, Xm_N_Arrow_Direction, Dir);
   Append_Set (Argl, Xm_N_Width, X_Lib.Dimension'(100));
   Append_Set (Argl, Xm_N_Height, X_Lib.Dimension'(100));
   Xt_Set_Values (The_Button, Argl);

   The_Title := Xm_String_Create (Arrow_Direction_Type'Image (Dir));
   Argl := Null_Arg_List;
   Append_Set (Argl, Xm_N_Label_String, The_Title);
   Xt_Set_Values (The_Label, Argl);
   Xm_String_Free (The_Title);

   Xt_Add_Callback (The_Button, Xm_N_Activate_Callback, Arrow_Button_CB'Access);

   Xt_Realize_Widget (Appshell);

   Xt_App_Main_Loop (App_Con);

end Rotate_Arrow;
