-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2002 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          20 Jan 2002 H.-F. Vogt: add popup menu as an alternative to the
--                                  menu bar (Popup_Menu, Input_CB, Menu_CB)
--                                  comment out X_Lib.Tasking, because it seems
--                                  not to be necessary
--
-------------------------------------------------------------------------------

with Ada.Numerics.Generic_Elementary_Functions,
     X_Lib,
     X_Toolkit,
     Xm_Widgets;
use  X_Lib,
     X_Toolkit,
     Xm_Widgets;
package Clock_Global is

   type Real is digits 6; -- that's surely enough

   package Real_Functions is
      new Ada.Numerics.Generic_Elementary_Functions (Real);


   Appshell,
   The_Main, The_Menu_Bar, The_Draw : Widget := Null_Widget;
   About_Dialog          : Widget := Null_Widget;
   Popup_Menu            : Widget := Null_Widget;
   App_Con               : Xt_App_Context;

   Display               : X_Lib.Display_Pointer;

   GC_Marks, GC_Sec, GC_Min, GC_Hour, GC_Shadow : GC_Pointer;
   Width, Height         : Dimension;
   Mid_X, Mid_Y,
   Radius                : Real;
   Hour, Minute, Second  : Natural := 0;

   Timer_ID              : X_Toolkit.Interval_ID
                         := X_Toolkit.Null_Interval_ID;
   Argl                  : Arg_List := Null_Arg_List;

   Leave_Program         : exception;


   procedure Redraw_Clock;
   procedure Resize_Clock;


   procedure About_CB (W         : in Widget;
                       Closure   : in Xt_Pointer;
                       Call_Data : in Xt_Pointer);
   pragma Convention (C, About_CB);


   procedure Quit_CB (W         : in Widget;
                      Closure   : in Xt_Pointer;
                      Call_Data : in Xt_Pointer);
   pragma Convention (C, Quit_CB);


   procedure Expose_Clock_CB (W         : in Widget;
                              Closure   : in Xt_Pointer;
                              Call_Data : in Xt_Pointer);
   pragma Convention (C, Expose_Clock_CB);


   procedure Resize_Clock_CB (W         : in Widget;
                              Closure   : in Xt_Pointer;
                              Call_Data : in Xt_Pointer);
   pragma Convention (C, Resize_Clock_CB);


   procedure Input_CB (W         : in Widget;
                       Closure   : in Xt_Pointer;
                       Call_Data : in Xt_Pointer);
   pragma Convention (C, Input_CB);


   procedure Menu_CB (W         : in Widget;
                      Closure	: in Xt_Pointer;
                      Call_Data : in Xt_Pointer);
   pragma Convention (C, Menu_CB);


   procedure Timeout_CB (Client_Data : in     X_Toolkit.Xt_Pointer;
                         ID          : in out X_Toolkit.Interval_ID);
   pragma Convention (C, Timeout_CB);


end Clock_Global;
