/* LOCKVC Version 3.0 (c) 1994, 1995, 1997 by Matthias Straub */
/* Version 4.0.4 (c) 2001 Lawson Whitney */
/* shadow-password option added by Ed Beaumont */
/* PAM option added by Lawson Whitney */
/* integer math derived from a patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */
		

#define CONFIG "/etc/maxlock"  /* change if you don't like the filename */
#define UMODE 0                /* key-mode    */
#define SMODE 1                /* passwd-mode */
#include "lockvc.h"
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <pwd.h>
#include <signal.h>
#include <unistd.h> 
#include <stdlib.h>
#include <sys/wait.h>
#include <errno.h>
#include <math.h>
#include <termio.h>
#include <vga.h>
#include <linux/vt.h>
#include <syslog.h>
#ifdef USE_PAM
#include <security/pam_appl.h>
#else
#include <crypt.h>
#ifdef SHADOW_PASSWD
#include <shadow.h>
#endif
#endif /* USE_PAM */ 

#define gets(b) (begets(b, sizeof(b)))
static int idol;
int stall();
int b;
static uid_t kid;
int secure;
int pal[256*3];
char buff[100];
char key[100];
char rkey[100];
char uName[100];
char rName[100];
struct termios console;
#ifdef SHADOW_PASSWD
struct spwd *sword;
struct spwd *rpword;
struct passwd *rpwork;
char name[32];
#else
struct passwd *rpword;
#endif
struct passwd *pword;
int keymode;
void asuwere() {
	int fd;
	if(b) { fd = open("/dev/tty0", O_RDONLY);
		ioctl(fd, VT_ACTIVATE, b);
		close(fd);}
	return; }		
char * begets(char * b, int n)
{	int el;
	fgets(b, n, stdin);
	el = strlen(b);
	if (el)
	{	if (b[el-1] == 10) b[el-1] = 0;
	}
	return b; 
}	
#ifdef USE_PAM
static char *PAM_password;
static char *PAM_name;
static int PAM_conv (int num_msg,
		     const struct pam_message **msg,
		     struct pam_response **resp,
		     void *appdata_ptr) {
	int replies = 0;
	struct pam_response *reply = NULL;

	reply = malloc(sizeof(struct pam_response)*num_msg);
	if (!reply) return PAM_CONV_ERR;
	#define COPY_STRING(s) (s) ? strdup(s) : NULL

	for (replies = 0; replies < num_msg; replies++) {
		switch (msg[replies]->msg_style) {
		case PAM_PROMPT_ECHO_OFF:
			/* wants password */
			reply[replies].resp_retcode = PAM_SUCCESS;
			reply[replies].resp = COPY_STRING(PAM_password);
			break;
		case PAM_TEXT_INFO:
			/* ignore the informational mesage */
			/* but first clear out any drek left by malloc */
			reply[replies].resp = NULL;
			break;
		case PAM_PROMPT_ECHO_ON:
			/* user name given to PAM already */
			/* fall through */
		default:
			/* unknown or PAM_ERROR_MSG */
			free (reply);
			return PAM_CONV_ERR;
		}
	}
	*resp = reply;
	return PAM_SUCCESS;
}

static struct pam_conv PAM_conversation = {
	&PAM_conv,
	NULL
};
#endif

void isconsole() /* vgalib1.2 */
     {
	struct stat chkbuf;
	int major, minor;
	int fd;
	
	fd = dup(2);
	fstat(fd, &chkbuf);
	major = chkbuf.st_rdev >> 8;
	minor = chkbuf.st_rdev & 0xff;
	
	if (major != 4 || minor >= 64)
	  {
	     printf("Not running in graphics-capable virtual console.\n");
	     exit(-1);
	  }
	close(fd);            
     }
             
void kickout() 
     {
#ifdef LOGOUT_ALL
	char **argh;
	char *titties;
	pid_t dee;
	int t;
#endif /* LOGOUT_ALL */
	vga_setmode(TEXT);
#ifdef LOGOUT_ALL
	freopen("/dev/null", "r", stdin);
	freopen("/dev/null", "w", stdout);
	freopen("/dev/null", "w", stderr);
	argh = malloc(68*sizeof(argh));
	titties = malloc(63*12);
	for (t = 1; t < 64; t++) {
		argh[t+2] = titties;
		sprintf(titties, "/dev/tty%d", t);
		titties +=12;}
	argh[0] = "fuser";
	argh[1] = "-k";
	argh[2] = "-TERM";
	argh[66] = NULL;
	setreuid(0, 0);
	dee = fork();
	if(dee == 0) execve("/sbin/fuser", argh, NULL);
	if (dee != -1) waitpid(dee, NULL, 0);	
	sleep (2);
	asuwere();
	argh[2] = "-KILL";
	execve("/sbin/fuser", argh, NULL);
	exit(0);
#else
	if (kid) {
	asuwere();	
	setuid(kid);
	kill(-1,SIGTERM);
	sleep(2);
	kill(-1,SIGKILL);
	exit(0);  }
#endif /* LOGOUT_ALL */
	return;
     }

void res_term()
     {
	tcsetattr(STDIN_FILENO, TCSANOW, &console);
     }

void invis_term()
     {
	struct termios terminal;
	tcgetattr(STDIN_FILENO, &console);
	terminal=console;
	terminal.c_lflag &= !(ECHO | ECHOCTL);
	terminal.c_lflag |= ICANON;
	terminal.c_oflag |= OPOST;
	tcsetattr(STDIN_FILENO, TCSANOW, &terminal);
	if (b) {printf("\033c");
		fflush(stdout);}
     }


void get_pal()
{
vga_getpalvec(0,256,pal);
}
void res_pal()
{
vga_setpalvec(0,256,pal);
}
	
void authenticate()
	  {
	  int mode;
#ifdef USE_PAM
          int pam_error;
	  int repid;
#endif
	     while (vga_getkey() != 0) {}
	     get_pal();
	     mode=vga_getcurrentmode(); 
	     vga_setmode(TEXT);
	     invis_term();

	     if(keymode==UMODE)
	       {
		  printf("\nEnter key to unlock: ");
		  gets(buff);
		  printf("\n");
		  if(strcmp(buff,key)==0)
		    {
		       memset(buff,0,strlen(buff));
		       memset(key,0,strlen(key));
		       exit(0);
		    }
	       }
	     else 
	       {
		  printf("\n%s's password: ",uName);
		  gets(buff);
		  printf("\n");
#ifdef USE_PAM
		  PAM_password = buff;
		  PAM_name = uName;
		  seteuid(0);     /* for root passwd check */
    for (repid = 0; repid <2; repid++) 
      {
	pam_handle_t *pamh = NULL;
	pam_error = pam_start("lockvc", PAM_name, &PAM_conversation, &pamh);
	if (pam_error == PAM_SUCCESS)
	  {
		pam_error = pam_authenticate(pamh, 0);
		pam_end(pamh, PAM_SUCCESS);
		if (pam_error == PAM_SUCCESS) 
		  {
		     memset(buff,0,strlen(buff));
		     exit(0);	  
	  	  }
	  }	  

	PAM_name = rName;
      }
	seteuid(getuid());
#else /* USE_PAM */
		  		  
		  /* 13 chars should be save enough -> */
		  if((strncmp(key,crypt(buff,key),13)==0)||strncmp(rkey,crypt(buff,rkey),13)==0)
		    {
		       memset(buff,0,strlen(buff));
		       exit(0);
		    }
#endif  /* USE_PAM */
	       }
	     res_term();
	     vga_setmode(mode);
	     res_pal(); 
	  }
void signals()
{
    if (secure) {
	signal(SIGINT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGABRT,SIG_IGN);
    }
}
void vga_it()
{
	isconsole();
	setreuid(0,0);
	vga_init();

	return;
}	
void main(int argc,char **argv)
     {
	int saver, s;
	FILE *config;
	int maxtime = 0, mouse = 0;
	uid_t who;
	who = getuid();
	kid = who;
	secure = 1;
	if (argv[0] [strlen(argv[0]) -1] == 116) secure = 0;

	b = 0;
	s = (argv[0] [strlen(argv[0]) -1] == 115);
	if (s)
	syslog(LOG_INFO,"\n--  Virtual-Console-Locker by M.Straub '97 daemon V%s L.Whitney 2001 --\n", VERSION);
	else
	printf("\n--  Virtual-Console-Locker by M.Straub '97 daemon V%s L.Whitney 2001 --\n", VERSION);
	
	mod_choose(argc,argv,&saver);
	if(((config=fopen(CONFIG,"r"))!=NULL))
	  {
	     fscanf(config,"%i%i%i", &maxtime, &idol, &mouse);
	     if (!(s)&&(maxtime))	printf(  "---          locking-time is limited to %i minutes.		   ---\n",maxtime);
	     maxtime*=60;
	     signal(SIGALRM,kickout);
	     fclose(config);
	  }
	atexit(asuwere);
	if (idol < 1) idol = 5;
	if (s)
	{
#ifndef NODAEMON
	    b = stall(idol, mouse, &who);
		kid = who;
#else	
	    syslog(LOG_ERR,"\nI was configured --disable-daemon - sorry I can't do this.");
	    fprintf(stderr,"OOPS, daemon was --disabled\n");
	    exit(57);
#endif /* NODAEMON */	    	    
	}
#ifndef LOGOUT_ALL
	if (who)
#endif	    
	     alarm(maxtime);
	if(((pword=getpwuid(who))!=NULL) && (strlen(pword->pw_passwd)>0))
	  {
	     keymode=SMODE;
#ifdef USE_PAM
	     strcpy(uName, pword->pw_name);
	     rpword = getpwuid(0);
	     strcpy(rName,rpword->pw_name);
#else	     
#ifdef SHADOW_PASSWD
	     
	     if(seteuid(0) != 0)
	       {
		  if(errno == EPERM)
		    printf("Program not SUIDed - shadow passwords wont work!\n");
		  else
		    printf("ERROR: Type %i returned from seteuid()\n",errno);
		  vga_it();
		  do
		    {
		       printf("\nKey: ");
		       gets(key);
		       printf("\nAgain: ");
		       gets(buff);
		    } while(strcmp(key,buff)!=0);
		  keymode=UMODE;
	       }
	     else	
	       {
		  name[0]='\0';
		  strncpy(name,pword->pw_name, sizeof(char[32]));	
		  if((sword=getspnam(name))==NULL)
		    printf("getspnam() failed!\n");
		  strcpy(uName,sword->sp_namp);
		  strcpy(key,sword->sp_pwdp);
		  rpwork=getpwuid(0);
		  strcpy(rName,rpwork->pw_name);
		  rpword=getspnam(rName);
		  strcpy(rkey,rpword->sp_pwdp);
	       }
#else /* SHADOW_PASSWD */
	     strcpy(uName,pword->pw_name);
	     strcpy(key,pword->pw_passwd);	     
	     rpword=getpwuid(0);
	     strcpy(rkey,rpword->pw_passwd);
	     strcpy(rName,rpword->pw_name);
#endif  /* SHADOW_PASSWD */
#endif  /* PAM too */
	     vga_it();
	  }
	else
	  {
	     vga_it();
	     do
	       {
		  printf("\nKey: ");
		  gets(key);
		  printf("\nAgain: ");
		  gets(buff);
	       } while(strcmp(key,buff)!=0);
	     keymode=UMODE;
	  }
	vga_lockvc();
	signals();	
	mod_start(argc, argv, &saver);
     }
