/***************************************************************************
                          qpskdemodulator.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "qpskdemodulator.h"

// phase wraparound correction table for viterbi decoder
const double AngleTbl1[4] = { M_PI_3_2, 0.0, M_PI/2.0, M_PI};
const double AngleTbl2[4] = { M_PI_3_2, PI2, M_PI/2.0, M_PI};



QPskDemodulator::QPskDemodulator():CPskDemodulator()
{
int i;
	for( i=0; i<21; i++)
		ViterbiDecode( M_PI_3_2);	// init the Viterbi decoder
ave1=0.0;
ave2=0.0;

}
QPskDemodulator::~QPskDemodulator()
{
}
void QPskDemodulator::DecodeSymbol(double_complex newsamp)

{

bool bit;
//unsigned char ch = 0;

char ch =0;
bool GotChar = false;
double angle;


	m_I1 = m_I0;	//form the multi delayed symbol samples
	m_Q1 = m_Q0;
	m_I0 = newsamp.real();
	m_Q0 = newsamp.imag();
// calculates difference angle for QPSK, BPSK, and IQPSK decoding
//create vector whose angle is the difference angle by multiplying the
// current smaple by the complex conjugate of the previous sample.
//swap I and Q axis to keep away from  the +/-Pi discontinuity and
//  add Pi to make make range from 0 to 2Pi.
// 180 deg phase changes center at Pi/4
// 0 deg phase changes center at 3Pi/2
// +90 deg phase changes center at 2Pi or 0
// -90 deg phase changes center at Pi

		angle = M_PI + atan2( (m_I1*m_I0 + m_Q1*m_Q0),
								(m_I1*m_Q0 - m_I0*m_Q1));	 //QPSK or BPSK

	CalcQuality(angle);
	
	bit = ViterbiDecode( angle);
			
	if( (bit==0) && m_LastBitZero )	//if character delimiter
	{
		if(m_BitAcc != 0 )
		{
			m_BitAcc >>= 2;				//get rid of last zero and one
			m_BitAcc &= 0x07FF;
			ch = m_VaricodeDecTbl[m_BitAcc];
			m_BitAcc = 0;
			GotChar = true;
		}
	}
	else
	{
		m_BitAcc <<= 1;
		m_BitAcc |= bit;
		if(bit==0)
			m_LastBitZero = true;
		else
			m_LastBitZero = false;
	}
	if(GotChar && (ch!=0) )
		emit newSymbol(ch);
	if (bit)
		{
		m_OffCount=0;
		if (m_OnCount++ >20)
			emit setFastSquelch(true);

		}
	else
		{
		m_OnCount=0;
		if (m_OffCount++ > 20)
			emit setFastSquelch(false);			
		}	
GotChar = false;

}

///////////////////////////////////////////////////////////////////////
// Soft-decision Viterbi decoder function.
///////////////////////////////////////////////////////////////////////
bool QPskDemodulator::ViterbiDecode( double newangle)
{
double pathdist[32];
double min;
int bitestimates[32];
int ones;
int i;
const double* pAngleTbl;
	min = 1.0e100;		// make sure can find a minimum value
	//alternative soft decision method using angle differences
	{
		if( newangle >= PI2/2 )			//deal with ambiguity at +/- 2PI
			pAngleTbl = AngleTbl2;		// by using two different tables
		else
			pAngleTbl = AngleTbl1;
		for(i = 0; i < 32; i++)		// calculate all possible distances
		{							//lsb of 'i' is newest bit estimate
			pathdist[i] = m_SurvivorStates[i / 2].Pathdistance +
					fabs(newangle - pAngleTbl[ ConvolutionCodeTable[i] ]);
			if(pathdist[i] < min)	// keep track of minimum distance
				min = pathdist[i];
			// shift in newest bit estimates
			bitestimates[i] = ((m_SurvivorStates[i / 2].BitEstimates) << 1) + (i & 1);
		}
	}
	for(i = 0; i < 16; i++)	//compare path lengths with the same end state
							// and keep only the smallest path in m_SurvivorStates[].
	{
		if(pathdist[i] < pathdist[16 + i])
		{
			m_SurvivorStates[i].Pathdistance = pathdist[i] - min;
			m_SurvivorStates[i].BitEstimates = bitestimates[i];
		}
		else
		{
			m_SurvivorStates[i].Pathdistance = pathdist[16 + i] - min;
			m_SurvivorStates[i].BitEstimates = bitestimates[16 + i];
		}
	}
	ones = 0;
	for(i = 0; i < 16; i++)		// find if more ones than zeros at bit 20 position
		ones += (m_SurvivorStates[i].BitEstimates&(1L << 20));
	if( ones == (8L << 20 ) )
		return ( rand() & 0x1000 );	//if a tie then guess
	else
		return(ones > (8L << 20) );	//else return most likely bit value
}

//////////////////////////////////////////////////////////////////////
// Calculate signal quality based on the statistics of the phase
//	difference angle.  The more dispersion of the "0" and "180" degree
//  phase shifts, the worse the signal quality.  This information is used
//  to activate the squelch control.  If 20 consecutive "180" degree shifts
//  occur, the squelch is forced on, and if 20 consecutive "0" degree
//  shifts occur, the squelch is forced off quickly.
//////////////////////////////////////////////////////////////////////

void QPskDemodulator::CalcQuality(  double angle )
{

double temp;

ave2=ave1;
ave1=m_DevAve;
angle = angle - M_PI_2;
if (angle < 0.0)
	angle = angle + PI2;

temp = fmod(angle,M_PI_2);

if (temp > M_PI)
	temp=temp - M_PI;

			m_QFreqError = temp;
			temp = fabs(temp);
			if (temp > M_PI_4)
					temp= M_PI_4;

		m_DevAve =0.47 * ave1 + 0.46 * ave2 + 0.03 *temp;



		temp=100.-250.0*m_DevAve;
		emit setSquelchValue((int)temp);
}
