//////////////////////////////////////////////////////////////////////
// PSKMod.h: interface for the CPSKMod class.
//
//////////////////////////////////////////////////////////////////////
//      PSK31/CW modulator
// Copyright 1999.    Moe Wheatley AE4JY  <ae4jy@mindspring.com>
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//////////////////////////////////////////////////////////////////////
//
// Modified by Volker Schroer, DL1KSV, for use in LinPsk

#ifndef PSKMOD_H
#define PSKMOD_H

#include <qobject.h>
#include "constants.h"
#include "parameter.h"
#include <ctype.h>

#include "ctxdisplay.h"
#include "ctxwindow.h"
#include "cmodulator.h"

extern Parameter settings;

class PSKModulator  : public CModulator
{
   Q_OBJECT
public:
	PSKModulator(int,double,CTxdisplay *);
	virtual ~PSKModulator();
// PSK31 and CW modulator
//	void InitPSKModulator(double freq, CTxdisplay *);
	unsigned int CalcSignal( double* pData , int n);
/** length = CalcSignal (double *pData, int n)
		Reads tx  Buffer and calculates the signal values to be transmitted
		double *pData 	pointer to array for computed signal values
		n								length of array
		length 					number of calculated values , normally n but shorter at end of tx
*/

private:
	QString m_TestString;
	unsigned int m_AmblePtr;
	int m_Preamble[33];
	int m_Postamble[33];

// PSK31 and CW generator variables
	double m_t;
	int m_Ramp;
	double m_RMSConstant;

	double m_PSKSecPerSamp;
	double m_PSKTime;
	double m_PSKPeriodUpdate;
	double m_PSKPhaseInc;
	unsigned short int m_TxShiftReg;
	unsigned short int m_TxCodeWord;
	double* m_pPSKtxI;
	double* m_pPSKtxQ;
	char m_PresentPhase;
	char m_Lastsymb;
	int m_CWState;
	int m_CWtimer;
	bool m_AddEndingZero;
// Window pointer
// CTxdisplay *tx;

// PSK31 and CW modulator private functions
	int GetChar();
	char GetNextBPSKSymbol(void);
	char GetNextQPSKSymbol(void);
	char GetNextCWSymbol(void);
public slots:
signals: // Signals
  /** Tx finished */
//  void finished();
//  void charSend(char);
};

#endif
