/***************************************************************************
                          linpsk.h  -  description
                             -------------------
    begin                : Sat Mar  4 22:29:25 /etc/localtime 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The psk part is based on the work of Moe Wheatley, AE4JY              *
 ***************************************************************************/

#ifndef LINPSK_H
#define LINPSK_H

// include files for QT
#include <qstring.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qsplitter.h>
#include <qfontdialog.h>
#include <qcolordialog.h>

// application specific includes
#include "linpskview.h"

#include "resource.h"
#include "setup.h"
#include "editmacro.h"
#include "checkcom.h"
#include "crxselect.h"


/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class LinPskView is
  * created which creates your view.
  */
class LinPskApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    LinPskApp();
    /** destructor */
    ~LinPskApp();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();

    /** setup the mainview*/
    void initView();
  
    /** overloaded for Message box on last window exit */

    // Starting with window components


  public slots:
  
    /** switch argument for Statusbar help entries on slot selection */
    void statusCallback(int id_);
    /** open a DemoFile */
    void slotFileOpen();
    /** exits the application */
    void slotFileQuit();

		/** DemoMode */
		void slotSetup();
		void sloteditMacros();
		void slotsaveSettings();
		
  
    /** shows an about dlg*/
    void slotHelpAbout();
  
    /** change the status message of the whole statusbar temporary */
    void slotStatusHelpMsg(const QString &text);
	  void restoreStatusLine();
  /** Setting up the different Fonts  for the windows */
  void slotFontSetup(void);
  /** Selecting RX/TX fonts */
  void slotRxFontSetup();
  void slotTxFontSetup();
  /** Setup the four different window Colors */
  void slotColorSetup();
  /** Select Color for Window 1-4 */
  void RxWindowColor0();
  void RxWindowColor1();
  void RxWindowColor2();
  void RxWindowColor3();

protected:
	void RxWindowColor(int);
signals:
void ButtonNameChanged();
  
  private:

    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    LinPskView *view;

    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
   /** Menu contains the Settings */
	  QPopupMenu *settingsMenu;
   /** Menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
   /** String for saving Statusmessage, to avoid problems with statusbar()->message function
   			in qt 2.2.0 */
 	QString SaveText;
 	QTimer *statusTime;
};
#endif 

