/***************************************************************************
                          crxwindow.h  -  description
                             -------------------
    begin                : Sat Mar 4 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef CRXWINDOW_H
#define CRXWINDOW_H

#include <qmultilineedit.h>
#include "parameter.h"

	#include <qfile.h>
	#include <qdatastream.h>

extern Parameter settings;

/**Textwindow for RX
  *@author Volker Schroer
  */

class CRxwindow : public QMultiLineEdit
 {
   Q_OBJECT
public: 
	CRxwindow(QWidget *parent=0, const char *name=0);
	void setMaxLine(int count=0);
	void setMaxVisible(int count=0);

	~CRxwindow();
	void setDebugFile(QString FileName);
private:
	int maxline;
//	int visible;
	int akt_line;
	int akt_col;
  /** Text to be triggered on */
  QString Trigger;
  /** Received Text */
  QString RxString;
  /** Status of Trigger (on/off) */
  bool TriggerOn;
	void mouseDoubleClickEvent(QMouseEvent *m);
  /** Updates and compares the Triggerstring */
  void updateTrigger(char);
	/** QSO Recording*/
	bool DebugOn;
	QFile *DebugFile;
	QDataStream FileOutput;

public slots:	
	/** RX- Fenster updaten */
	void updaterx( char);		
  /** activates/deactivates the Trigger */
  void setTriggerMode(bool);
  /** Set s the Triggercondition */
  void setTrigger(QString );
  /** Clears the contents of the window and initializes the pointers */
  void clearRxWindow();

signals:
	void theircallChanged(const QString &);
  /** This signal will be emitted if the trigger text is found in the input */
  void triggered();
	
};

#endif
