/***************************************************************************
                          cdisplay.h  -  description
                             -------------------
    begin                : Mon Mar 6 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef CDISPLAY_H
#define CDISPLAY_H

#include <qframe.h>
#include <qcolor.h>
#include <qpainter.h>
#include <complex.h>
#include <qpixmap.h>
#include <qfontmetrics.h>
#include "parameter.h"

#include "color.h"
// Not good programming style, but hope it works

#define SPECTRUM 0
#define WATERFALL 1
#define INPUT 2
#define SYNC 3

/**Class for displaying the different Types
of the input data like spectrum, waterfall
  *@author Volker Schroer
  */

#include "fft.h"

extern Parameter settings;

class CDisplay : public QFrame  {
 Q_OBJECT
public: 
	CDisplay(QWidget *parent,  const char *name=0 );
	~CDisplay();
  /** Painter for CDisplay Class */
  void paintEvent(QPaintEvent *);
	void mousePressEvent(QMouseEvent *);

  /** Calculate Coordinate - Translation */
	void translate();
  /** Calculates the IMD Value of the Signal */
  float calcIMD();
  /** Pointer to inputdata for plotting */
	void setMode(Mode);

    double *inputdata;

int akttab;
/**Minium Frequency of FFT Display */
int minfreq;

/** Maximum Frequency of FFT Display */
int maxfreq;


  /** Results of FFT */
///  int fftdata[820];
  int fftdata[940];
///	int xtranslate[820];
	int xtranslate[940];
  /**  */
  Cfft fft;
  int m_SyncHist[21];
  /** IQ Vector for displaying phase of signal */
  float_complex vector[230];
private:
  /**Smoothing Type*/
	bool slow;
  int from;
  int to;
  unsigned
int rxfrequency[4];  // Rxfrequencies of the different RX- Windows
	// Modus of TX/RX operation
	Mode modus;
public slots:
void selecttab(int);

void scaleminfreq(int);
void scalemaxfreq(int);
void filtertype(bool);

/** Slot stores phase values if int >= 0 (Pskdemodultion)
    if int < 0 Phase display will be disabled (FSK demodulation ) */
void newPhaseValue(int,float_complex);

void setRxFrequency(int,int);
signals: // Signals
  /** emits this signal if the user changed the cursor 
and with it the desired RX- Frequency */
  void rxFreqChanged(int);
protected: // Protected methods
  /** plots the filtered signal  vector 
to recognize phase of signal */
  void plotVector(QPainter *);
  void plotrawinput();
  void plotspectrum(bool);
//  void PlotSyncData();
	void plotwaterfall(bool);

/** Handling Resizing */
void resizeEvent(QResizeEvent *);

// Coordinates for Vectorplot
int xc; //center of Circle
int yc;

QPixmap *pdisplay;  	// Pixmap for Display for double buffering
QPixmap *pwaterfall;  // Pixmap for Waterfall Display
int xmax,ymax;				// Maximum Plot Coordinates
private: // Private methods
  /** Paints a Lineal in the Spectrum or Waterfall Display */
///  void paintLineal(QPainter *);
 };

#endif
