/***************************************************************************
                          theme.h  -  description
                             -------------------
    begin                : Tue Jan 30 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __THEME_H
#define __THEME_H

/* this is the theme of the engine defining the graphics used for windows */

typedef struct {
    /* dyn list responsible for memory clean up */
    Dyn_List surf_list;
    Dyn_List font_list;
    /* these are just pointers use the dyn lists to clear memory ! */
    /* title window */
    SDL_Surface *title_pic;
    /* parent windows */
    SDL_Surface *lower_bar_back;
    SDL_Surface *upper_bar_back;
    SDL_Surface *parent_back;
    SDL_Surface *edit_back;
    /* buttons */
    SDL_Surface *text_button;
    SDL_Surface *menu_text_button;
    SDL_Surface *accept_button;
    SDL_Surface *cancel_button;
    SDL_Surface *up_button;
    SDL_Surface *down_button;
    SDL_Surface *left_button;
    SDL_Surface *right_button;
    SDL_Surface *menu_button;
    SDL_Surface *end_turn_button;
    SDL_Surface *air_mode_button;
    SDL_Surface *undo_button;
    SDL_Surface *map_button;
    SDL_Surface *embark_button;
    SDL_Surface *supply_button;
    SDL_Surface *rename_button;
    SDL_Surface *scen_info_button;
    SDL_Surface *life_bar_button;
    SDL_Surface *grid_button;
    SDL_Surface *weather_button;
    SDL_Surface *cpu_button;
    SDL_Surface *window_button;
    SDL_Surface *sound_button;
    SDL_Surface *music_button;
    SDL_Surface *deploy_button;
    SDL_Surface *melt_button;
    /* if window is transparent it needs this frame surrounding it */
    SDL_Surface *parent_frame;
    SDL_Surface *list_frame;
    SDL_Surface *edit_frame;
    /* scrollbar stuff */
    SDL_Surface *up_arrow;
    SDL_Surface *down_arrow;
    SDL_Surface *track_ball;
    SDL_Surface *hori_ctrl;
    SDL_Surface *hori_ctrl_button;
    /* fonts */
    Font *stan_font;
    Font *status_font;
    /* unit status icons */
    SDL_Surface *status_icons;
    int status_icon_width, status_icon_height; /* size of icon */
#ifdef WITH_SOUND
    /* sounds */
    Sound_Chunk *click_sound;
    Sound_Chunk *edit_sound;
#endif
} Theme;

/* load a theme */
Theme* load_theme( char *file_name );

/* delete theme */
void delete_theme( Theme *theme );

#endif
