/***************************************************************************
                          ai.h  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __AI_H
#define __AI_H

/*
====================================================================
This is the basic AI interface called by the engine. Auxiliary
functions for the AI are either specified in ai.c as locals or
in ai_tools.c. The engine uses this interface in function
ai_handle() in engine.c
====================================================================
*/

/*
====================================================================
This function initalizes the cpu turn and prepares all nescessarys
steps for ai_get_action().
====================================================================
*/
void ai_init_turn( Engine *engine );
/*
====================================================================
This function cleans up stuff created by ai_init_turn().
====================================================================
*/
void ai_end_turn( Engine *engine );
/*
====================================================================
This is the most important function for the AI. After
ai_init_turn() initiated the AI this function is called by the
engine and returns an AI action which is executed by the engine.
The AI turn ends when AI_END_TURN was returned to the engine.
The unit you currently try to find an action for MUST be stored in
pointer cur_unit as functions in ai_tools.c and ai_action.c
refer to this pointer.
====================================================================
*/
AI_Action ai_get_action( Engine *engine );

#endif
