/***************************************************************************
                          ai.c  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <SDL.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tools.h"
#include "sdl.h"
#include "dynlist.h"
#include "gui.h"
#include "theme.h"
#include "nation.h"
#include "unit.h"
#include "player.h"
#include "date.h"
#include "map.h"
#include "scenario.h"
#include "ai_action.h"
#include "engine_tools.h"
#include "ai_tools.h"
#include "ai.h"

/*
====================================================================
This is the static unit list processed by ai_get_action().
====================================================================
*/
Unit** units = 0;
int unit_count = 0;
Unit *cur_unit = 0;
int cur_unit_id = 0;
/*
====================================================================
AI style is either aggressive AGGR or defensive DEF.
====================================================================
*/
int ai_style;

/*
====================================================================
    LOCALS
====================================================================
*/

/*
====================================================================
Sets next unit as cur_unit. If this fails returns 0 and
ai_get_action() will return an ai_end_turn_action()
====================================================================
*/
int ai_next_unit()
{
    /* if all units were handled end turn by returning 0 */
    if ( cur_unit_id == unit_count )
        return 0;
    /* get next unit */
    cur_unit = units[cur_unit_id++];
#ifdef AI_DEBUG
    printf( "%s:\n", cur_unit->name );
#endif
    return 1;
}

/*
====================================================================
    PUBLIC
====================================================================
*/

/*
====================================================================
This function initalizes the cpu turn and prepares all nescessarys
steps for ai_get_action().
====================================================================
*/
void ai_init_turn( Engine *engine )
{
    /* create static list of own units */
    units = get_player_units( engine, engine->player_id, &unit_count );
#ifdef AI_DEBUG
    printf( "--- AI initiated for '%s' ---\n", engine->player->name );
    printf( "Units counted: %i\n", unit_count );
#endif
    /* begin with first unit */
    cur_unit_id = 0;
    /* set style */
    ai_style = engine->player->cpu_strat;
#ifdef AI_DEBUG
    if ( ai_style == AGGR )
        printf( "AI Style: Aggressive\n" );
    else
        printf( "AI Style: Defensive\n" );
    printf( "---\n");
#endif
}

/*
====================================================================
This function cleans up stuff created by ai_init_turn().
====================================================================
*/
void ai_end_turn( Engine *engine )
{
    /* delete static list */
    FREE( units );
#ifdef AI_DEBUG
    printf( "--- AI turn of '%s' finished ---\n", engine->player->name );
#endif
}

/*
====================================================================
This is the most important function for the AI. After
ai_init_turn() initiated the AI this function is called by the
engine and returns an AI action which is executed by the engine.
The AI turn ends when AI_END_TURN was returned to the engine.
The unit you currently try to find an action for MUST be stored in
pointer cur_unit as functions in ai_tools.c and ai_action.c
refer to this pointer.
====================================================================
*/
AI_Action ai_get_action( Engine *engine )
{
    AI_Action action;

    /* get current unit the ai_... functions in ai_tools.c refer to this pointer (in most cases) */
    if ( !ai_next_unit() ) return ai_end_turn_action();
    /* check if supply needed and perform refuel if possible else go on and see */
    /* if another action may be performed */
    if ( ai_low_ammo() || ai_low_fuel() ) {
        if ( ai_may_supply() )
            return ai_supply_action();
        /* well ok, isn't possible from that position but maybe it's flying and */
        /* an airfield is near by */
        if ( ai_is_flying() && ai_find_airfield( &action ) )
            return action;
    }
    /* if unit is flying scan surrounding for a target and attack */
    if ( ai_is_flying() && ai_find_target( engine, AI_ALLOW_MOVE, &action ) )
        return action;
    /* ok we got a ground unit; don't move just find a target and attack */
    if ( ai_find_target( engine, AI_DENY_MOVE, &action ) )
        return action;
    /* if we got here the unit won't do anything */
    return ai_no_action();
}

