#ifndef __config_h
#define __config_h

/* compile options */
/* HAVE_SYSLOG		compile with syslog() support */
/* HAVE_SETSID		only useful for supervise mode: sets session ID */
/* HAVE_POLL		use poll() instead of select() */
/* HAVE_WAITPID		use waitpid() instead of wait() */
/* HAVE_WAIT4		use wait4() instead of wait() */
/* HAVE_SEMAPHORE	use pthread semaphore instead of our own */

#include "list.h"
#include "ht.h"

struct config_s {
	int handlers;
	int ldap_threads;
	int dns_threads;
	list_t hosts;
	int one2one_mode;

	int accelerate_cache;
	int relative_names;
	int netbios;

	/* the hardcoded $HOSTMASTER environment variable */
	char *hostmaster;

	/* our own nameservers; normally we use nsRecord attribute,
	 * but sometimes, we might want to use this instead...
	 */
	char *self_ns;
	list_t peer_ns;

	char *axfr_base;
	char *notify;
	char *update;

	int auth_mode;
#define AUTH_MODE_ANONYMOUS	0x00
#define AUTH_MODE_SIMPLE	0x01
#define AUTH_MODE_SASL		0x02

	char *ldap_name;
	char *ldap_cred;

	char *ldap_suffix;

	int dn_mode;
#define DN_MODE_COSINE		0x00
#define DN_MODE_RFC1279		0x01
#define DN_MODE_MSDNS		0x02
#define DN_MODE_LDAPDNS		0x03

	int always_hangup;
	long timeout_tcp;

/* switches; row is 8bytes + asciiz string */
	list_t	swm;
/* axfr switch; same format, but string is AXFR field */
	list_t	swaxfr;
/* search switch */
	ht	search;

#define SCHEDULE_A_NONE		0
#define SCHEDULE_A_RANDOM	1
	int schedule_arecord;

/* verious performance tuners */
	int no_additionals;
	int no_additionals_ns;
};


typedef struct config_s config_t;
extern config_t ldapdns;

#endif
