/***************************************************************************
                          help.c  -  description
                             -------------------
    begin                : Sat Dec 15 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "event.h"
#include "config.h"
#include "levels.h"
#include "player.h"
#include "shrapnells.h"
#include "bricks.h"
#ifdef SOUND
#include "audio.h"
#endif

Font *help_caption_font = 0;
Font *help_font = 0;
SDL_Surface *help_bkgnd = 0;
int side_count = 4;

extern Sdl sdl;
extern SDL_Surface *extra_pic;
extern SDL_Surface *brick_pic;

/*
====================================================================
Locals
====================================================================
*/

/*
====================================================================
Draw title.
====================================================================
*/
void draw_title( )
{
	help_caption_font->align = ALIGN_X_CENTER | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, sdl.screen->w / 2, 20, "Quick Help", OPAQUE );
}
/*
====================================================================
Add footnote.
====================================================================
*/
void draw_footnote( int side )
{
	char buf[256];
	help_font->align = ALIGN_X_RIGHT | ALIGN_Y_BOTTOM;
	sprintf( buf, "%i / %i", side, side_count );
	write_text( help_font, sdl.screen, sdl.screen->w - 2, sdl.screen->h - 2, buf, OPAQUE );
	help_font->align = ALIGN_X_LEFT | ALIGN_Y_BOTTOM;
	sprintf( buf, "<ESCAPE>: Quit  <LEFT BUTTON>: Next Page  <RIGHT BUTTON>: Previous Page" );
	write_text( help_font, sdl.screen, 2, sdl.screen->h - 2, buf, OPAQUE );
}

/*
====================================================================
Draw bonus info
====================================================================
*/
void draw_bonus_info( int x, int y, int id, char *text )
{
	DEST( sdl.screen, x, y, BRICK_WIDTH, BRICK_HEIGHT );
	SOURCE( extra_pic, id * BRICK_WIDTH, 0 );
	blit_surf();
	help_font->align = ALIGN_X_LEFT | ALIGN_Y_CENTER;
	write_text( help_font, sdl.screen, x + BRICK_WIDTH + 10, y + BRICK_HEIGHT / 2, text, OPAQUE );
}

/*
====================================================================
Draw brick info
====================================================================
*/
void draw_brick_info( int x, int y, int id, char *text )
{
	DEST( sdl.screen, x, y, BRICK_WIDTH, BRICK_HEIGHT );
	SOURCE( brick_pic, id * BRICK_WIDTH, 0 );
	blit_surf();
	help_font->align = ALIGN_X_LEFT | ALIGN_Y_CENTER;
	write_text( help_font, sdl.screen, x + BRICK_WIDTH + 10, y + BRICK_HEIGHT / 2, text, OPAQUE );
}

/*
====================================================================
Draw bonus info screen.
====================================================================
*/
void draw_bonus_screen()
{
	int bonus_x = 20, bonus_y = 80, bonus_w = 200, bonus_h = 30;
	int malus_x = 20, malus_y = 330, malus_w = 200, malus_h = 30;
	
	FULL_DEST( sdl.screen ); FULL_SOURCE( help_bkgnd ); blit_surf();
	draw_title();
	
	/* bonuses */
	help_caption_font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, bonus_x, bonus_y - 30, "Bonuses:", OPAQUE );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 0, 8,  "Expand paddle" );
	draw_bonus_info( bonus_x + bonus_w * 1, bonus_y + bonus_h * 0, 9,  "Extra life" );
	draw_bonus_info( bonus_x + bonus_w * 2, bonus_y + bonus_h * 0, 10, "Sticky paddle" );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 1, 15, "Plasma weapon" );
	draw_bonus_info( bonus_x + bonus_w * 1, bonus_y + bonus_h * 1, 2,  "200 - 10,000 points extra score" );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 2, 12, "Extra ball" );
	draw_bonus_info( bonus_x + bonus_w * 1, bonus_y + bonus_h * 2, 11, "Energy balls (penetrate bricks)" );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 3, 13, "Bonus floor" );
	draw_bonus_info( bonus_x + bonus_w * 1, bonus_y + bonus_h * 3, 18, "Deccelerate balls to minimum speed" );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 4, 6,  "1,000 points extra score from bricks with no bonus" );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 5, 19, "Instantly collect all bonuses and destroy all maluses" );
	draw_bonus_info( bonus_x + bonus_w * 0, bonus_y + bonus_h * 6, 25, "Explosive balls" );
	draw_bonus_info( bonus_x + bonus_w * 1, bonus_y + bonus_h * 6, 26, "Paddle attracts bonuses" );
    
	/* maluses */
	write_text( help_caption_font, sdl.screen, malus_x, malus_y - 30, "Maluses:", OPAQUE );
	draw_bonus_info( malus_x + malus_w * 0, malus_y + malus_h * 0, 7,  "Shrink paddle" );
	draw_bonus_info( malus_x + malus_w * 0, malus_y + malus_h * 3, 17,  "Accelerate balls" );
	draw_bonus_info( malus_x + malus_w * 0, malus_y + malus_h * 1, 14,  "Freeze paddle" );
	draw_bonus_info( malus_x + malus_w * 1, malus_y + malus_h * 1, 21,  "Random ball reflection at bricks" );
	draw_bonus_info( malus_x + malus_w * 0, malus_y + malus_h * 2, 20,  "Darkness" );
	draw_bonus_info( malus_x + malus_w * 1, malus_y + malus_h * 2, 27,  "Paddle attracts maluses" );
	draw_bonus_info( malus_x + malus_w * 1, malus_y + malus_h * 0, 22,  "Paddle disappears when not moving" );
	draw_bonus_info( malus_x + malus_w * 1, malus_y + malus_h * 3, 28,  "40% chance that a ball doesn't damage brick" );
	
	draw_footnote( 1 );
	
	refresh_screen( 0, 0, 0, 0 );
}
/*
====================================================================
Draw hint
====================================================================
*/
void draw_hint( int x, int y, char *text )
{
	write_text( help_font, sdl.screen, x, y, text, OPAQUE );
}
/*
====================================================================
Draw hints
====================================================================
*/
void draw_hints_screen()
{
	int hint_x = 20, hint_y = 80, hint_h = 20;
	
	FULL_DEST( sdl.screen ); FULL_SOURCE( help_bkgnd ); blit_surf();
	draw_title();

	help_caption_font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, hint_x, hint_y - 40, "Hints:", OPAQUE );
	
	draw_hint( hint_x, hint_y + hint_h * 0, "<<'In Game'-Keys>>" );
	draw_hint( hint_x, hint_y + hint_h * 1, " p    Pause game." );
	draw_hint( hint_x, hint_y + hint_h * 2, " s    Enable/Disable sound." );
	draw_hint( hint_x, hint_y + hint_h * 3, " a    Change animation level (off/low/high)." );
	draw_hint( hint_x, hint_y + hint_h * 4, " f    Switch fullscreen/windowed mode." );
	draw_hint( hint_x, hint_y + hint_h * 5, "      NOTE: Changing resolution takes a while so this is done best" );
	draw_hint( hint_x, hint_y + hint_h * 6, "      when game's paused." );
	draw_hint( hint_x, hint_y + hint_h * 7, " r    Restart level." );
	draw_hint( hint_x, hint_y + hint_h * 8, " TAB  Take a screenshot." );
	draw_hint( hint_x, hint_y + hint_h * 9, " ESC  Quit game." );
	
	draw_footnote( 3 );
	
	refresh_screen( 0, 0, 0, 0 );
}
/*
====================================================================
Draw ingame hints
====================================================================
*/
void draw_ingame_hints_screen() 
{
    int brick_x = 20, brick_y = 210, brick_h = 30;
    int extra_x = 20, extra_y = 80, extra_h = 30;
	
	FULL_DEST( sdl.screen ); FULL_SOURCE( help_bkgnd ); blit_surf();
	draw_title();

	help_caption_font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, extra_x, extra_y - 30, "Neutral Power-Ups:", OPAQUE );

    draw_bonus_info( extra_x, extra_y + extra_h * 0, 16, "Any of the listed bonuses/maluses." );
    draw_bonus_info( extra_x, extra_y + extra_h * 1, 23, "Resets all active bonuses and maluses." );
    draw_bonus_info( extra_x, extra_y + extra_h * 2, 24, "Adds 7 seconds to all active bonuses/maluses." );
    
	help_caption_font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, brick_x, brick_y - 30, "Special Bricks:", OPAQUE );

    draw_brick_info( brick_x, brick_y + brick_h * 0, 0, "Indestructible." );
    draw_brick_info( brick_x, brick_y + brick_h * 1, 1, "May only be destroyed by energy ball else it's indestructible." );
    draw_brick_info( brick_x, brick_y + brick_h * 2, 2, "As above and balls are reflected randomly at this brick." );
    draw_brick_info( brick_x, brick_y + brick_h * 3, 5, "Needs three hits to be destroyed." );
    draw_brick_info( brick_x, brick_y + brick_h * 4, 9, "As above and regenerates durability every 4 seconds." );
    draw_brick_info( brick_x, brick_y + brick_h * 5, 18, "Explodes and destroys all nearby bricks." );
    draw_brick_info( brick_x, brick_y + brick_h * 6, 19, "Creates up to 8 bricks on destruction." );

    draw_footnote( 2 );
	
	refresh_screen( 0, 0, 0, 0 );
}
/*
====================================================================
Draw trouble shooting
====================================================================
*/
void draw_trouble( int x, int y, char *text )
{
	draw_hint( x, y, text );
}
void draw_trouble_screen()
{
	int trouble_x = 20, trouble_y = 90, trouble_h = 20;
	int manual_x = 20, manual_y = 310, manual_h = 20;
	FULL_DEST( sdl.screen ); FULL_SOURCE( help_bkgnd ); blit_surf();
	draw_title();

	help_caption_font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, trouble_x, trouble_y - 40, "Troubleshooting:", OPAQUE );
	
	draw_trouble( trouble_x, trouble_y + trouble_h * 0, "* In fullscreen mode the window keeps it size just adding a black frame?" );
	draw_trouble( trouble_x, trouble_y + trouble_h * 1, "  - Maybe you do not have 640x480 as resolution available? Check your" );
	draw_trouble( trouble_x, trouble_y + trouble_h * 2, "    X configuration." );
	draw_trouble( trouble_x, trouble_y + trouble_h * 3, "* Sounds seem to be out of sync and are played with some delay?" );
	draw_trouble( trouble_x, trouble_y + trouble_h * 4, "  - Set SDL_AUDIODRIVER to dma (export SDL_AUDIODRIVER=dma). If this results" );
	draw_trouble( trouble_x, trouble_y + trouble_h * 5, "    in a lot of errors killing artsd (or esd) may help." );
	draw_trouble( trouble_x, trouble_y + trouble_h * 6, "* LBreakout2 gets mute while playing when switching on/off sounds?" );
	draw_trouble( trouble_x, trouble_y + trouble_h * 7, "  - SDL_mixer seems to mute active channels. You shouldn't enable/disable" );
	draw_trouble( trouble_x, trouble_y + trouble_h * 8, "    sounds to often as you'll propably loose all channels then." );
	
	help_caption_font->align = ALIGN_X_LEFT | ALIGN_Y_TOP;
	write_text( help_caption_font, sdl.screen, manual_x, manual_y - 40, "Manual:", OPAQUE );
	draw_trouble( manual_x, manual_y + manual_h * 0, "This is just a quick help with the most important facts about LBreakout2." );
	draw_trouble( manual_x, manual_y + manual_h * 1, "If you want more and better information check out the manual installed to" );
	draw_trouble( manual_x, manual_y + manual_h * 2, "/usr/doc/lbreakout2 or the online version at http://www.lgames.org." );
	draw_trouble( manual_x, manual_y + manual_h * 3, "And if you have questions (not answered by the manual) or you found a bug" );
	draw_trouble( manual_x, manual_y + manual_h * 4, "or you just want to drop a general note about LBreakout2 just mail to:" );
	draw_trouble( manual_x, manual_y + manual_h * 5, "  kulkanie@gmx.net" );
	draw_trouble( manual_x, manual_y + manual_h * 6, "                         Enjoy the game!" );
	draw_trouble( manual_x, manual_y + manual_h * 6 + 10, "                                                 Michael Speck" );
	
	draw_footnote( 4 );
	
	refresh_screen( 0, 0, 0, 0 );
}

/*
====================================================================
Publics
====================================================================
*/

/*
====================================================================
Load/delete help resources.
====================================================================
*/
void help_create()
{
	SDL_Surface *buffer = 0;
    help_font = load_fixed_font( "f_small_yellow.bmp", 32, 96, 8, SDL_SWSURFACE );
    help_caption_font = load_fixed_font( "f_yellow.bmp", 32, 96, 10, SDL_SWSURFACE );
	/* background */
	buffer = load_surf( "menuback.bmp", SDL_SWSURFACE );
	help_bkgnd = create_surf( buffer->w, buffer->h, SDL_SWSURFACE );
	SDL_SetColorKey( help_bkgnd, 0, 0 );
	FULL_DEST( help_bkgnd ); fill_surf( 0x0 );
	FULL_SOURCE( buffer ); alpha_blit_surf( 192 );
	SDL_FreeSurface( buffer );
}
void help_delete()
{
	free_font( &help_font );
	free_font( &help_caption_font );
	if ( help_bkgnd ) SDL_FreeSurface ( help_bkgnd ); help_bkgnd = 0;
}

/*
====================================================================
Run help.
====================================================================
*/
void help_run()
{
	int leave = 0;
	SDL_Event event;
	int cur_side = 0;
    SDL_Surface *buffer = create_surf(sdl.screen->w, sdl.screen->h, SDL_HWSURFACE);
    
    event_block_motion( 1 );

	/* buffer screen */
	SDL_SetColorKey(buffer, 0, 0);
    FULL_DEST(buffer);
    FULL_SOURCE(sdl.screen);
    blit_surf();
	
	/* display background */
    FULL_DEST(sdl.screen);
    FULL_SOURCE(help_bkgnd);
	blit_surf();
		
	draw_bonus_screen();
	while ( !leave ) {
		SDL_WaitEvent( &event );
		switch ( event.type ) {
			case SDL_KEYUP:
				switch ( event.key.keysym.sym ) {
					case SDLK_ESCAPE: leave = 1; break;
					case SDLK_LEFT:
					case SDLK_RIGHT:
						if ( event.key.keysym.sym == SDLK_RIGHT )  {
							cur_side++;
							if ( cur_side == side_count ) cur_side = 0;
						}	
						else {
							cur_side--;
							if ( cur_side < 0 ) cur_side = side_count - 1;
						}
						switch ( cur_side ) {
							case 0: draw_bonus_screen(); break;
							case 2: draw_hints_screen(); break;
							case 1: draw_ingame_hints_screen(); break;
							case 3: draw_trouble_screen(); break;
						}
						break;
					default: break;
				}
				break;
			case SDL_MOUSEBUTTONUP:
				if ( event.button.button == LEFT_BUTTON )  {
					cur_side++;
					if ( cur_side == side_count ) cur_side = 0;
				}	
				else {
					cur_side--;
					if ( cur_side < 0 ) cur_side = side_count - 1;
				}
				switch ( cur_side ) {
					case 0: draw_bonus_screen(); break;
					case 2: draw_hints_screen(); break;
					case 1: draw_ingame_hints_screen(); break;
					case 3: draw_trouble_screen(); break;
				}
				break;
			default: break;
		}
	}
	
	/* redraw screen */
    FULL_DEST(sdl.screen);
    FULL_SOURCE(buffer);
    blit_surf();
	refresh_screen( 0, 0, 0, 0 );
	SDL_FreeSurface( buffer );
	
    event_block_motion( 0 );
}
