/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Die Nov 12 16:11:02 CET 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "ktray.h"

static const char *description = I18N_NOOP("KWaveControl");

static KCmdLineOptions options[] =
{
  { "device <argument>", "wireless device", 0 },
  KCmdLineLastOption
};
	
int main(int argc, char *argv[])
{
	QString cmd( argv[ 0 ] );

	KAboutData aboutData( "kwavecontrol", "KWavecontrol", VERSION, description, KAboutData::License_GPL, "(c) 2002, Matthias Reif", 0, 0, "matthias.reif@progeln.de");

	aboutData.addAuthor("Matthias Reif",0, "matthias.reif@progeln.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication a;

	KTray *tray = new KTray( cmd );
	a.setMainWidget( tray );

	tray->show();

	return a.exec();
}
