/***************************************************************************
                          kwcentrybar.cpp  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentrybar.h"

KWCEntryBar::KWCEntryBar(const QString & inscr, int row, QWidget *parent, const char *name ) : KWCEntry(inscr, row, parent,name)
{
	valueBar = new KProgress(this);
	valueBar->setGeometry(*rightWidgetRect);
	valueBar->show();

	valueLabel = new QLabel(this);
	valueLabel->setGeometry(*rightWidgetRect);
	valueLabel->hide();

	setValueWidget(valueBar);
	setValue2Widget(valueLabel);
}

KWCEntryBar::~KWCEntryBar(){
}

/** No descriptions */
void KWCEntryBar::setValue(int value)
{
	valueBar->setProgress(value);
}

/** No descriptions */
void KWCEntryBar::setValue(const QString & value)
{
	valueLabel->setText(value);
}
/** No descriptions */
void KWCEntryBar::showBar(bool ok)
{
	if(ok)
	{
		valueLabel->hide();
		valueBar->show();
	}else{
   	valueBar->hide();
    valueLabel->show();
	}
}
