#ifndef _KVI_MESSAGECOLORVIEW_H_INCLUDED_
#define _KVI_MESSAGECOLORVIEW_H_INCLUDED_

// =============================================================================
//
//      --- kvi_messagecolorview.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qgridview.h>

#include "kvi_defines.h"

class QFontMetrics;
class KviPopupMenu;

class KviMessageColorView : public QGridView
{
	Q_OBJECT
public:
	KviMessageColorView(QWidget *);
	~KviMessageColorView();

	void commit();
public slots:
	void forePopupActivated(int);
	void backPopupActivated(int);
	void save();
	void load();
protected:
	KviPopupMenu  *m_pPopup;
	KviPopupMenu  *m_pForePopup;
	KviPopupMenu  *m_pBackPopup;
	unsigned char  m_clrBack[KVI_OUT_NUM_IMAGES + 2];
	QPixmap       *m_pColorPixmap[16];
	int            m_selectedRow;
	QFontMetrics  *m_pFm;
	unsigned char  m_clrFore[KVI_OUT_NUM_IMAGES + 2];

	virtual void paintCell(QPainter *, int row, int col);
	bool eventFilter(QObject *, QEvent *);
	void resizeEvent(QResizeEvent *);
};

#endif // _KVI_MESSAGECOLORVIEW_H_INCLUDED_
