#ifndef _KVI_BIFF_MESSAGE_H_INCLUDED_
#define _KVI_BIFF_MESSAGE_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Authors:
//       Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//       Szymon Stefanek <stefanek@tin.it>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_string.h"

class KviBiffMessage
{
public:
	KviBiffMessage(const char *from, const char *subject, const char *uid);
	~KviBiffMessage();

	const char *const from()    const;
	const char *const subject() const;
	const char *const uid()     const;

private:
	KviStr m_from;
	KviStr m_subject;
	KviStr m_uid;     // Unique message number - given by the server
};

#endif // _KVI_BIFF_MESSAGE_H_INCLUDED_
