// =============================================================================
//
//      --- kvi_optionswidget.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsWidget"

#include <qobjectlist.h>

#include "kvi_colorselector.h"
#include "kvi_fileselector.h"
#include "kvi_fontselector.h"
#include "kvi_imageselector.h"
#include "kvi_ipselector.h"
#include "kvi_optionswidget.h"

KviOptionsWidget::KviOptionsWidget(QWidget *parent, int id)
	: QFrame(parent)
{
	m_id = id;
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
}

KviOptionsWidget::~KviOptionsWidget()
{
	// Nothing here
}

void KviOptionsWidget::commitChanges()
{
	// Nothing here
}

void KviOptionsWidget::commitColorSelectors()
{
	QObjectList *l = queryList("KviColorSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviColorSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviOptionsWidget::commitFileSelectors()
{
	QObjectList *l = queryList("KviFileSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviFileSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviOptionsWidget::commitImageSelectors()
{
	QObjectList *l = queryList("KviImageSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviImageSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviOptionsWidget::commitIpSelectors()
{
	QObjectList *l = queryList("KviIpSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviIpSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviOptionsWidget::commitFontSelectors()
{
	QObjectList *l = queryList("KviFontSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviFontSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

#include "m_kvi_optionswidget.moc"
