#ifndef _KVI_USERTOOLBARTEMPLATE_H_INCLUDED_
#define _KVI_USERTOOLBARTEMPLATE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_usertoolbartemplate.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

class QFile;

class KviStr;
class KviUserPopupMenu;
class KviUserToolBar;

typedef struct KviUserToolBarData;

class KviUserToolBarTemplate
{
public:
	KviUserToolBarTemplate();
	~KviUserToolBarTemplate();
private:
	int m_id;
public:
	enum ToolButtonType { Separator, Button, Menu };

	QPtrList<KviUserToolBarData> *m_pDataList;

	void copyFromToolBar(KviUserToolBar *toolbar);
	int  insertSeparatorItem();
	int  insertNormalItem(
		const char *name, const char *sbar, const char *img, const char *buffer, KviUserPopupMenu * menu = 0
	);

	static bool saveToolBarTemplate(const char *filename);
	static bool loadToolBarTemplate(const char *filename, KviStr &error);

	bool isEmpty();
	void clearAll();
	void clearToolBar();
private:
	void save(QFile *);
	void    buildDataBuffer(KviStr &buffer);
	bool loadFromDataBuffer(KviStr &buffer, KviStr &error);
};

#endif // _KVI_USERTOOLBARTEMPLATE_H_INCLUDED_
