#ifndef _KVI_TOOLBARBUTTON_KDE_H_INCLUDED_
#define _KVI_TOOLBARBUTTON_KDE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_toolbarbutton_kde.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <ktoolbarbutton.h>

class KviToolBar;

class KviToolBarButton : public KToolBarButton
{
	Q_OBJECT
public:
	KviToolBarButton(QWidget *parent, const char *name = 0);
	KviToolBarButton(
		const QString &icon, const char *textLabel, const char *groupText,
		QObject *receiver, const char *slot, KviToolBar *parent, const char *name = 0
	);
	KviToolBarButton(
		const QPixmap &pm, const char *textLabel, const char *groupText,
		QObject *receiver, const char *slot, KviToolBar *parent, const char *name = 0
	);
	~KviToolBarButton();
public:
	virtual void drawButton(QPainter *);
	virtual void setPixmap(const QPixmap &);
private:
	void init(KviToolBar *parent, QObject *receiver, const char *slot, const char *textLabel, const char *groupText);
};

#endif // _KVI_TOOLBARBUTTON_KDE_H_INCLUDED_
