// =============================================================================
//
//      --- kvi_process_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <stdlib.h>

#include <qfileinfo.h>
#include <qstringlist.h>

#include "kvi_process_kde.h"

QString KviProcess::m_szShellName("");

KviProcess::KviProcess()
	: KProcess()
{
	connect(this, SIGNAL( processExited(KProcess *)),              this, SLOT( processExited(KProcess *)));
	connect(this, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
	connect(this, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
}

KviProcess::~KviProcess()
{
	// Nothing here
}

// TODO: kill-on-close parameter is ignored for now
bool KviProcess::run(const char *commandline, bool bCommunicate, bool /* ignored */, bool bExecInSubshell)
{
	QStringList args = QStringList::split(' ', commandline);
    for( QStringList::Iterator iter = args.begin(); iter != args.end(); ++iter )
		(*this) << *iter;
	setUseShell(bExecInSubshell);

	return start(NotifyOnExit, bCommunicate ? All : NoCommunication);
}

const QString KviProcess::findShell()
{
	if( !m_szShellName.isEmpty() )
		return m_szShellName;

	QString tmp = getenv("SHELL");
	if( !tmp.isEmpty() ) {
		QFileInfo f(tmp);
		if( f.isExecutable() ) {
			m_szShellName = tmp;
			return m_szShellName;
		}
	}
	m_szShellName = "/bin/sh";
	return m_szShellName;
}

void KviProcess::processExited(KProcess *proc)
{
	emit processExited((KviProcess *) proc);
}

void KviProcess::receivedStdout(KProcess *proc, char *buffer, int len)
{
	emit receivedStdout((KviProcess *) proc, buffer, len);
}

void KviProcess::receivedStderr(KProcess *proc, char *buffer, int len)
{
	emit receivedStderr((KviProcess *) proc, buffer, len);
}

#include "m_kvi_process_kde.moc"
