//
//   THIS IS A "READY TO EDIT" SOURCE FOR YOUR FIRST PLUGIN
//   Copyright (C) 1999-2000 PLACE YOUR NAME HERE (your@email)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#define __KVIRC_PLUGIN__

#include "kvirc_plugin.h"

#include "libkvixmms.h"

#include <qnamespace.h>
#include <qpainter.h>

#include <dlfcn.h>

#include "kvi_process.h"

#define KVI_XMMS_UPDATE_TIME 500

static int    (*libxmms_remote_play)(int)                   = 0;
static int    (*libxmms_remote_stop)(int)                   = 0;
static int    (*libxmms_remote_pause)(int)                  = 0;
static bool   (*libxmms_remote_is_playing)(int)             = 0;
static bool   (*libxmms_remote_is_paused)(int)              = 0;
static bool   (*libxmms_remote_is_running)(int)             = 0;
static char * (*libxmms_remote_get_playlist_file)(int,int)  = 0;
static char * (*libxmms_remote_get_playlist_title)(int,int) = 0;
static int    (*libxmms_remote_get_playlist_pos)(int)       = 0;
static int    (*libxmms_remote_get_playlist_length)(int)    = 0;
static int    (*libxmms_remote_get_playlist_time)(int,int)  = 0;
static void   (*libxmms_remote_playlist_prev)(int)          = 0;
static void   (*libxmms_remote_playlist_next)(int)          = 0;
static void   (*libxmms_remote_eject)(int)                  = 0;
static int    (*libxmms_remote_get_main_volume)(int)        = 0;
static void   (*libxmms_remote_set_main_volume)(int,int)    = 0;

static void  *libxmms_handle = 0;

QPixmap * g_pXmmsButtonsNormal;
QPixmap * g_pXmmsButtonsActive;
QPixmap * g_pXmmsButtonsPressed;
QPixmap * g_pXmmsLogo;

bool xmms_plugin_command_xmms(KviPluginCommandStruct *cmd)
{
	if(cmd->params->count() > 1){
		KviStr command = kvirc_plugin_param(cmd,1);
		if(!libxmms_remote_is_running(0)){
			KviProcess proc;
			proc.run("xmms");
		}
		if(kvi_strEqualCI(command.ptr(),"play"))libxmms_remote_play(0);
		else if(kvi_strEqualCI(command.ptr(),"stop"))libxmms_remote_stop(0);
		else if(kvi_strEqualCI(command.ptr(),"pause"))libxmms_remote_pause(0);
		else if(kvi_strEqualCI(command.ptr(),"prev"))libxmms_remote_playlist_prev(0);
		else if(kvi_strEqualCI(command.ptr(),"next"))libxmms_remote_playlist_next(0);
		else if(kvi_strEqualCI(command.ptr(),"eject"))libxmms_remote_eject(0);
		else if(kvi_strEqualCI(command.ptr(),"undock"))kvirc_plugin_remove_all_docked_widgets(cmd->handle);
		else if(kvi_strEqualCI(command.ptr(),"dock")){
			KviXmmsWidget * w = new KviXmmsWidget(cmd->handle,cmd->frame->m_pStatusBar,cmd->frame);
			kvirc_plugin_add_docked_widget(cmd->handle,cmd->frame,w);
			w->show();
		} else if(kvi_strEqualCI(command.ptr(),"volume")){
			if(cmd->params->count() < 3){
				cmd->error = KVI_ERROR_MissingParameter;
				cmd->errorstr = "Missing volume value";
				return false;
			}
			KviStr tmp = kvirc_plugin_param(cmd,2);
			bool bOk = false;
			int vol = tmp.toInt(&bOk);
			if(!bOk || (vol < 0)){
				cmd->error = KVI_ERROR_InvalidParameter;
				cmd->errorstr = "An unsigned volume value is expected";
				return false;
			}
			libxmms_remote_set_main_volume(0,vol);
		} else {
			cmd->error = KVI_ERROR_InvalidParameter;
			cmd->errorstr = "Invalid xmms command";
			return false;
		}
	}
	return true;
}

bool xmms_plugin_function_xmmsIsRunning(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	buffer->append(libxmms_remote_is_running(0) ? '1' : '0');
	return true;
}

bool xmms_plugin_function_xmmsIsPlaying(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	buffer->append(libxmms_remote_is_playing(0) ? '1' : '0');
	return true;
}

bool xmms_plugin_function_xmmsIsPaused(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	buffer->append(libxmms_remote_is_paused(0) ? '1' : '0');
	return true;
}

bool xmms_plugin_function_xmmsCurrentPlaylistPos(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	buffer->setNum(libxmms_remote_get_playlist_pos(0));
	return true;
}

bool xmms_plugin_function_xmmsMainVolume(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	buffer->setNum(libxmms_remote_get_main_volume(0));
	return true;
}

bool xmms_plugin_function_xmmsPlaylistLength(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	buffer->setNum(libxmms_remote_get_playlist_length(0));
	return true;
}

bool xmms_plugin_function_xmmsPlaylistFileName(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	if(cmd->params){
		if(cmd->params->count() > 1){
			bool bOk = false;
			KviStr tmp =  kvirc_plugin_param(cmd,1);
			int pos = tmp.toInt(&bOk);
			if(!bOk){
				cmd->error = KVI_ERROR_InvalidParameter;
				cmd->errorstr = "Playlist position as an unsigned number expected";
				return false;
			} else {
				char * f = libxmms_remote_get_playlist_file(0,pos);
				if(f)buffer->append(f);
			}
			return true;
		}
	}
	char * f = libxmms_remote_get_playlist_file(0,libxmms_remote_get_playlist_pos(0));
	if(f)buffer->append(f);
	return true;
}

bool xmms_plugin_function_xmmsPlaylistTitle(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	if(cmd->params){
		if(cmd->params->count() > 1){
			bool bOk = false;
			KviStr tmp =  kvirc_plugin_param(cmd,1);
			int pos = tmp.toInt(&bOk);
			if(!bOk){
				cmd->error = KVI_ERROR_InvalidParameter;
				cmd->errorstr = "Playlist position as an unsigned number expected";
				return false;
			} else {
				char * f = libxmms_remote_get_playlist_title(0,pos);
				if(f)buffer->append(f);
			}
			return true;
		}
	}
	char * f = libxmms_remote_get_playlist_title(0,libxmms_remote_get_playlist_pos(0));
	if(f)buffer->append(f);
	return true;
}

bool xmms_plugin_function_xmmsPlaylistTime(KviPluginCommandStruct *cmd,KviStr *buffer)
{
	if(cmd->params){
		if(cmd->params->count() > 1){
			bool bOk = false;
			KviStr tmp =  kvirc_plugin_param(cmd,1);
			int pos = tmp.toInt(&bOk);
			if(!bOk){
				cmd->error = KVI_ERROR_InvalidParameter;
				cmd->errorstr = "Playlist position as an unsigned number expected";
				return false;
			} else {
				int t = libxmms_remote_get_playlist_time(0,pos);
				KviStr str(KviStr::Format,"%d",t);
				buffer->append(str.ptr());
			}
			return true;
		}
	}
	int t = libxmms_remote_get_playlist_time(0,libxmms_remote_get_playlist_pos(0));
	KviStr stri(KviStr::Format,"%d",t);
	if(stri.ptr())buffer->append(stri.ptr());
	return true;
}


/* XPM */
static const char * xmms_buttons_xpm[] = {
"96 16 223 2",
"  	c None",
". 	c #020204",
"+ 	c #5E626C",
"@ 	c #2A324C",
"# 	c #3A4A74",
"$ 	c #8E929C",
"% 	c #323E5C",
"& 	c #2A5ADC",
"* 	c #4A5674",
"= 	c #626264",
"- 	c #1A1A2C",
"; 	c #263254",
"> 	c #7A7A7C",
", 	c #3E3E44",
"' 	c #1A264C",
") 	c #565654",
"! 	c #4A4A54",
"~ 	c #6E6E6C",
"{ 	c #262634",
"] 	c #3262E4",
"^ 	c #AAAAAC",
"/ 	c #323654",
"( 	c #36466C",
"_ 	c #525E7C",
": 	c #363634",
"< 	c #363E5C",
"[ 	c #4E566C",
"} 	c #3E465C",
"| 	c #2A3A64",
"1 	c #868684",
"2 	c #5A5E64",
"3 	c #46526C",
"4 	c #9E9E9C",
"5 	c #3E6EF4",
"6 	c #16224C",
"7 	c #4E525C",
"8 	c #6E7684",
"9 	c #2E2E34",
"0 	c #26366C",
"a 	c #424A64",
"b 	c #4E567C",
"c 	c #666A74",
"d 	c #2E3654",
"e 	c #3E3E54",
"f 	c #222E54",
"g 	c #363644",
"h 	c #3A3E64",
"i 	c #565E74",
"j 	c #0E0E24",
"k 	c #7E8284",
"l 	c #3A6AF4",
"m 	c #56627C",
"n 	c #32323C",
"o 	c #9A9A9C",
"p 	c #2E3E6C",
"q 	c #2A3654",
"r 	c #222644",
"s 	c #4E4E4C",
"t 	c #6E727C",
"u 	c #262A44",
"v 	c #B6B6B4",
"w 	c #3E4664",
"x 	c #8E8E8C",
"y 	c #A6A6A4",
"z 	c #1E2234",
"A 	c #424A6C",
"B 	c #4A5A7C",
"C 	c #666664",
"D 	c #1A1E44",
"E 	c #565664",
"F 	c #3A66EC",
"G 	c #323A54",
"H 	c #525A74",
"I 	c #5A5E6C",
"J 	c #4672FC",
"K 	c #4A526C",
"L 	c #767674",
"M 	c #262E4C",
"N 	c #363A4C",
"O 	c #364264",
"P 	c #969694",
"Q 	c #1E1E24",
"R 	c #2A3254",
"S 	c #7E7E7C",
"T 	c #424244",
"U 	c #1E2A54",
"V 	c #2A2A34",
"W 	c #3666EC",
"X 	c #B2B2B4",
"Y 	c #52566C",
"Z 	c #46464C",
"` 	c #8A8A8C",
" .	c #A2A2A4",
"..	c #4272FC",
"+.	c #4E5A7C",
"@.	c #3E4254",
"#.	c #16162C",
"$.	c #5E667C",
"%.	c #32364C",
"&.	c #32426C",
"*.	c #4A4E5C",
"=.	c #424E6C",
"-.	c #323A64",
";.	c #3A4264",
">.	c #0A0A0C",
",.	c #3E4E7C",
"'.	c #325EE4",
").	c #465684",
"!.	c #1E2644",
"~.	c #5A5A5C",
"{.	c #6E6E7C",
"].	c #3662EC",
"^.	c #AEAEAC",
"/.	c #3A466C",
"(.	c #3A3A3C",
"_.	c #3A425C",
":.	c #2E3A5C",
"<.	c #868694",
"[.	c #5E5E5C",
"}.	c #46527C",
"|.	c #426EFC",
"1.	c #1A2244",
"2.	c #525254",
"3.	c #72767C",
"4.	c #6A6A6C",
"5.	c #5A5E74",
"6.	c #121224",
"7.	c #828284",
"8.	c #5A6284",
"9.	c #BEBEBC",
"0.	c #2E5EE4",
"a.	c #5A5A6C",
"b.	c #060604",
"c.	c #2E364C",
"d.	c #2E2E44",
"e.	c #222A4C",
"f.	c #1E2244",
"g.	c #32324C",
"h.	c #666674",
"i.	c #1E1E34",
"j.	c #3E4A6C",
"k.	c #929294",
"l.	c #3A3E54",
"m.	c #2A3664",
"n.	c #464A5C",
"o.	c #727274",
"p.	c #363A5C",
"q.	c #3A3A44",
"r.	c #525A7C",
"s.	c #424254",
"t.	c #464E6C",
"u.	c #42465C",
"v.	c #3E6AF4",
"w.	c #222234",
"x.	c #5E5E6C",
"y.	c #4E526C",
"z.	c #2A2E4C",
"A.	c #4E4E5C",
"B.	c #5E6274",
"C.	c #323E64",
"D.	c #4A567C",
"E.	c #62626C",
"F.	c #26325C",
"G.	c #7A7A84",
"H.	c #3E3E4C",
"I.	c #56565C",
"J.	c #4A4A5C",
"K.	c #6E6E74",
"L.	c #26263C",
"M.	c #3262EC",
"N.	c #364674",
"O.	c #36363C",
"P.	c #4E5674",
"Q.	c #86868C",
"R.	c #465274",
"S.	c #9E9EA4",
"T.	c #3E6EFC",
"U.	c #2E2E3C",
"V.	c #2E365C",
"W.	c #222E5C",
"X.	c #36364C",
"Y.	c #565E7C",
"Z.	c #566284",
"`.	c #323244",
" +	c #9A9AA4",
".+	c #2E3E74",
"++	c #2A365C",
"@+	c #4E4E54",
"#+	c #262A4C",
"$+	c #3E466C",
"%+	c #8E8E94",
"&+	c #A6A6AC",
"*+	c #4A5A84",
"=+	c #66666C",
"-+	c #323A5C",
";+	c #76767C",
">+	c #36426C",
",+	c #96969C",
"'+	c #1E1E2C",
")+	c #2A325C",
"!+	c #7E7E84",
"~+	c #42424C",
"{+	c #2A2A3C",
"]+	c #525674",
"^+	c #464654",
"/+	c #A2A2AC",
"(+	c #4E5A84",
"_+	c #3E425C",
":+	c #324274",
"<+	c #424E74",
"[+	c #3A426C",
"}+	c #1E264C",
"|+	c #AEAEB4",
"1+	c #2E3A64",
"2+	c #5E5E64",
"3+	c #1A224C",
"4+	c #52525C",
"5+	c #727684",
"6+	c #6A6A74",
"7+	c #12122C",
"8+	c #82828C",
"9+	c #72727C",
"0+	c #3A3A4C",
". b.. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". X X ^ ^  . .P k.x 1 S > o.4.n . 4 4 P o x x 1 7.S S L o.~ ~.n . o 4 P k.x x 1 7.S S L o.~ ~.n . P P x ` 1 1 1 7.S S L o.~ ~.n . P P x ` 1 1 1 7.S S L o.~ ~.n . P P x ` 1 1 1 7.S S L o.~ ~.. ",
". C C [.~.s 2.@+T T , (.n n V Q . 4.C [.2.@+2.s T q.(.O.9 9 V Q . C C = 2.@+2.s T q.(.O.9 9 V Q . C = [.2.! s @+T q.(.O.9 9 V Q . C = [.2.! s @+T q.(.O.9 9 V Q . C = [.2.! s @+T q.(.O.9 9 { . ",
". 9.X 4 k.!+Q.> 6+E.I.I.2.(.9 9 . o ` 8+> K.= E 4+@+! Z , O.U.9 . ` S ;+K.=+2+E 4+@+! Z , O.U.9 . Q.!+> K.=+2+I.A.@+! Z , O.U.9 . ` !+> 6+=+2+I.4+@+! Z , O.U.9 . Q.!+> K.=+2+I.4+@+! Z , O.9 . ",
". 9.^.o 8 Y.D.K I.4+u.h l.0+U.V . ^ 7.;+L B.}.Y I.@+! ^+~+q.U.V . k.!+> $.i H K I.J.u._._.q.U.V . 1 !+;+).D.}.<+# >+C.C.C.q.U.V . k.S ;+_ +.+ ~.I.w C.1+C.0+U.V . 1 !+> o.K.=+~.I.@+! ^+s.H.U.. ",
". X k.G.Y.l l =.4+Z p W < q.U.{ . o 7.L {.P.M.0.a ! ^+~+H.q.U.{ . ,+S ;+m T.5 ,.7 a v.v.V.q.U.{ . k.S 9+B ......|.....T.V.q.U.{ . ` !+3.m M.,.~.4+/.T.l G N U.{ . 7.S ;+K.=+a.3 $+n.^+~+H.g 9 . ",
". &+` ;++.v.v.=.A.C.] T.G g V { . ^ 7.o.K.H |...] C.@.H.0+g V { .  .> o.Y...J t.*.} T...m.g V { . ,+S 9++.T...J ....J ..V.g V { . 1 > 9+Y.|.W N.n.< T.|./ O.V { . 7.> L K.B.R.l l C.e H.q.g { . ",
". S.` t +...|.$+>+].J ..R `.{ w.. ^ 7.9+6+* T.J |.W m.N g `.{ w.. S.> 9+Y.|...A ! _...T.F.`.{ w.. k.G.o.D.|.J ..J J ....++d.{ w.. %+> K.i 5 ..l .+C.....d `.{ w.. k.> 9+h.* F ..J v.| q.g `.{ . ",
". 4 !+K.+.....N.M...J ..@ U.{ '+b.&+!+K.h.R.....J ..M.R `.U.{ '+. S.;+K.r.J ..A ^+< J ..M {+{ '+. k.!+t B ..J ....J J T.R {+{ '+. ,+G.K.r.v.J J T.C...|.z.U.{ '+. %+> K.+.W ........l ++d.U.w.. ",
". S.> K.P.....w l ......#+{+'+- >.&+Q.K.=+R...J ....'.; U.{+'+- b.^ G.K.+.....j.! % ....z.{+'+- . %+> K.}.5 ..J J ....|.f {+'+- . o !+6+H ......W 0 ....M u '+- . k.G._ ] |...........'.M V w.. ",
".  .G.K.D...../.C.W J ..e.{ '+- >.^.7.K.E.<+..J ..] F.z.V L.'+'+. ^.!+K.H ..|.[+s.-+J ..e.L.'+- . k.;+K.b ......J J ..|.U { '+- . S.!+K.]+....W 1+V.....u L.'+- . ,+G.D.D.R.A $+h V.F.W.U { - . ",
". &+!+{.P.T.J ;.s.++M.T.r w.- - . &+!+{.=+<+J 5 M.m.`.{+L.w.- #.b.|+!+6+i |.../.@.G ..|.U w.- - . o G.o.B ..J J ....J ..U z - - .  .G.K.+.v.M.h _+G T...!.z - - . o 5+Z.T.|.....T...J ..r i.- . ",
". ^.%+{.]+l v.&.e g f 0.6 - #.6.. &+Q.{.=+R.l & 1+%.U.{ w.- #.6.. v 8+{.i ..|._.l.V...|.1.- #.6.. 4 8+K.D.............5 f.- #.6..  .G.K.H 0.N.u.H.X.|.|.1.- #.#.b.^ G.*+5 ......|...T...' '+#.. ",
". |+%+9++.R.>+h H.`.M ' D #.#.7+. ^ o 9+h.t.:+h 0+g d.L.'+#.#.7+. X ,+9+Y.t.$+_+H.%.f !.D #.6.7+. ^ %+G.+.<+# O p ++e.}+D #.6.7+. &+%+9+r.[ A.^+H.c.f }+D #.6.j . &+<.Z.Y.P.u.;.N @ z.f.D #.6.. ",
"b. .k.8+9+{.E Z 0+`.{+{ #.6.j j . S.&+Q.6+a.7 ^+0+`.{+w.#.6.j j . ^ S.k.<.=+A.s.0+`.{+{ #.#.j j . /+ +Q.6+x.4+~+0+%.{+w.#.#.j j . ^ ,+8+{.2+4+^+0+`.{+w.#.#.6.j .  .S.%+h.I 4+u.H.`.U.z #.#.j . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . b.. . . . . . . . . . . . . . b.. . . . . . . . . . . . . . . . . b.. . . . . . . . . . . . >.b.. . . . . . . . . . . . . "};

/* XPM */
static const char * xmms_buttons_active_xpm[] = {
"96 16 225 2",
"  	c None",
". 	c #020204",
"+ 	c #726A44",
"@ 	c #363624",
"# 	c #52523C",
"$ 	c #9E9E94",
"% 	c #86867C",
"& 	c #5E5E4C",
"* 	c #464634",
"= 	c #7A7A6C",
"- 	c #7A6A3C",
"; 	c #62522C",
"> 	c #DAA62C",
", 	c #524624",
"' 	c #463E1C",
") 	c #525244",
"! 	c #6E5E34",
"~ 	c #767254",
"{ 	c #EABA34",
"] 	c #423E1C",
"^ 	c #6A6A5C",
"/ 	c #26260C",
"( 	c #7A724C",
"_ 	c #524E34",
": 	c #92928C",
"< 	c #4E4E3C",
"[ 	c #B2B2AC",
"} 	c #5A5A4C",
"| 	c #6A6654",
"1 	c #726644",
"2 	c #F6C63C",
"3 	c #2E2E1C",
"4 	c #5A522C",
"5 	c #46463C",
"6 	c #625A34",
"7 	c #3E3A1C",
"8 	c #5E5E54",
"9 	c #82827C",
"0 	c #7E765C",
"a 	c #AAAAA4",
"b 	c #5A5644",
"c 	c #3E3E34",
"d 	c #726E54",
"e 	c #E2B234",
"f 	c #5A4A24",
"g 	c #4E421C",
"h 	c #766E5C",
"i 	c #82724C",
"j 	c #5A5234",
"k 	c #6A5A2C",
"l 	c #8E8E84",
"m 	c #4E4624",
"n 	c #827E74",
"o 	c #524A24",
"p 	c #4A421C",
"q 	c #565644",
"r 	c #6E5E3C",
"s 	c #F2C23C",
"t 	c #6E6E64",
"u 	c #2E2A14",
"v 	c #5A4E2C",
"w 	c #9A9A94",
"x 	c #3A3A2C",
"y 	c #A6A69C",
"z 	c #72726C",
"A 	c #2A2A14",
"B 	c #726A54",
"C 	c #665E3C",
"D 	c #7E7E74",
"E 	c #7A6E4C",
"F 	c #F2BE3C",
"G 	c #42422C",
"H 	c #6A6A6C",
"I 	c #524E3C",
"J 	c #9A968C",
"K 	c #6E664C",
"L 	c #FECA44",
"M 	c #32321C",
"N 	c #625A44",
"O 	c #626254",
"P 	c #524A34",
"Q 	c #363634",
"R 	c #A2A29C",
"S 	c #8A8A84",
"T 	c #E2AE2C",
"U 	c #525254",
"V 	c #76622C",
"W 	c #EEBE34",
"X 	c #3E3E2C",
"Y 	c #6E6A5C",
"Z 	c #26261C",
"` 	c #7E724C",
" .	c #96968C",
"..	c #BEBEBC",
"+.	c #5A5A5C",
"@.	c #FACA44",
"#.	c #5E562C",
"$.	c #4A4A3C",
"%.	c #665A34",
"&.	c #3E3A2C",
"*.	c #424234",
"=.	c #EAB234",
"-.	c #82764C",
";.	c #5A563C",
">.	c #4E4A2C",
",.	c #564A24",
"'.	c #46422C",
").	c #76766C",
"!.	c #6A6244",
"~.	c #0A0A0C",
"{.	c #766A44",
"].	c #3A3624",
"^.	c #565234",
"/.	c #4A4A34",
"(.	c #7A7A7C",
"_.	c #625634",
":.	c #4A3E1C",
"<.	c #565244",
"[.	c #6E6234",
"}.	c #2A2614",
"|.	c #564E2C",
"1.	c #4E4E4C",
"2.	c #B6B6B4",
"3.	c #5E5A4C",
"4.	c #76663C",
"5.	c #FAC63C",
"6.	c #2E2E2C",
"7.	c #5E5224",
"8.	c #4A463C",
"9.	c #AEAEAC",
"0.	c #060604",
"a.	c #E6B634",
"b.	c #6E623C",
"c.	c #727264",
"d.	c #666664",
"e.	c #7A766C",
"f.	c #6A5A34",
"g.	c #827654",
"h.	c #565654",
"i.	c #626264",
"j.	c #725E2C",
"k.	c #423A1C",
"l.	c #86827C",
"m.	c #766E4C",
"n.	c #6E5A24",
"o.	c #928E84",
"p.	c #867E6C",
"q.	c #6A5E3C",
"r.	c #7E6E4C",
"s.	c #E6AE34",
"t.	c #867644",
"u.	c #66562C",
"v.	c #4A4634",
"w.	c #EEBA34",
"x.	c #5E5644",
"y.	c #E6B234",
"z.	c #5E5234",
"A.	c #F6C23C",
"B.	c #76726C",
"C.	c #766A54",
"D.	c #564E3C",
"E.	c #423E2C",
"F.	c #5E563C",
"G.	c #4A422C",
"H.	c #36362C",
"I.	c #9E9E9C",
"J.	c #868684",
"K.	c #7A7A74",
"L.	c #7A6A44",
"M.	c #52462C",
"N.	c #463E24",
"O.	c #52524C",
"P.	c #423E24",
"Q.	c #6A6A64",
"R.	c #262614",
"S.	c #7A7254",
"T.	c #929294",
"U.	c #4E4E44",
"V.	c #B2B2B4",
"W.	c #5A5A54",
"X.	c #2E2E24",
"Y.	c #464644",
"Z.	c #625A3C",
"`.	c #3E3A24",
" +	c #5E5E5C",
".+	c #828284",
"++	c #AAAAAC",
"@+	c #3E3E3C",
"#+	c #8E8E8C",
"$+	c #4E462C",
"%+	c #524A2C",
"&+	c #4A4224",
"*+	c #56564C",
"=+	c #6E6E6C",
"-+	c #5A4E34",
";+	c #9A9A9C",
">+	c #3A3A34",
",+	c #A6A6A4",
"'+	c #2A2A1C",
")+	c #665E44",
"!+	c #7E7E7C",
"~+	c #7A6E54",
"{+	c #6E6654",
"]+	c #323224",
"^+	c #62625C",
"/+	c #A2A2A4",
"(+	c #8A8A8C",
"_+	c #E2AE34",
":+	c #EEBE3C",
"<+	c #6E6A64",
"[+	c #7E7254",
"}+	c #969694",
"|+	c #665A3C",
"1+	c #42423C",
"2+	c #4E4A34",
"3+	c #564A2C",
"4+	c #767674",
"5+	c #766A4C",
"6+	c #56523C",
"7+	c #564E34",
"8+	c #766644",
"9+	c #FAC644",
"0+	c #5E522C",
"a+	c #6E6244",
"b+	c #766E54",
". 0.. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". V.[ ++a /+/+}+: #+J.!+(.z H ]+. I.I.}+w #+#+J..+!+!+4+z =++.]+. ;+I.}+T.#+#+J..+!+!+4+z =++.]+. }+}+#+(+J.J.J..+!+!+4+z =++.]+. }+}+#+(+J.J.J..+!+!+4+z =++.]+. }+}+#+(+J.J.J..+!+!+4+z =++.. ",
". d.d.i.W.1.h.U Y.Y.1+@+>+Q ]+Z . H d. +U O.h.1.Y.@+@+>+Q H.]+Z . d.d.^+h.1.h.1.Y.@+@+>+Q H.]+Z . d.i.^+U 1.O.1.Y.@+@+>+Q H.]+Z . d.i.^+U 1.O.1.Y.@+@+>+Q H.]+Z . d.i.^+U 1.O.1.Y.@+@+>+H.H.X.. ",
". ..V.;+}+% J.D t d.8 8 *+5 H.>+. ;+(+J.(.z ^+8 *+*+O.U.5 @+Q >+. (+!+(.=+Q.^+8 *+*+O.U.5 @+Q >+. J..+K.z d.^+8 b *+O.U.5 @+Q >+. (+.+e.z d.^+8 *+*+) U.5 @+Q >+. J..+K.z d.^+8 *+*+O.U.Y.c x . ",
". ..9.w p.~+5+K 8 h.j x.I 5 x @ . a .+D 4+h E | W.*+O.I U.5 x @ . T.9 (.0 b+C.K W.b b ;.^.5 x @ . J.!+K.t.r.L.1 b.f.f.u.z.* x @ . #+.+K.i ~+Q.d.W.N f.u._.v.x @ . J.!+(.4+=+Q.^+W.*+O.I U.5 x . ",
". V.}+!+[+s F a+W.*+%.a.-+5 x ]+. ;+.+4+).m.a.y.q.O.) U.$.* x ]+. w !+K.S.2 @.a+3.x.s F z.* x ]+. : 9 K.i 2 L L 9+@.@.@.0+5 x ]+. #+!+e.S.=.4.8 W.u.2 A.7+* x ]+. .+9 K.).=+{+a+b.q ) U.$.1+x . ",
". ,+#+K.~+2 s b.} %.{ @.%+*.H.]+. a J.4+z 5+2 @.y.%.U.$.5 *.H.]+. R !+e.~+9+L !.} z.9+5.0+*.H.]+. w !+4+[+2 L L L L L L v *.H.]+. S !+K.b+5.F 4.& _.2 5._ *.H.]+. .+!+4+z t + :+F %.I $.$.*.@ . ",
". R S 4+E @.9+q.n.a.L @.|.E.]+X.. ++9 4+=+5+5.L 5.w.#.v.5 E.]+X.. /+!+4+~+@.L a+*+;.@.9+v *.]+X.. T.9 ).r.@.L L L L L @.,.*.]+X.. : !+).b+2 @.F j.%.L L M.E.]+X..  .D 4+c.8+w.L L s %.5 *.E.]+. ",
". I.9 ).E @.L b.=.L L 9+>.c ]+'+0.a % ).=+{.@.L L L y.|.*.X ]+'+. R D ).E L @.q.q z.@.L , X ]+'+. T.9 z L.@.L L L L L @., X ]+'+. w !+).d A.L L 2 z.L @.>.c ]+'+. T.9 z ~+w.@.L L L W 4 *.x ]+. ",
". /+!+z 5+5.L Z.W L L L &+x M '+~.++J.z t 1 L L L L s.,.X x ]+A 0.++9 z m.L 9+q.) 4 L @.'.&.M A . : 9 z E 2 L L L L L 5.m &.M A . I.9 z C.5.L @.w.u.@.L N.x M A .  .!+[+a.@.L L L @.L a.'.x 3 . ",
". y n 4+E @.L |+%.a.L @.' @ 3 M ~.[ J.).Q.1 L L @.a.v X x @ 3 3 0.9.9 B.d L @.q.I j L L p @ 3 3 . }+!+).5+L L L L L L 5.g @ 3 3 . R 9 ).d @.L { k 7.@.L ' @ 3 3 . w n -.b+K !.Z.;.|.|., P.@ '+. ",
". ,+J.).m.2 L C # ; a.5.' X.A A . ++9 ).t 1 L s y.7.'.x @ 3 '+A . 9.9 4++ L @.Z.# |.L 5.' X.'+A . $ 9 ).m.@.L L L L L @.g X.'+A . ,+!+).5+s e f.6+7+5.L ' X.'+A . $ 9 S.9+5.9+@.5.L L L @ ]+3 . ",
". 9.: ).~+s s %.< /.f T g 3 A R.. a S ).t + s > #.v.E.x @ 3 A R.. 2.S = d L 5._.< |.@.9+] 3 A R.. $ % ).` @.@.L L @.@.2 :.3 A R.. ,+9 = C.e ! <.< /.@.5.:.3 A }.0.++l.-.@.L L L 5.5.@.2 ].A R.. ",
". [ : K.E 1 [.F.2+*.&+p k.A R./ . a I.K.t 1 V 6 < * X @ M A }.}.. 2.w K.h 1 q.3.2+v.m m k.A R./ . 9. .9 m.4.[.6 #.|., :.7 A R./ . a : 4+d K } q $.$+, p k.}.R./ . 9.l g.h + Z.F.^.v.'.' 7 A A . ",
"0.,+ .S D e.8 ) $.G &.@ A }./ / . R ,+l ).| } ) $.* X M A R./ / . 9.R w S t 3.) $.'.x M A }.R./ . ,+R l ).| & ) /.* X @ A }./ / . 9.$ S = ^ W.) $.*.&.@ A }./ / . y ,+ .c.^ & ) $.G X M A R./ . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 0.. . . . . . . . . . . . . . 0.. . . . . . . . . . . . . . . . . 0.. . . . . . . . . . . . ~.0.. . . . . . . . . . . . . "};

/* XPM */
static const char * xmms_buttons_pressed_xpm[] = {
"96 16 222 2",
"  	c None",
". 	c #020204",
"+ 	c #4A4E54",
"@ 	c #2A2A2C",
"# 	c #6E7684",
"$ 	c #323E5C",
"% 	c #525254",
"& 	c #2E364C",
"* 	c #3E3E3C",
"= 	c #3262E4",
"- 	c #16161C",
"; 	c #62666C",
"> 	c #2A5ADC",
", 	c #5A5E64",
"' 	c #222224",
") 	c #222A4C",
"! 	c #425684",
"~ 	c #464644",
"{ 	c #2A3654",
"] 	c #36466C",
"^ 	c #5E5E5C",
"/ 	c #1A2244",
"( 	c #424E6C",
"_ 	c #3E465C",
": 	c #323234",
"< 	c #8A8A8C",
"[ 	c #363E5C",
"} 	c #32324C",
"| 	c #323654",
"1 	c #3E6EF4",
"2 	c #1E1E1C",
"3 	c #263254",
"4 	c #0E0E14",
"5 	c #262A3C",
"6 	c #5A5A5C",
"7 	c #363634",
"8 	c #6E6E6C",
"9 	c #525E7C",
"0 	c #4A5674",
"a 	c #4A526C",
"b 	c #3E3E54",
"c 	c #222644",
"d 	c #464A5C",
"e 	c #4A567C",
"f 	c #7E8284",
"g 	c #26366C",
"h 	c #464E6C",
"i 	c #363644",
"j 	c #52566C",
"k 	c #3A6AF4",
"l 	c #262624",
"m 	c #2A2E4C",
"n 	c #5E5E6C",
"o 	c #1A264C",
"p 	c #3E4A6C",
"q 	c #364264",
"r 	c #2E2E3C",
"s 	c #2E3E6C",
"t 	c #1A1A1C",
"u 	c #66666C",
"v 	c #222E54",
"w 	c #464A54",
"x 	c #1A1E3C",
"y 	c #121214",
"z 	c #0A0A0C",
"A 	c #4A4E5C",
"B 	c #7A7A7C",
"C 	c #565654",
"D 	c #424244",
"E 	c #3A66EC",
"F 	c #5A6274",
"G 	c #929294",
"H 	c #323A54",
"I 	c #4672FC",
"J 	c #26325C",
"K 	c #2A2E3C",
"L 	c #5A627C",
"M 	c #4A5A7C",
"N 	c #46526C",
"O 	c #363A4C",
"P 	c #2E2E2C",
"Q 	c #3666EC",
"R 	c #565E74",
"S 	c #2E3654",
"T 	c #3A4A74",
"U 	c #1A224C",
"V 	c #3E466C",
"W 	c #4272FC",
"X 	c #2A2A3C",
"Y 	c #525A74",
"Z 	c #6E7274",
"` 	c #56627C",
" .	c #4E5A74",
"..	c #3E4254",
"+.	c #2E3A64",
"@.	c #222634",
"#.	c #5E626C",
"$.	c #3A4264",
"%.	c #32426C",
"&.	c #666A74",
"*.	c #222E5C",
"=.	c #363A54",
"-.	c #4E4E4C",
";.	c #767674",
">.	c #3E3E4C",
",.	c #3662EC",
"'.	c #16162C",
").	c #325EE4",
"!.	c #222234",
"~.	c #464654",
"{.	c #3A466C",
"].	c #626264",
"^.	c #1E223C",
"/.	c #3E4E7C",
"(.	c #42465C",
"_.	c #323244",
":.	c #8E8E8C",
"<.	c #3A425C",
"[.	c #426EFC",
"}.	c #1E1E2C",
"|.	c #2A324C",
"1.	c #0E0E24",
"2.	c #3A3A3C",
"3.	c #4E566C",
"4.	c #86868C",
"5.	c #2A3A64",
"6.	c #1E2644",
"7.	c #424A64",
"8.	c #1A1A2C",
"9.	c #2E5EE4",
"0.	c #060604",
"a.	c #7E7E7C",
"b.	c #969694",
"c.	c #5E667C",
"d.	c #1A1E44",
"e.	c #121224",
"f.	c #0A0A1C",
"g.	c #565664",
"h.	c #46527C",
"i.	c #3A3E54",
"j.	c #26263C",
"k.	c #2A3664",
"l.	c #262E4C",
"m.	c #4A4A4C",
"n.	c #1E1E34",
"o.	c #4E5A7C",
"p.	c #3A3A44",
"q.	c #424254",
"r.	c #62626C",
"s.	c #6A6A6C",
"t.	c #32364C",
"u.	c #262A4C",
"v.	c #565E7C",
"w.	c #4E526C",
"x.	c #4A4A5C",
"y.	c #4E567C",
"z.	c #828284",
"A.	c #3E6AF4",
"B.	c #4E4E5C",
"C.	c #2A325C",
"D.	c #5A5E74",
"E.	c #727274",
"F.	c #262634",
"G.	c #2A2A34",
"H.	c #323E64",
"I.	c #52525C",
"J.	c #3E3E44",
"K.	c #3262EC",
"L.	c #161624",
"M.	c #5A5E6C",
"N.	c #22222C",
"O.	c #46464C",
"P.	c #2A365C",
"Q.	c #364674",
"R.	c #5E5E64",
"S.	c #424E74",
"T.	c #3E4664",
"U.	c #32323C",
"V.	c #3E6EFC",
"W.	c #1E1E24",
"X.	c #0E0E1C",
"Y.	c #262A44",
"Z.	c #5A5A64",
"`.	c #36363C",
" +	c #6E6E74",
".+	c #464E74",
"++	c #36364C",
"@+	c #525674",
"#+	c #26262C",
"$+	c #36426C",
"%+	c #2E2E44",
"&+	c #2E3E74",
"*+	c #1A1A24",
"=+	c #12121C",
"-+	c #0A0A14",
";+	c #56565C",
">+	c #42424C",
",+	c #323A5C",
"'+	c #465274",
")+	c #2E2E34",
"!+	c #2E365C",
"~+	c #2A2A44",
"{+	c #525A7C",
"]+	c #566284",
"^+	c #3E425C",
"/+	c #5E6274",
"(+	c #3A426C",
"_+	c #324274",
":+	c #363A5C",
"<+	c #4E4E54",
"[+	c #76767C",
"}+	c #1E2244",
"|+	c #8E8E94",
"1+	c #2A3254",
"2+	c #4E5674",
"3+	c #1E264C",
"4+	c #424A6C",
"5+	c #262E54",
"6+	c #4A4A54",
"7+	c #4E5A84",
"8+	c #3A3A4C",
"9+	c #6A6A74",
". 0.. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ",
". : : % B :.G < z.a.B 8 6 D 7 t . l P -.E.B B ;.E.E.8 ^ D @ ' - . @ 2.s.a.a.a.;.E.8 u C D : l - . : 7 m.].E.B a.B ;.;.s.% * : 2 . ~ C s.;.;.E.E.8 8 s.u ].% 2.2 . : m.^ 8 E.E.;.E.8 s.6 D : P . ",
". t : D m.m.% <+J.D * `.@ #+W.y . t ' 2.~ m.-.O.J.2.2.U.@ t 4 z . - P % <+m.<+m.J.2.`.P ' t y z . 2 P D ~ m.m.m.J.p.2.: @ ' - y . P * C -.O.m.m.J.`.7 : #+N.t 4 . l 7 -.m.~ m.m.* p.7 P W.t t . ",
". ~ 8 < G a.z.B s.r.;+g.<+`.G.N.. @ * R. +9+].;+I.<+6+>+J.G.t 4 . @ -.;. +u ].;+% <+~.>+`.G.W.y . @ m.u s.u R.;+I.6+6+>+p.G.W.W.. * I.Z s.r.R.;+% <+~.O.J.U.#+W.. * ;+[+ +u R.g.% <+~.>+U.#+N.. ",
". ~ ;.|+Z ` y.w.;+B.(.<.i.i F.*+. P ~ u  +F '+Y ;+B.6+~.>.U.W.4 . @ 6 ;.c.R 2+0 I.x.d <.=.U.#+=+. @ % Z h.e '+/.p ] H.H.+.`.N.*+. J.C  +]+M #.R.;+T.%.5.+.i F.*+. D ^ ;.E.s.r., ;+B.6+O.J.r #+. ",
". D s.B 9 k k 4+I.6++.K.H i #+- . @ -.u s.2+,.= 7.6+O.>+>._.' 4 . P 6 E.]+1 [.S.I._ A.1 P.U.N.y . @ C  +7+W W W W W W [.!+p.#+*+. * 6  +v.)./.g.I.q V.A.,+p.F.*+. D R.E.E.s.Z..+{.w ~.>.p.r N.. ",
". * u E.{+V.k /.<+%.Q W H i !.- . : -.].u  .1 [.= q q.>.p.`.}.4 . : Z.E.v.W W ( A q.V.V.C.r }.4 . : ;+ +9 V.I W I W W W 5._.!.*+. J.;+Z ` W Q T A [ [.W H _.#+- . J.6 E.9+/+'+k k $+b >.p.r N.. ",
". O.9+Z y.W [.p %.,.I W 1+_.!.=+. )+-.r.u y.1 I [.Q 5.O ++U.*+-+. 7 Z.E.{+W I ( A ^+[.W J r 8.4 . P C u e V.I W I I I [.1+U.N.*+. D ;+9+R A.W E _+s W W & %+N.- . ~ ;+9+u e E I W 1 5.8+_.G.*+. ",
". ~ s. +o.W W $+,.W W [.1+r N.y . P O.u u '+W W W W ).C._.X W.4 . 2.R. +{+I W 4+w [ W W m j.*+z . )+I.9+e [.W I W W W W 3 ~+!.=+. D 6 9+Z.V.W W V.,+W [.m r !.=+. J.;+u o.Q W W I W E J U.X }.. ",
". O.r. +2+W W T.Q W I W l.X }.X.. P O.r.r.'+W I I W 9.5+r j.L.0.. * R. +o.W [.V w $ W W l.F.*+-+. P % s.e V.W I I I W [.l.5 }.=+. O.R. +{+[.I W Q g W W l.5 }.=+. * ;+2+= W I W W W I ,.Y.F.*+. ",
". ~ ]. +0 [.I V H.Q W [.u.!.'.=+. @ ~ ].n .+I W W K.P.m X !.L.-+. 2.#.u Y W W T...,+I W ) !.e.-+. @ <+u 2+W I W W W I V.) !.8.X.. ~ ].9+2+[.W ,.s !+W W Y.!.8.=+. J.;+o.@+3.h 4+b ,+{ v 5 }.=+. ",
". ~ R.9+0 W W (+..5.= 1 ) !.L.X.. @ D R.#./.I 1 = P._.G.F.}.=+0.. : ;+u R W W ^+q.!+W [.6.}.e.-+. #+~ u M W I I I W W W ) }.'.4 . J.6  + .1 = $+<.| V.W c n.L.X.. 2.+ L V.W [.W W [.I I j.}.=+. ",
". J.6 9+o.E k q >.++*.9.U 8.e.4 . @ J.6 R..+k > 5.t.%+X !.'.e.f.. P ~ u {+W [.$.i.S W 1 6.8.=+-+. l `., h.W W W W W W 1 U 8.L.f.. 2.B.u Y 9.{.~.>.t.[.W U 8.e.-+. : D e [.W W W [.W V.V.^.'.e.. ",
". J.<+u o.h.$+^+>.t.l.o d.'.1.f.. @ J.<+, '+&+[ >.i X !.n.e.X.0.. )+J.6 Y S.p ^+>.} 5+3+x e.X.0.. P : ;+0 '+T q +.P.v 3+/ '.e.f.. 2.-.r.{+w.B.~.>.& ) 3+/ L.e.f.. )+J.2+v.3.4+<.H & m }+/ L.e.. ",
". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 0.. . . . . . . . . . . . . . "};


/* XPM */
static const char * xmms_logo_xpm[] = {
"50 16 74 1",
" 	c None",
".	c #000000",
"+	c #040404",
"@	c #010101",
"#	c #060606",
"$	c #0F0F0F",
"%	c #868686",
"&	c #8B8B8B",
"*	c #6E6E6E",
"=	c #585858",
"-	c #5B5B5B",
";	c #5A5A5A",
">	c #535353",
",	c #4F4F4F",
"'	c #4B4B4B",
")	c #424242",
"!	c #353535",
"~	c #313131",
"{	c #343434",
"]	c #3D3D3D",
"^	c #242424",
"/	c #282828",
"(	c #2F2F2F",
"_	c #202020",
":	c #1C1C1C",
"<	c #212121",
"[	c #252525",
"}	c #0C0C0C",
"|	c #151515",
"1	c #111111",
"2	c #0E0E0E",
"3	c #6F6F6F",
"4	c #545454",
"5	c #464646",
"6	c #353746",
"7	c #1C234F",
"8	c #212643",
"9	c #1D1D1D",
"0	c #181818",
"a	c #171717",
"b	c #191919",
"c	c #0A0F2C",
"d	c #121945",
"e	c #0B102D",
"f	c #030303",
"g	c #030B37",
"h	c #0E1642",
"i	c #0D1541",
"j	c #121212",
"k	c #080A19",
"l	c #020A36",
"m	c #000733",
"n	c #000522",
"o	c #030614",
"p	c #000211",
"q	c #000F67",
"r	c #000C55",
"s	c #505050",
"t	c #2E2E2E",
"u	c #001489",
"v	c #00179B",
"w	c #454545",
"x	c #232323",
"y	c #000A44",
"z	c #001178",
"A	c #4E4E4E",
"B	c #555555",
"C	c #333333",
"D	c #4A4A4A",
"E	c #3B3B3B",
"F	c #0D0D0D",
"G	c #363636",
"H	c #2D2D2D",
"I	c #090909",
".........+@..@+#.@+......#+.......................",
"$%&*=-;>,')!~{]^/(_:<[<(}|12......................",
"@345)67890abcdefghij}#klmn@ommn...nmmp..nqqrn.....",
".s>t[+uvp..nvvmnvvv...rvvm.rvvq...uvv..qvvvvvm....",
".;wx2.yvr.puvm.yvvv..pvvvn.zvvq..yvvu.nvup.mvu....",
".A{2...uvnuvr..qvqv..rvzv..vqvq..uzvq.mvz...qq....",
"@BC....rvvvq...vuqv.nvruz.mvrvq.rvyvy.pvvzy.......",
"+D^....nvvq...pvqqv.zvnvq.yvmvqpvzyvm..nuvvum.....",
"+EF....qvvz...mvyrvnvrmvm.qvpuqrvnqv.....mzvvp....",
"+Gf...qvuvvn..qvmmvuvpqvn.vv.quvz.vu.nqm...zvm....",
"+H...rvvprvz..uv.mvvz.zv.nvq.qvvypvq.mvz...uvn....",
".2f.mvvm.puvy.vu.mvvn.vq.mvr.qvu.mvm..uvvvvvq.....",
".}I.qqy...mqrnqy.nqr.nqy.yqn.yqm.yqn..prqzqy......",
".b+...............................................",
".}................................................",
".................................................."};

bool xmms_plugin_init(KviPluginCommandStruct *cmd)
{
	libxmms_handle = dlopen("libxmms.so",RTLD_GLOBAL|RTLD_NOW);
	if(!libxmms_handle){
		debug("[libkvixmms] : Could not load libxmms : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not load libxmms : %s",dlerror());
		return false;
	}
	libxmms_remote_play = (int (*)(int)) dlsym(libxmms_handle,"xmms_remote_play");
	if(!libxmms_remote_play){
		debug("[libkvixmms] : Could not find symbol xmms_remote_play : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_play : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_stop = (int (*)(int)) dlsym(libxmms_handle,"xmms_remote_stop");
	if(!libxmms_remote_stop){
		debug("[libkvixmms] : Could not find symbol xmms_remote_stop : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_stop : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_playlist_prev = (void (*)(int)) dlsym(libxmms_handle,"xmms_remote_playlist_prev");
	if(!libxmms_remote_playlist_prev){
		debug("[libkvixmms] : Could not find symbol xmms_remote_playlist_prev : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_playlist_prev : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_playlist_next = (void (*)(int)) dlsym(libxmms_handle,"xmms_remote_playlist_next");
	if(!libxmms_remote_playlist_next){
		debug("[libkvixmms] : Could not find symbol xmms_remote_playlist_next : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_playlist_next : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_pause = (int (*)(int)) dlsym(libxmms_handle,"xmms_remote_pause");
	if(!libxmms_remote_pause){
		debug("[libkvixmms] : Could not find symbol xmms_remote_pause : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_pause : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_eject = (void (*)(int)) dlsym(libxmms_handle,"xmms_remote_eject");
	if(!libxmms_remote_eject){
		debug("[libkvixmms] : Could not find symbol xmms_remote_eject : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_eject : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_is_playing = (bool (*)(int)) dlsym(libxmms_handle,"xmms_remote_is_playing");
	if(!libxmms_remote_is_playing){
		debug("[libkvixmms] : Could not find symbol xmms_remote_playing : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_playing : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_is_paused = (bool (*)(int)) dlsym(libxmms_handle,"xmms_remote_is_paused");
	if(!libxmms_remote_is_paused){
		debug("[libkvixmms] : Could not find symbol xmms_remote_is_paused : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_is_paused : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_is_running = (bool (*)(int)) dlsym(libxmms_handle,"xmms_remote_is_running");
	if(!libxmms_remote_is_running){
		debug("[libkvixmms] : Could not find symbol xmms_remote_is_running : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_is_running : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_get_playlist_file = (char * (*)(int,int)) dlsym(libxmms_handle,"xmms_remote_get_playlist_file");
	if(!libxmms_remote_get_playlist_file){
		debug("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_file : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_file : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_get_playlist_time = (int (*)(int,int)) dlsym(libxmms_handle,"xmms_remote_get_playlist_time");
	if(!libxmms_remote_get_playlist_time){
		debug("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_time : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_time : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_get_playlist_title = (char * (*)(int,int)) dlsym(libxmms_handle,"xmms_remote_get_playlist_title");
	if(!libxmms_remote_get_playlist_title){
		debug("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_title : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_title : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_get_playlist_pos = (int (*)(int)) dlsym(libxmms_handle,"xmms_remote_get_playlist_pos");
	if(!libxmms_remote_get_playlist_pos){
		debug("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_pos : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_pos : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_get_playlist_length = (int (*)(int)) dlsym(libxmms_handle,"xmms_remote_get_playlist_length");
	if(!libxmms_remote_get_playlist_length){
		debug("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_length : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_get_playlist_length : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_get_main_volume = (int (*)(int)) dlsym(libxmms_handle,"xmms_remote_get_main_volume");
	if(!libxmms_remote_get_main_volume){
		debug("[libkvixmms] : Could not find symbol xmms_remote_get_main_volume : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_get_main_volume : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	libxmms_remote_set_main_volume = (void (*)(int,int)) dlsym(libxmms_handle,"xmms_remote_set_main_volume");
	if(!libxmms_remote_set_main_volume){
		debug("[libkvixmms] : Could not find symbol xmms_remote_set_main_volume : %s",dlerror());
		cmd->errorstr.sprintf("[libkvixmms] : Could not find symbol xmms_remote_set_main_volume : %s",dlerror());
		dlclose(libxmms_handle);
		return false;
	}
	g_pXmmsButtonsNormal = new QPixmap(xmms_buttons_xpm);
	g_pXmmsButtonsActive = new QPixmap(xmms_buttons_active_xpm);
	g_pXmmsButtonsPressed = new QPixmap(xmms_buttons_pressed_xpm);
	g_pXmmsLogo = new QPixmap(xmms_logo_xpm);

	kvirc_plugin_register_command(cmd->handle,"XMMS",xmms_plugin_command_xmms);
	kvirc_plugin_register_function(cmd->handle,"xmmsIsRunning",xmms_plugin_function_xmmsIsRunning);
	kvirc_plugin_register_function(cmd->handle,"xmmsIsPlaying",xmms_plugin_function_xmmsIsPlaying);
	kvirc_plugin_register_function(cmd->handle,"xmmsIsPaused",xmms_plugin_function_xmmsIsPaused);
	kvirc_plugin_register_function(cmd->handle,"xmmsCurrentPlaylistPos",xmms_plugin_function_xmmsCurrentPlaylistPos);
	kvirc_plugin_register_function(cmd->handle,"xmmsPlaylistFileName",xmms_plugin_function_xmmsPlaylistFileName);
	kvirc_plugin_register_function(cmd->handle,"xmmsPlaylistTitle",xmms_plugin_function_xmmsPlaylistTitle);
	kvirc_plugin_register_function(cmd->handle,"xmmsPlaylistTime",xmms_plugin_function_xmmsPlaylistTime);
	kvirc_plugin_register_function(cmd->handle,"xmmsPlaylistLength",xmms_plugin_function_xmmsPlaylistLength);
	kvirc_plugin_register_function(cmd->handle,"xmmsMainVolumne",xmms_plugin_function_xmmsMainVolume);
	return true; // success
}

void xmms_plugin_cleanup()
{
	if(libxmms_handle)dlclose(libxmms_handle);
	delete g_pXmmsButtonsNormal;
	delete g_pXmmsButtonsActive;
	delete g_pXmmsButtonsPressed;
	delete g_pXmmsLogo;
	kvirc_plugin_unregister_meta_object("KviXmmsWidget");
}

/*
	@document: doc_plugin_xmms.kvihelp
	@title: The XMMS controller plugin
		The XMMS controller plugin is an interface to the
		libxmms library provided with the xmms mp3 player.<br>
		It loads dynamiccaly the libxmms library, so it must
		be found by the dynamic linker at plugin load time.<br>
		If you gen any "shared libraries" error while loading this
		plugin, make sure that libxmms is on a path that is found
		int /etc/ld.so.conf.<br>
		If it is not, add that directory and then run ldconfig.<br>
		<docsubtitle>Exported commands</docsubtitle>
		/xmms &lt;option&gt; [parameter]<br>
		Options:<br>
		<b>play</b> : Starts playing a song in xmms.<br>
		<b>stop</b> : Acts like pressing the stop button in xmms.<br>
		<b>pause</b> : Pauses or resumes playing.<br>
		<b>next</b> : Plays the next song in the playlist.<br>
		<b>prev</b> : Plays the previous song in the playlist.<br>
		<b>eject</b> : Acts like pressing the "eject" button in xmms.<br>
		<b>dock</b> : Runs a controller window that docks in the kvirc's status bar.<br>
		<b>undock</b> : Terminates the controller window.<br>
		<b>volume</b> : Sets the main volume to [parameter].<br>
		All these commands start a new xmms session if xmms isn't running.<br>
 		<docsubtitle>Exported identifiers and functions</docsubtitle>
		<b>$xmmsIsRunning</b> : returns 1 if an xmms session is being run.<br>
		A special word is needed for this identifier.<br>
		It will not detect sessions that are running with an uid different
		that the kvirc is running.<br>
		<b>$xmmsIsPlaying</b> : returns 1 if xmms is playing a song, 0 if not.<br>
		<b>$xmmsIsPaused</b> : returns 1 is xmms is in pause mode.<br>
		<b>$xmmsCurrentPlaylistPos</b> : returns the index of the song that is being played.<br>
		<b>$xmmsPlaylistFileName(&lt;playlist_position&gt;)</b> : returns the file name
		of the song that is at &lt;playlist_posigion&gt; index in the playlist.<br>
		<b>$xmmsPlaylistTime(&lt;playlist_position&gt;)</b> : returns the duration
		of the song that is at &lt;playlist_posigion&gt; index in the playlist (in milliseconds).<br>
		<b>$xmmsPlaylistTitle(&lt;playlist_position&gt;)</b> : returns the title
		of the song that is at &lt;playlist_posigion&gt; index in the playlist.<br>
		<b>$xmmsPlaylistLength</b> : returns the length of the current playlist.<br>
		<b>$xmmsMainVolume</b> : returns the main volume setting.<br>
*/

void xmms_plugin_help()
{
	kvirc_plugin_show_help_page("doc_plugin_xmms.kvihelp");
}

KviPlugin kvirc_plugin =
{
	"xmms" ,
	"Remote control for the xmms program" ,
	"0.1" ,
	"Szymon Stefanek <stefanek@tin.it>" ,
	"Exports the /XMMS command,\n"\
	"a lot of related identifiers,\n"\
	"and a dockable controller.",
	xmms_plugin_init ,
	xmms_plugin_cleanup ,
	0 ,
	xmms_plugin_help
};

KviXmmsWidget::KviXmmsWidget(void * handle,KviStatusBar * parent,KviFrame * frame)
: KviDockableWidget(handle,parent)
{
	m_pFrm = frame;
	setMaximumWidth(146);
	setMinimumWidth(146);
	setMinimumHeight(16);
	setMaximumHeight(16);
	m_mousePressX = -1;
	setBackgroundMode(QWidget::NoBackground);
	m_timer = startTimer(KVI_XMMS_UPDATE_TIME);
}

KviXmmsWidget::~KviXmmsWidget()
{
}

void KviXmmsWidget::mousePressEvent(QMouseEvent * e)
{
	m_mousePressX = e->pos().x();
	if(!libxmms_remote_is_running(0)){
		KviProcess proc;
		proc.run("xmms");
	}
	if(m_mousePressX > 50){
		if(m_mousePressX < 66){
			libxmms_remote_playlist_prev(0);
//			sayWhatIsPlayed();
		} else if(m_mousePressX < 82){
			libxmms_remote_play(0);
			sayWhatIsPlayed();
		} else if(m_mousePressX < 98){
			libxmms_remote_pause(0);
		} else if(m_mousePressX < 114){
			libxmms_remote_stop(0);
		} else if(m_mousePressX < 130){
			libxmms_remote_playlist_next(0);
//			sayWhatIsPlayed();
		} else {
			libxmms_remote_eject(0);
		}
	} else {
		if(libxmms_remote_is_playing(0))sayWhatIsPlayed();
		else {
			kvirc_plugin_statusbar_message(m_pFrm,"[XMMS] : Stopped",5000);
		}
	}
	repaint();
}

void KviXmmsWidget::sayWhatIsPlayed()
{
	const char *song = libxmms_remote_get_playlist_title(0,libxmms_remote_get_playlist_pos(0));
	KviStr tmp(KviStr::Format,"[XMMS] : Playing \"%s\"",song);
	kvirc_plugin_statusbar_message(m_pFrm,tmp.ptr(),5000);
}

void KviXmmsWidget::mouseReleaseEvent(QMouseEvent *e)
{
	m_mousePressX = -1;
	repaint();
}

void KviXmmsWidget::paintEvent(QPaintEvent *)
{
	m_bIsPlaying = libxmms_remote_is_playing(0);
	m_bIsRunning = libxmms_remote_is_running(0);
	m_iPlaylistPos = libxmms_remote_get_playlist_pos(0);
	m_iPlaylistLen = libxmms_remote_get_playlist_length(0);

	QPainter p(this);
	p.drawPixmap(0,0,*g_pXmmsLogo,0,0,50,16);
	QColor clr(140,120,255);
	p.setPen(clr);

	QFont f(font());
	f.setFamily("clean");
	f.setPointSize(10);
	p.setFont(f);

	if(m_bIsPlaying){
		KviStr tmp(KviStr::Format,"%d of %d",m_iPlaylistPos + 1,m_iPlaylistLen);
		p.drawText(1,1,48,14,AlignCenter,tmp.ptr());
	} else {
		if(m_bIsRunning){
			KviStr tmp(KviStr::Format,"0 of %d",m_iPlaylistLen);
			p.drawText(1,1,48,14,AlignCenter,tmp.ptr());
		} else p.drawText(1,1,48,14,AlignCenter,"---");
	}
	// prev
	p.drawPixmap(50,0,((m_mousePressX >= 50) && (m_mousePressX < 66)) ?
			*g_pXmmsButtonsPressed : *g_pXmmsButtonsNormal,0,0,16,16);
	// play
	p.drawPixmap(66,0,((m_mousePressX >= 66) && (m_mousePressX < 82)) ?
			*g_pXmmsButtonsPressed : (m_bIsPlaying ? *g_pXmmsButtonsActive : *g_pXmmsButtonsNormal),16,0,16,16);
	// pause
	p.drawPixmap(82,0,((m_mousePressX >= 82) && (m_mousePressX < 98)) ?
			*g_pXmmsButtonsPressed : (libxmms_remote_is_paused(0) ? *g_pXmmsButtonsActive : *g_pXmmsButtonsNormal),32,0,16,16);
	// stop
	p.drawPixmap(98,0,((m_mousePressX >= 98) && (m_mousePressX < 114)) ?
			*g_pXmmsButtonsPressed : ((m_bIsPlaying || (!m_bIsRunning)) ? *g_pXmmsButtonsNormal : *g_pXmmsButtonsActive),48,0,16,16);
	// next
	p.drawPixmap(114,0,((m_mousePressX >= 114) && (m_mousePressX < 130)) ?
			*g_pXmmsButtonsPressed : *g_pXmmsButtonsNormal,64,0,16,16);
	// eject
	p.drawPixmap(130,0,((m_mousePressX >= 130) && (m_mousePressX < 146)) ?
			*g_pXmmsButtonsPressed : *g_pXmmsButtonsNormal,80,0,16,16);
}

void KviXmmsWidget::timerEvent(QTimerEvent *e)
{
	if(e->timerId() == m_timer){
		if(m_bIsRunning != libxmms_remote_is_running(0))repaint();
		else if(m_bIsPlaying != libxmms_remote_is_playing(0))repaint();
		else if(m_iPlaylistPos != libxmms_remote_get_playlist_pos(0))repaint();
		else if(m_iPlaylistLen != libxmms_remote_get_playlist_length(0))repaint();
	}
	KviDockableWidget::timerEvent(e);
}

#include "m_libkvixmms.moc"
