/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvistatsystraywidget.cpp ---
  *
  * This is a plugin for KVirc 2.0 Phoenix. It allows you to see
  * statistics of your IRC sessions - total words said etc.
  * More features are still to come.
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  *
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/

#define __KVIRC_PLUGIN__
#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>

#include "libkvistatsystraywidget.h"
#include "libkvistat.h"

#include "kvi_locale.h"

extern Display *g_display;
extern KviStatController * g_pStatPluginController;
extern QPixmap * g_pStatPluginSysTrayIcon;


KviStatSysTrayWidget::KviStatSysTrayWidget(KviSysTray * parent, KviFrame * frm,
	const char * tooltip)
:KviSysTrayWidget(parent,tooltip ? tooltip : __tr("Your statistics"))
{
	m_pFrm = frm;
	m_pParent = parent;
	rmbPopup = new QPopupMenu(0);
	rmbPopup->insertItem( _CHAR_2_QSTRING(__tr("Show StatWin")), g_pStatPluginController,
			SLOT( slotShowStats() ));
	rmbPopup->insertItem( _CHAR_2_QSTRING(__tr("Configure plugin")), g_pStatPluginController,
			SLOT( slotShowConfig() ));
	rmbPopup->insertItem( _CHAR_2_QSTRING(__tr("Reset stats")), g_pStatPluginController,
			SLOT( slotReset() ));
	rmbPopup->insertSeparator();
	rmbPopup->insertItem( _CHAR_2_QSTRING(__tr("Save stats file now")), g_pStatPluginController,
		SLOT(slotSaveStats()));
	rmbPopup->insertItem( _CHAR_2_QSTRING(__tr("Hide this widget")), this, SLOT(slotHide()));
	setBackgroundMode(NoBackground);
	emit wantOptions();
	wantScrolling = false;
	textXPos = 50;
	startTimer(1000); // 1 lags a lot!
	
	g_pStatPluginController->registerStatTray(this);
}

KviStatSysTrayWidget::~KviStatSysTrayWidget()
{
	g_pStatPluginController->unregisterStatTray(this);
}

void KviStatSysTrayWidget::mousePressEvent( QMouseEvent *ev )
{
	switch( ev->button() )
	{
		case QMouseEvent::RightButton:		// popup the menu
			rmbPopup->exec(QCursor::pos());
			break;

		default:
			break;
	}
}

void KviStatSysTrayWidget::timerEvent( QTimerEvent *ev )
{
	// Killing and restarting the timer is a hard job
	// Not better just to leave it running and maybe stop and restart it
	// then the textDelay has changed ?
	killTimers();
	if( textDirectionLeft )
		textXPos -= textJump;
	else
		textXPos += textJump;
	repaint(false);
	startTimer(textDelay);
}

// This code is taken from kvi_systray.cpp, since I had NO idea how to
// repaint the widget correctly
void KviStatSysTrayWidget::paintEvent( QPaintEvent *ev )
{
	if(!isVisibleToTLW())
		return;
		
	HANDLE hMemBuf   = m_pSysTray->getMemoryBufferHandle();
	GC the_gc        = XCreateGC(g_display,hMemBuf,0,0);

	bool temp = m_showWords;

	paintDefaultBackground(hMemBuf,the_gc);
	
	KviStr s, sw, sj, sk, sb, st;
	const KviStatChan * pCurrentChan = g_pStatPluginController->currentChan();

	if(g_pStatPluginController->showConsoleStats())
	{
		s.sprintf( __tr("Total statistics since %s"),
			g_pStatPluginController->startDate());
		m_showWords = true;	// this must be true here, since displaying numOnIrc
							// relays on that, that's why there is a temp bool
		sw.sprintf( __tr("Sessions: %d"),g_pStatPluginController->numOnIrc());
		sj.sprintf( __tr("Chans joins: %d"),g_pStatPluginController->numJoins());
		sk.sprintf( __tr("Kicks: %d"),g_pStatPluginController->numKicks());
		sb.sprintf( __tr("Bans: %d"),g_pStatPluginController->numBans());
		st.sprintf( __tr("Topics: %d"),g_pStatPluginController->numTopics());
	}
	else
		if(pCurrentChan)
		{
			s.sprintf( __tr("Stats for %s since %s"), pCurrentChan->name(),
				m_startDate.latin1());
			sw.sprintf( __tr("Words: %d"), pCurrentChan->words());
			sj.sprintf( __tr("Joins: %u"), pCurrentChan->joins());
			sk.sprintf( __tr("Kicks: %u"), pCurrentChan->kicks());
			sb.sprintf( __tr("Bans: %u"), pCurrentChan->bans());
			st.sprintf( __tr("Topics: %u"), pCurrentChan->topics());
		}
		else
		{
			s.sprintf(__tr("You must join a channel to see the stats"));
			sw = sj = sk = sb = st = s;
		}
	
	XSetForeground(g_display,the_gc,m_pSysTray->getForegroundPixel());
	
	int xpos;
	if( !scrollingWhen )
		wantScrolling = false;
	if(wantScrolling)
		xpos = textXPos;
	else
		xpos = 4;
	int slen = 0;	// length of the strings
	int spacelen = 0;	// length of spaces between the strings
	int font_width = 6;	// width of the font
	if(height() > 32)
	{
		// Big mode
		g_pOptions->m_fntSysTray.setPointSize(10);
		XSetFont(g_display,the_gc,g_pOptions->m_fntSysTray.handle());
		XDrawString(g_display,hMemBuf,the_gc,4,height() - 24,s.ptr(),s.len());
		g_pOptions->m_fntSysTray.setPointSize(12);
		XSetFont(g_display,the_gc,g_pOptions->m_fntSysTray.handle());
		font_width = QFontMetrics( g_pOptions->m_fntSysTray ).width("A");
		if( m_showWords )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 8,
				sw.ptr(), sw.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sw.ptr())+8;
			slen += sw.len();
			spacelen += 8;
		}
		if( m_showJoins )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 8 ,
				sj.ptr(), sj.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sj.ptr())+8;
			slen += sj.len();
			spacelen += 8;
		}
		if( m_showKicks )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 8,
				sk.ptr(), sk.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sk.ptr())+8;
			slen += sk.len();
			spacelen += 8;
		}
		if( m_showBans )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 8,
				sb.ptr(), sb.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sb.ptr())+8;
			slen += sb.len();
			spacelen += 8;
		}
		if( m_showTopics )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 8,
				st.ptr(), st.len());
//			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( st.ptr())+8;
			slen += st.len();
//			spacelen += 8;
		}
	}
	else
	{
		// Small mode
		g_pOptions->m_fntSysTray.setPointSize(12);
		XSetFont(g_display,the_gc,g_pOptions->m_fntSysTray.handle());
		font_width = QFontMetrics( g_pOptions->m_fntSysTray ).width("A");
		if( m_showWords )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 6,
				sw.ptr(), sw.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sw.ptr())+8;
			slen += sw.len();
			spacelen += 8;
		}
		if( m_showJoins )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 6,
				sj.ptr(), sj.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sj.ptr())+8;
			slen += sj.len();
			spacelen += 8;
		}
		if( m_showKicks )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 6,
				sk.ptr(), sk.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sk.ptr())+8;
			slen += sk.len();
			spacelen += 8;
		}
		if( m_showBans )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 6,
				sb.ptr(), sb.len());
			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( sb.ptr())+8;
			slen += sb.len();
			spacelen += 8;
		}
		if( m_showTopics )
		{
			XDrawString(g_display, hMemBuf, the_gc, xpos, height() - 6,
				st.ptr(), st.len());
//			xpos += QFontMetrics( g_pOptions->m_fntSysTray ).width( st.ptr())+8;
			slen += st.len();
//			spacelen += 8;
		}

	}

	paintDefaultFrame(hMemBuf,the_gc);

	XCopyArea(g_display,hMemBuf,this->handle(),the_gc,0,0,width(),height(),0,0);
	XFreeGC(g_display,the_gc);
	
	m_showWords = temp;

	if( textDirectionLeft )
	{
		if(textXPos + (font_width * slen) - spacelen - 60 <= 0)
			textXPos = width();
	}
	else
		if(textXPos >= width() )
			textXPos = - (font_width * slen) - spacelen + 60;

	if( scrollingWhen == 1 )		// 1 == ScrollingAlways
		wantScrolling = true;

// This sucks... won't work on variable width font... let's just leave it alone
// It isn't worth the effort ;)
/*
	if( (font_width * slen) + spacelen - (font_width * 10) >= width() )
		wantScrolling = true;
	else
		wantScrolling = false;
*/
}


QPixmap * KviStatSysTrayWidget::icon()
{
	return g_pStatPluginSysTrayIcon;
}

void KviStatSysTrayWidget::setOptions( bool sw, bool sj, bool sk, bool sb,
	bool st)
{
	m_showWords = sw; m_showJoins = sj; m_showKicks = sk, m_showBans = sb;
	m_showTopics = st;
}

void KviStatSysTrayWidget::setScrollingOptions( int when, int delay, int jump,
	bool dirLeft )
{
	scrollingWhen = when;
	textJump = jump;
	textDelay = delay;
	textDirectionLeft = dirLeft;
}

void KviStatSysTrayWidget::slotHide()
{
	m_pSysTray->removeWidget(this, true);
}

#include "libkvistatsystraywidget.moc"

