#ifndef _SEX_EDITOR_
#define _SEX_EDITOR_

#include <qtableview.h>
#include <qcolor.h>
#include <qcstring.h>
#include <qlist.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include <qframe.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qfont.h>

#include <X11/Xlib.h>

typedef struct _SSEXEditorColors
{
	QColor background;
	QColor extBackground;
	QColor normalText;
	QColor cursor;

	QFont  font;

	QColor cppBackground;
	QColor cppExtBackground;
	QColor cppNormalText;
	QColor cppCursor;
	QColor cppBrace;
	QColor cppLineComment;
	QColor cppMultilineComment;
	QColor cppParenthesis;
	QColor cppOperator;
	QColor cppEscape;
	QColor cppChar;
	QColor cppString;
	QColor cppKeyword;
	QColor cppType;
	QColor cppNumber;
	QColor cppPunctuation;
	QColor cppSystemIdentifier;
	QColor cppPreprocessor;
	QColor cppInclude;
	QColor cppMemberVariable;
	QColor cppGlobalVariable;
	QColor cppQClass;
	QColor cppQSignals;

	QColor cppKClass;
	QColor cppXStuff;
	QColor cppGtkStruct;
	QColor cppGdkStruct;
	QColor cppGType;
	QColor cppGtkCall;
	QColor cppGdkCall;
	QColor cppGtkMacro;
	QColor cppGdkMacro;
	QColor cppGMacro;

	QFont  cppFont;

	QColor cppSpecial;


	QColor htmlBackground;
	QColor htmlExtBackground;
	QColor htmlNormalText;
	QColor htmlCursor;
	QColor htmlComment;
	QColor htmlTag;
	QColor htmlString;
	QColor htmlTagInternal;

	QFont htmlFont;

} SSEXEditorColors;


#define SSEX_EDITOR_BEGIN_IN_COMMENT 1
#define SSEX_EDITOR_END_IN_COMMENT 2
#define SSEX_EDITOR_BEGIN_IN_TAG 4
#define SSEX_EDITOR_END_IN_TAG 8

typedef struct _SSEXEditorTextLine
{
	int      width;
	QCString text;
	int      length;
	int      flags;
} SSEXEditorTextLine;

typedef struct _SSEXEditorKeystroke
{
	int  ascii;
	int  state;
	int  key;
} SSEXEditorKeystroke;

class SSEXEditor;

class SSEXFindWidget : public QFrame
{
	friend class SSEXEditor;
	Q_OBJECT
public:
	SSEXFindWidget(SSEXEditor * parent);
	~SSEXFindWidget();
protected:
	QPoint m_pressPoint;
	SSEXEditor * m_pEditor;
	QLineEdit *m_pFindStringEdit;
	QLineEdit *m_pReplaceStringEdit;
	QCheckBox *m_pRegExpCheckBox;
	QCheckBox *m_pCaseSensitiveCheckBox;
	QPushButton *m_pReplace;
	QPushButton *m_pReplaceAndFindNext;
	QPushButton *m_pReplaceAllInSelection;
protected:
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
protected slots:
	void findNextClicked();
	void findPrevClicked();
	void replaceAllClicked();
	void replaceAndFindNextClicked();
	void replaceAllInSelectionClicked();
//	void regExpCheckBoxToggled(bool bDown);
};



// Q_PROPERTY Trick:
//    We set a special property on the widgets that should keep their focus
//    when tab is pressed , and they want to process the tab.
//    the READ method is a dummy int function!

class SSEXEditor : public QTableView
{
	Q_OBJECT
	Q_PROPERTY( int KviProperty_FocusOwner READ cursorCol )
public:
	SSEXEditor(QWidget * parent);
	~SSEXEditor();
	enum ColorMode { Normal , Cpp , Html };
protected:
	SSEXEditorColors * m_pColors;
	QList<SSEXEditorTextLine> * m_pLines;
	QList<SSEXEditorKeystroke> * m_pKeystrokes;
	ColorMode m_mode;
	int m_iTabsNumSpaces;
	int m_iBlinkTime;
	QPopupMenu *m_pContextPopup;
	QPopupMenu *m_pFindPopup;
	SSEXFindWidget * m_pFindWidget;
private:
	// Font dependant variables
	int m_iTabsNumPixels;
	int m_iCursorRow;      // Line in which the cursor is
	int m_iCursorPosition;  // The cursor is just before this character in the line
	int m_iCursorPositionInPixels;
	int m_iLastCursorRow;
	int m_iLastCursorPosition;
	int m_iCharWidth[256];
	// Internal
	int m_iMaxTextWidth;
	int m_iMaxTextWidthLine;
	int m_iFontAscent;
	int m_iFontLineSpacing;
	QPoint m_selection1; // selection anchors (char coords)
	QPoint m_selection2; // selection anchors (char coords)
	QPoint m_mouseAnchor; // mouse press selection anchor (char coords)
	QPoint m_lastMousePressCoords;
	bool m_bHasSelection;
	QTimer  * m_pBlinkTimer;
	QTimer  * m_pDragTimer;
	QPixmap * m_pMemBuffer;
	QCString m_szFileName;
//	QCString m_szTextToFind;
	bool      m_bCursorOn;
	bool      m_bOverwrite;
	bool      m_bRecordingKeystrokes;
	bool      m_bModified;
	QPoint m_lastFindWidgetPosition;
public:
	// Returns true if the file has not been modified
	// If the file has been modified it opens a dialog
	// that asks the user to save or discard the changes
	// and gives the possibility to cancel the close event.
	// If the user cancels the close event this function returns false
	
	bool closeFile();
	bool isModified(){ return m_bModified; };
	void setColors(SSEXEditorColors *clrs);
	QCString fileName(){ return m_szFileName; };
	void setModified(bool bModified = true);
	void setBlinkTime(int blinkTime);
	int blinkTime(){ return m_iBlinkTime; };
	void setTabsNumSpaces(int spaces);
	int tabsNumSpaces(){ return m_iTabsNumSpaces; };
	virtual void setFont(const QFont &f);
	void setText(const QCString &text);
	void clear();
	bool loadFile(const char *filename);
	bool saveFile(const char *filename);
	void cursorUp(bool bSelect);
	void cursorDown(bool bSelect);
	void cursorLeft(bool bSelect);
	void cursorRight(bool bSelect);
	void cursorPageUp(bool bSelect);
	void cursorPageDown(bool bSelect);
	void cursorHome(bool bSelect);
	void cursorEnd(bool bSelect);
	int cursorRow(){ return m_iCursorRow; };
	int cursorCol() const;
	void clearSelection(bool bUpdate = true);
	bool hasSelection(){ return m_bHasSelection; };

	void insertChar(char c);
	void newLine();
	void backspace();
	void del();
	QCString selectedText();
	void insertText(QCString &text,bool bUpdate = true,bool bRecalcWidths = true);
	void indent();
	void unindent();
	void commentOut(bool bAlternative);
	void removeComment();
	void setMode(ColorMode mode);
	virtual void keyPressEvent(QKeyEvent *e);
public slots:
	bool saveFile();
	bool saveFileAs();
	void recordKeystrokes();
	void replayKeystrokes();
	void cut();
	void copy();
	void paste();
	void switchMode();
	void toggleFindWidget();
	void findNext();
	void findPrev();
	void findNextRegExp();
	void findPrevRegExp();
	void replace();
	void replaceAll();
	void replaceAllRegExp();
	void replaceAllInSelection();
	void replaceAllInSelectionRegExp();
	void replaceAndFindNext();
	void replaceAndFindNextRegExp();
signals:
	void modifyStateChanged(SSEXEditor *ed,bool bModified);
	void fileNameChanged(SSEXEditor *ed,const QCString &newFileName);
	void saved(const QCString &fileName);
	void saveProgress(const QCString &fileName,int progress);
	void modeChanged(SSEXEditor *ed,ColorMode mode);
	void cursorPositionChanged(SSEXEditor *ed,int row,int col);
	void recordingKeystrokes(bool bRecording);
	void gainedFocus(SSEXEditor *ed);
	void rightClickOnTextRow(SSEXEditor *ed,const QCString &text,int charIndex,QPopupMenu *contextPopup);
	void textMessage(SSEXEditor *ed,const QCString &msg);
protected:
	void contextPopup(SSEXEditorTextLine *l,int charIndex);
	void startBlinking();
	void stopBlinking();

	void setHasSelection(bool bHasSelection);
	virtual void focusInEvent(QFocusEvent *e);
	virtual void focusOutEvent(QFocusEvent *e);
	virtual void paintCell(QPainter * p,int row,int);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);

	void paintCellNormal(QPainter * p,SSEXEditorTextLine * l,int row);
	void paintCellCpp(QPainter * p,SSEXEditorTextLine *l,int row);
	void paintCellHtml(QPainter * p,SSEXEditorTextLine *l,int row);
	void paintSelection(int row,SSEXEditorTextLine *l,Display *dpy,Drawable drw,GC gc,QRect &updateR);
	void paintCursor(Display *dpy,Drawable drw,GC gc,QColor * pColor,SSEXEditorTextLine *l);

	void ensureSelectionCoherent();
	void setSelectionCoords(int x1,int row1,int x2,int row2);
	void selectionCursorMovement(const QPoint &oldCursorPos,const QPoint &newCursorPos);

	void killSelection(bool bUpdate,bool bRecalcWidths = true);

	void recalcCursorPosition(SSEXEditorTextLine *l);
	void ensureCursorVisible();
	void setBottomCell(int row);
//	virtual void resizeEvent(QResizeEvent *e);
	int getTextWidthWithTabsForCursorPosition(const char *text,int cursorPos);
	int getTextWidthWithTabs(const char *text);
	int findCharacterAt(int xPositionInCell,SSEXEditorTextLine * l);
	void updateCellSize();
	void updateMaxTextWidth();
	void updateFontDependantVariables();
	QColor * cppModeGetTokenColor(const char * token,int len);
	void initializeCurrentMode();
	void htmlModeComputeTagState(SSEXEditorTextLine *start);
	void cppModeComputeCommentState(SSEXEditorTextLine * start);
//	cppModeGetToken(SSEXEditorCppModeAuxStruct * aux);
protected slots:
	void blinkTimer();
	void dragTimer();
};

#endif
